/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.derby;

import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.derby.DerbyDdlBuilder;
import org.jumpmind.db.platform.derby.DerbyDdlReader;
import org.jumpmind.db.platform.derby.DerbyJdbcSqlTemplate;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class DerbyDatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "org.apache.derby.jdbc.ClientDriver";
    public static final String JDBC_DRIVER_EMBEDDED = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String JDBC_SUBPROTOCOL = "derby";

    public DerbyDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
    }

    protected DerbyDdlBuilder createDdlBuilder() {
        return new DerbyDdlBuilder();
    }

    @Override
    protected DerbyDdlReader createDdlReader() {
        return new DerbyDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected DerbyJdbcSqlTemplate createSqlTemplate() {
        return new DerbyJdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
    }

    public boolean allowsUniqueIndexDuplicatesWithNulls() {
        return false;
    }

    public String getName() {
        return JDBC_SUBPROTOCOL;
    }

    public String getDefaultSchema() {
        if (StringUtils.isBlank((CharSequence)this.defaultSchema)) {
            this.defaultSchema = (String)this.getSqlTemplate().queryForObject("values CURRENT SCHEMA", String.class, new Object[0]);
        }
        return this.defaultSchema;
    }

    public String getDefaultCatalog() {
        return "";
    }

    public boolean isClob(Column column) {
        int type = column.getMappedTypeCode();
        return type == 2005;
    }

    public boolean canColumnBeUsedInWhereClause(Column column) {
        return !column.isOfBinaryType() && column.getJdbcTypeCode() != 2005 && column.getJdbcTypeCode() != -1 && column.getJdbcTypeCode() != -16 && super.canColumnBeUsedInWhereClause(column);
    }

    public PermissionResult getCreateSymTriggerPermission() {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        String triggerSql = "CREATE TRIGGER TEST_TRIGGER AFTER UPDATE ON " + delimiter + "SYM_PERMISSION_TEST" + delimiter + " FOR EACH ROW MODE DB2SQL INSERT INTO " + delimiter + "SYM_PERMISSION_TEST" + delimiter + " VALUES(NULL,NULL)";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, triggerSql);
        try {
            this.getSqlTemplate().update(triggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE TRIGGER permission or TRIGGER permission");
        }
        return result;
    }

    public boolean supportsLimitOffset() {
        return this.sqlTemplate.getDatabaseMinorVersion() >= 4;
    }

    public String massageForLimitOffset(String sql, int limit, int offset) {
        if (this.supportsLimitOffset()) {
            int minorVersion;
            if (sql.endsWith(";")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            if ((minorVersion = this.sqlTemplate.getDatabaseMinorVersion()) >= 7) {
                if (minorVersion >= 9) {
                    return sql + " { limit " + limit + " offset " + offset + " }";
                }
                return sql + " offset " + offset + " rows fetch next " + limit + " rows only;";
            }
            int orderIndex = StringUtils.lastIndexOfIgnoreCase((CharSequence)sql, (CharSequence)"order by");
            String order = sql.substring(orderIndex);
            String innerSql = sql.substring(0, orderIndex - 1);
            innerSql = StringUtils.replaceIgnoreCase((String)innerSql, (String)" from", (String)(", ROW_NUMBER() over (" + order + ") as RowNum from"));
            return "select * from (" + innerSql + ") where RowNum between " + (offset + 1) + " and " + (offset + limit);
        }
        return sql;
    }
}

