/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.hsqldb;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;

public class HsqlDbDdlReader
extends AbstractJdbcDdlReader {
    public HsqlDbDdlReader(IDatabasePlatform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Table table = super.readTable(connection, metaData, values);
        if (table != null) {
            this.determineAutoIncrementFromResultSetMetaData(connection, table, table.getPrimaryKeyColumns());
        }
        return table;
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        if (TypeMap.isTextType((int)column.getMappedTypeCode()) && column.getDefaultValue() != null) {
            column.setDefaultValue(this.unescape(column.getDefaultValue(), "'", "''"));
        }
        if (column.getMappedTypeCode() == 93) {
            this.adjustColumnSize(column, -20, 3);
        }
        if (column.getMappedTypeCode() == 92) {
            this.adjustColumnSize(column, -9, 3);
        }
        if (column.getMappedTypeCode() == 91) {
            this.removeColumnSize(column);
        }
        return column;
    }

    @Override
    protected boolean isInternalForeignKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, ForeignKey fk, IIndex index) {
        String name = index.getName();
        return name != null && name.startsWith("SYS_IDX_");
    }

    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) {
        String name = index.getName();
        return name != null && (name.startsWith("SYS_PK_") || name.startsWith("SYS_IDX_"));
    }

    @Override
    public List<Trigger> getTriggers(String catalog, String schema, String tableName) throws SqlException {
        ArrayList<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "SELECT * FROM INFORMATION_SCHEMA.TRIGGERS WHERE TABLE_NAME=? and TRIGGER_SCHEMA=? and TRIGGER_CATALOG=? ;";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger mapRow(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("TRIGGER_NAME"));
                trigger.setCatalogName(row.getString("TRIGGER_CATALOG"));
                trigger.setSchemaName(row.getString("TRIGGER_SCHEMA"));
                trigger.setTableName(row.getString("TABLE_NAME"));
                trigger.setEnabled(true);
                trigger.setSource(row.getString("SQL"));
                row.remove((Object)"SQL");
                String triggerType = row.getString("TRIGGER_TYPE");
                if (triggerType.equals("DELETE") || triggerType.equals("INSERT") || triggerType.equals("UPDATE")) {
                    trigger.setTriggerType(Trigger.TriggerType.valueOf((String)triggerType));
                }
                trigger.setMetaData((Map)row);
                return trigger;
            }
        }, new Object[]{tableName, schema, catalog});
        return triggers;
    }
}

