/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.mysql;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Transaction;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.mysql.MySqlDdlBuilder;
import org.jumpmind.db.platform.mysql.MySqlDdlReader;
import org.jumpmind.db.platform.mysql.MySqlJdbcSqlTemplate;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.util.VersionUtil;

public class MySqlDatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "com.mysql.jdbc.Driver";
    public static final String JDBC_DRIVER_OLD = "org.gjt.mm.mysql.Driver";
    public static final String JDBC_SUBPROTOCOL = "mysql";

    public MySqlDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, MySqlDatabasePlatform.overrideSettings(settings));
        String versionString = this.getSqlTemplate().getDatabaseProductVersion();
        if (VersionUtil.isOlderThanVersion((String)versionString, (String)"8.0")) {
            this.ddlBuilder.getDatabaseInfo().setCanDeleteUsingExists(false);
        }
        if (VersionUtil.isOlderThanVersion((String)versionString, (String)"5.6")) {
            DatabaseInfo databaseInfo = this.ddlBuilder.getDatabaseInfo();
            databaseInfo.setHasSize(93, false);
            databaseInfo.setHasSize(-101, false);
            databaseInfo.setHasSize(-102, false);
            databaseInfo.setHasSize(92, false);
            databaseInfo.setHasSize(-103, false);
        }
    }

    protected MySqlDdlBuilder createDdlBuilder() {
        return new MySqlDdlBuilder();
    }

    @Override
    protected MySqlDdlReader createDdlReader() {
        return new MySqlDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected MySqlJdbcSqlTemplate createSqlTemplate() {
        return new MySqlJdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
    }

    protected static SqlTemplateSettings overrideSettings(SqlTemplateSettings settings) {
        if (settings == null) {
            settings = new SqlTemplateSettings();
        }
        settings.setFetchSize(Integer.MIN_VALUE);
        return settings;
    }

    public String getName() {
        return JDBC_SUBPROTOCOL;
    }

    public String getDefaultSchema() {
        return null;
    }

    public String getDefaultCatalog() {
        if (StringUtils.isBlank((CharSequence)this.defaultCatalog)) {
            this.defaultCatalog = (String)this.getSqlTemplate().queryForObject("select database()", String.class, new Object[0]);
        }
        return this.defaultCatalog;
    }

    protected PermissionResult getCreateSymTablePermission(Database database) {
        String defaultEngine;
        String createSql = this.ddlBuilder.createTables(database, false);
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TABLE, createSql);
        String versionString = this.getSqlTemplate().getDatabaseProductVersion();
        if (!VersionUtil.isOlderThanVersion((String)versionString, (String)"5.1.5") && !StringUtils.equalsIgnoreCase((CharSequence)(defaultEngine = this.getSqlTemplate().queryForString("select engine from information_schema.engines where support='DEFAULT';", new Object[0])), (CharSequence)"innodb")) {
            result.setStatus(PermissionResult.Status.FAIL);
            result.setSolution("Set the default storage engine to InnoDB.");
            return result;
        }
        Table table = this.getPermissionTableDefinition();
        this.getDropSymTablePermission();
        try {
            database.addTable(table);
            this.createDatabase(database, false, false);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE permission");
        }
        return result;
    }

    public PermissionResult getCreateSymTriggerPermission() {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        String triggerSql = "CREATE TRIGGER TEST_TRIGGER AFTER UPDATE ON " + delimiter + "SYM_PERMISSION_TEST" + delimiter + " FOR EACH ROW INSERT INTO " + delimiter + "SYM_PERMISSION_TEST" + delimiter + " VALUES(NULL,NULL)";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, triggerSql);
        try {
            this.getSqlTemplate().update(triggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE TRIGGER permission or TRIGGER permission");
        }
        return result;
    }

    public PermissionResult getCreateSymRoutinePermission() {
        String routineSql = "CREATE PROCEDURE TEST_PROC() BEGIN SELECT 1; END";
        String dropSql = "DROP PROCEDURE IF EXISTS TEST_PROC";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_ROUTINE, dropSql + "\r\n" + routineSql + "\r\n" + dropSql);
        try {
            this.getSqlTemplate().update(dropSql, new Object[0]);
            this.getSqlTemplate().update(routineSql, new Object[0]);
            this.getSqlTemplate().update(dropSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE ROUTINE Privilege");
        }
        return result;
    }

    public PermissionResult getLogMinePermission() {
        PermissionResult result = new PermissionResult(PermissionType.LOG_MINE, "Use LogMiner");
        StringBuilder solution = new StringBuilder();
        Row row = this.getSqlTemplate().queryForRow("show variables like 'log_bin'", new Object[0]);
        if (row == null || !StringUtils.equalsIgnoreCase((CharSequence)row.getString("Value"), (CharSequence)"ON")) {
            solution.append("Use the --log-bin option at startup. ");
        }
        if ((row = this.getSqlTemplate().queryForRow("show variables like 'binlog_format'", new Object[0])) == null || !StringUtils.equalsIgnoreCase((CharSequence)row.getString("Value"), (CharSequence)"ROW")) {
            solution.append("Set the binlog_format system variable to \"ROW\". ");
        }
        if ((row = this.getSqlTemplate().queryForRow("show variables like 'enforce_gtid_consistency'", new Object[0])) == null || !StringUtils.equalsIgnoreCase((CharSequence)row.getString("Value"), (CharSequence)"ON")) {
            solution.append("Set the enforce_gtid_consistency system variable to \"ON\". ");
        }
        if ((row = this.getSqlTemplate().queryForRow("show variables like 'gtid_mode'", new Object[0])) == null || !StringUtils.equalsIgnoreCase((CharSequence)row.getString("Value"), (CharSequence)"ON")) {
            solution.append("Set the gtid_mode system variable to \"ON\".");
        }
        if (solution.length() > 0) {
            result.setStatus(PermissionResult.Status.FAIL);
            result.setSolution(solution.toString());
        } else {
            result.setStatus(PermissionResult.Status.PASS);
        }
        return result;
    }

    public void makePlatformSpecific(Database database) {
        for (Table table : database.getTables()) {
            for (Column column : table.getColumns()) {
                try {
                    if (column.getMappedTypeCode() != 91 || column.findPlatformColumn("oracle") == null || column.findPlatformColumn("oracle122") == null || column.findPlatformColumn("oracle23") == null) continue;
                    column.setMappedType("TIMESTAMP");
                    column.setMappedTypeCode(93);
                    column.setScale(6);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        super.makePlatformSpecific(database);
    }

    public long getEstimatedRowCount(Table table) {
        return this.getSqlTemplateDirty().queryForLong("select ifnull(table_rows,-1) from information_schema.tables where table_name = ? and table_schema = ?", new Object[]{table.getName(), table.getCatalog()});
    }

    public boolean canColumnBeUsedInWhereClause(Column column) {
        if (column.getMappedTypeCode() == -3 && column.getSizeAsInt() <= 8000 || column.getMappedTypeCode() == -2) {
            return true;
        }
        return !column.isOfBinaryType() && super.canColumnBeUsedInWhereClause(column);
    }

    public List<Transaction> getTransactions() {
        ISqlTemplate template = this.getSqlTemplate();
        String transactionString = "trx";
        String lockWaitsString = "information_schema.innodb_lock_waits";
        if (template.getDatabaseMajorVersion() >= 8) {
            transactionString = "engine_transaction";
            lockWaitsString = "performance_schema.data_lock_waits";
        }
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        if (template.getDatabaseMajorVersion() == 5 && template.getDatabaseMinorVersion() <= 5) {
            String sql = "SELECT  b.trx_id,  b.trx_started,  b.trx_state,  b.trx_rows_modified,  w.blocking_" + transactionString + "_id 'blockingId',  b.trx_query FROM " + lockWaitsString + " w RIGHT JOIN information_schema.innodb_trx b  ON b.trx_id = w.requesting_" + transactionString + "_id;";
            for (Row row : template.query(sql)) {
                Transaction transaction = new Transaction(row.getString("trx_id"), "", row.getString("blockingId"), row.getDateTime("trx_started"), row.getString("trx_query"));
                transaction.setStatus(row.getString("trx_state"));
                transaction.setWrites(row.getInt("trx_rows_modified"));
                transactions.add(transaction);
            }
            return transactions;
        }
        String sql = "SELECT  b.trx_id,  t.processlist_user,  t.processlist_host,  b.trx_started,  b.trx_state,  b.trx_rows_modified,  w.blocking_" + transactionString + "_id 'blockingId',  b.trx_query FROM " + lockWaitsString + " w RIGHT JOIN information_schema.innodb_trx b  ON b.trx_id = w.requesting_" + transactionString + "_id INNER JOIN performance_schema.threads t  ON b.trx_mysql_thread_id = t.thread_id;";
        for (Row row : template.query(sql)) {
            Transaction transaction = new Transaction(row.getString("trx_id"), row.getString("processlist_user"), row.getString("blockingId"), row.getDateTime("trx_started"), row.getString("trx_query"));
            transaction.setRemoteHost(row.getString("processlist_host"));
            transaction.setStatus(row.getString("trx_state"));
            transaction.setWrites(row.getInt("trx_rows_modified"));
            transactions.add(transaction);
        }
        return transactions;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String massageForLimitOffset(String sql, int limit, int offset) {
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql + " limit " + offset + "," + limit;
    }

    public boolean supportsSliceTables() {
        return true;
    }

    public String getSliceTableSql(String columnName, int sliceNum, int totalSlices) {
        return "ascii(substring(" + columnName + ", 1, 1)) % " + totalSlices + " = " + sliceNum;
    }

    public String getCharSetName() {
        return (String)this.getSqlTemplate().queryForObject("select @@character_set_database", String.class, new Object[0]);
    }
}

