/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.oracle;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.sql.SymmetricLobHandler;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;

public class OracleLobHandler
extends SymmetricLobHandler {
    DefaultLobHandler longHandler = new DefaultLobHandler();

    public OracleLobHandler(SqlTemplateSettings.JdbcLobHandling jdbcLobHandling) {
        super((LobHandler)new DefaultLobHandler());
        if (jdbcLobHandling == SqlTemplateSettings.JdbcLobHandling.CREATETEMPORARYLOB) {
            ((DefaultLobHandler)this.getDefaultHandler()).setCreateTemporaryLob(true);
        } else if (jdbcLobHandling == SqlTemplateSettings.JdbcLobHandling.STREAMLOB) {
            ((DefaultLobHandler)this.getDefaultHandler()).setStreamAsLob(true);
        }
    }

    @Override
    public String getClobAsString(ResultSet rs, int columnIndex, int jdbcTypeCode, String jdbcTypeName) throws SQLException {
        if ("LONG".equalsIgnoreCase(jdbcTypeName)) {
            return this.longHandler.getClobAsString(rs, columnIndex);
        }
        return super.getClobAsString(rs, columnIndex, jdbcTypeCode, jdbcTypeName);
    }
}

