/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.postgresql;

import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jumpmind.db.platform.postgresql.PostgreSqlDatabasePlatform;
import org.jumpmind.db.sql.SymmetricLobHandler;

public class PostgresLobHandler
extends SymmetricLobHandler {
    @Override
    public boolean needsAutoCommitFalseForBlob(int jdbcTypeCode, String jdbcTypeName) {
        return PostgreSqlDatabasePlatform.isBlobStoredByReference(jdbcTypeName);
    }

    @Override
    public byte[] getBlobAsBytes(ResultSet rs, int columnIndex, int jdbcTypeCode, String jdbcTypeName) throws SQLException {
        if (PostgreSqlDatabasePlatform.isBlobStoredByReference(jdbcTypeName)) {
            return PostgresLobHandler.getLoColumnAsBytes(rs, columnIndex);
        }
        return this.getDefaultHandler().getBlobAsBytes(rs, columnIndex);
    }

    public static byte[] getLoColumnAsBytes(ResultSet rs, int columnIndex) throws SQLException {
        Blob blob = rs.getBlob(columnIndex);
        if (blob != null) {
            return blob.getBytes(1L, (int)blob.length());
        }
        return null;
    }
}

