/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.voltdb;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.JdbcSqlTransaction;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.sql.SymmetricLobHandler;

public class VoltDbJdbcSqlTemplate
extends JdbcSqlTemplate {
    public VoltDbJdbcSqlTemplate(DataSource dataSource, SqlTemplateSettings settings, SymmetricLobHandler lobHandler, DatabaseInfo databaseInfo) {
        super(dataSource, settings, lobHandler, databaseInfo);
        settings.setResultSetType(1004);
        settings.setOverrideIsolationLevel(8);
    }

    @Override
    public boolean isUniqueKeyViolation(Throwable ex) {
        SQLException sqlEx = this.findSQLException(ex);
        return sqlEx != null && sqlEx.getMessage() != null && sqlEx.getMessage().contains("Constraint Type UNIQUE");
    }

    @Override
    public int getIsolationLevel() {
        return 8;
    }

    @Override
    public ISqlTransaction startSqlTransaction() {
        return new JdbcSqlTransaction(this, true);
    }

    @Override
    protected void setTinyIntValue(PreparedStatement ps, int i, Object arg, int argType) throws SQLException {
        if (arg instanceof Integer) {
            Integer integer = (Integer)arg;
            super.setTinyIntValue(ps, i, integer.byteValue(), argType);
        } else {
            super.setTinyIntValue(ps, i, arg, argType);
        }
    }

    @Override
    protected int verifyArgType(Object arg, int argType) {
        if (argType == 1) {
            return 12;
        }
        if (arg instanceof Byte) {
            return -6;
        }
        if (arg instanceof Short) {
            return 5;
        }
        if (arg instanceof Integer) {
            return 4;
        }
        if (arg instanceof Long) {
            return -5;
        }
        if (arg instanceof Double) {
            return 8;
        }
        if (arg instanceof BigDecimal) {
            return 3;
        }
        if (arg instanceof Timestamp) {
            return 93;
        }
        return super.verifyArgType(arg, argType);
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long insertWithGeneratedKey(Connection conn, String sql, String column, String sequenceName, Object[] args, int[] types) throws SQLException {
        long key = 0L;
        PreparedStatement ps = null;
        try {
            Statement st = null;
            ResultSet rs = null;
            try {
                st = conn.createStatement();
                rs = st.executeQuery("select max(data_id)+1 from sym_data");
                if (rs.next()) {
                    key = rs.getLong(1);
                }
            }
            catch (Throwable throwable) {
                VoltDbJdbcSqlTemplate.close(rs);
                VoltDbJdbcSqlTemplate.close(st);
                throw throwable;
            }
            VoltDbJdbcSqlTemplate.close(rs);
            VoltDbJdbcSqlTemplate.close(st);
            String replaceSql = sql.replaceFirst("\\(null,", "(" + key + ",");
            ps = conn.prepareStatement(replaceSql);
            ps.setQueryTimeout(this.settings.getQueryTimeout());
            this.setValues(ps, args, types, this.lobHandler.getDefaultHandler());
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            VoltDbJdbcSqlTemplate.close(ps);
            throw throwable;
        }
        VoltDbJdbcSqlTemplate.close(ps);
        return key;
    }
}

