/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.driver;

import org.jumpmind.driver.StatementInterceptor;
import org.jumpmind.properties.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementDelayInterceptor
extends StatementInterceptor {
    private static final Logger log = LoggerFactory.getLogger(StatementDelayInterceptor.class);
    private long delay = 10L;

    public StatementDelayInterceptor(Object wrapped, TypedProperties systemPlusEngineProperties) {
        super(wrapped, systemPlusEngineProperties);
        String delayProperty = StatementDelayInterceptor.class.getName() + ".delay";
        String delayValue = systemPlusEngineProperties.get(delayProperty);
        if (delayValue != null) {
            this.delay = Long.parseLong(delayValue.trim());
        }
    }

    @Override
    public void preparedStatementExecute(String methodName, long elapsed, String sql) {
        if (sql.toLowerCase().startsWith("insert") || sql.toLowerCase().startsWith("update")) {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            log.info("PreparedStatement." + methodName + " DELAYED (" + (elapsed + this.delay) + "ms.) " + sql);
        }
    }

    @Override
    public void statementExecute(String methodName, long elapsed, Object ... parameters) {
        super.statementExecute(methodName, elapsed, parameters);
    }
}

