/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.driver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jumpmind.db.sql.LogSqlBuilder;
import org.jumpmind.driver.InterceptResult;
import org.jumpmind.driver.PreparedStatementWrapper;
import org.jumpmind.driver.StatementWrapper;
import org.jumpmind.driver.WrapperInterceptor;
import org.jumpmind.properties.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementInterceptor
extends WrapperInterceptor {
    private static final Logger log = LoggerFactory.getLogger(StatementInterceptor.class);
    protected List<Object> psArgs = new ArrayList<Object>();
    protected LogSqlBuilder sqlBuilder = new LogSqlBuilder();

    public StatementInterceptor(Object wrapped, TypedProperties systemPlusEngineProperties) {
        super(wrapped);
    }

    @Override
    public InterceptResult preExecute(String methodName, Object ... parameters) {
        if (this.getWrapped() instanceof PreparedStatementWrapper) {
            return this.preparedStatementPreExecute((PreparedStatementWrapper)this.getWrapped(), methodName, parameters);
        }
        return new InterceptResult();
    }

    protected InterceptResult preparedStatementPreExecute(PreparedStatementWrapper ps, String methodName, Object[] parameters) {
        if (methodName.startsWith("set") && parameters != null && parameters.length > 1) {
            this.psArgs.add(parameters[1]);
        }
        return new InterceptResult();
    }

    @Override
    public InterceptResult postExecute(String methodName, Object result, long startTime, long endTime, Object ... parameters) {
        if (this.getWrapped() instanceof PreparedStatementWrapper) {
            return this.preparedStatementPostExecute((PreparedStatementWrapper)this.getWrapped(), methodName, result, startTime, endTime, parameters);
        }
        if (this.getWrapped() instanceof StatementWrapper) {
            return this.statementPostExecute((StatementWrapper)this.getWrapped(), methodName, result, startTime, endTime, parameters);
        }
        return new InterceptResult();
    }

    public InterceptResult preparedStatementPostExecute(PreparedStatementWrapper ps, String methodName, Object result, long startTime, long endTime, Object ... parameters) {
        if (methodName.startsWith("execute")) {
            long elapsed = endTime - startTime;
            String sql = this.sqlBuilder.buildDynamicSqlForLog(ps.getStatement(), this.psArgs.toArray(), null);
            this.preparedStatementExecute(methodName, elapsed, sql);
        }
        return new InterceptResult();
    }

    public InterceptResult statementPostExecute(StatementWrapper ps, String methodName, Object result, long startTime, long endTime, Object ... parameters) {
        if (methodName.startsWith("execute")) {
            long elapsed = endTime - startTime;
            this.statementExecute(methodName, elapsed, parameters);
        }
        return new InterceptResult();
    }

    public void preparedStatementExecute(String methodName, long elapsed, String sql) {
        log.info("PreparedStatement." + methodName + " (" + elapsed + "ms.) " + sql);
    }

    public void statementExecute(String methodName, long elapsed, Object ... parameters) {
        log.info("Statement." + methodName + " (" + elapsed + "ms.) " + Arrays.toString(parameters));
    }
}

