/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.alter;

import org.jumpmind.db.alter.TableChangeImplBase;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DdlException;

public class AddForeignKeyChange
extends TableChangeImplBase {
    private ForeignKey _newForeignKey;

    public AddForeignKeyChange(Table table, ForeignKey newForeignKey) {
        super(table);
        this._newForeignKey = newForeignKey;
    }

    public ForeignKey getNewForeignKey() {
        return this._newForeignKey;
    }

    @Override
    public void apply(Database database, boolean caseSensitive) {
        ForeignKey newFK = null;
        try {
            newFK = (ForeignKey)this._newForeignKey.clone();
            Table foreignTable = database.findTable(this._newForeignKey.getForeignTableName(), caseSensitive);
            newFK.setForeignTable(foreignTable);
            if (foreignTable != null) {
                newFK.setForeignTableCatalog(foreignTable.getCatalog());
                newFK.setForeignTableSchema(foreignTable.getSchema());
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new DdlException(ex);
        }
        database.findTable(this.getChangedTable().getName()).addForeignKey(newFK);
    }
}

