/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.alter;

import org.jumpmind.db.alter.TableChangeImplBase;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;

public class AddPrimaryKeyChange
extends TableChangeImplBase {
    private Column[] _primaryKeyColumns;

    public AddPrimaryKeyChange(Table table, Column[] primaryKeyColumns) {
        super(table);
        this._primaryKeyColumns = primaryKeyColumns;
    }

    public Column[] getPrimaryKeyColumns() {
        return this._primaryKeyColumns;
    }

    @Override
    public void apply(Database database, boolean caseSensitive) {
        Table table = database.findTable(this.getChangedTable().getName(), caseSensitive);
        for (int idx = 0; idx < this._primaryKeyColumns.length; ++idx) {
            Column column = table.findColumn(this._primaryKeyColumns[idx].getName(), caseSensitive);
            column.setPrimaryKey(true);
        }
    }
}

