/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.model;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;

public class TableColumnSourceReferences
extends ArrayList<ColumnSourceReferenceEntry> {
    private static final long serialVersionUID = 1L;
    private String searchKey;

    public TableColumnSourceReferences(Table sourceTable, Table targetTable) {
        super(sourceTable.getColumns().length);
        this.searchKey = TableColumnSourceReferences.generateSearchKey(sourceTable, targetTable);
        Column[] sourceColumns = sourceTable.getColumns();
        Column[] targetColumns = targetTable.getColumns();
        block0: for (int targetColumnNo = 0; targetColumnNo < targetColumns.length; ++targetColumnNo) {
            Column targetColumn = targetColumns[targetColumnNo];
            for (int sourceColumnNo = 0; sourceColumnNo < sourceColumns.length; ++sourceColumnNo) {
                Column sourceColumn = sourceColumns[sourceColumnNo];
                if (!StringUtils.equalsIgnoreCase((CharSequence)sourceColumn.getName(), (CharSequence)targetColumn.getName())) continue;
                this.add(new ColumnSourceReferenceEntry(sourceColumnNo, targetColumnNo, sourceColumn, targetColumn));
                continue block0;
            }
        }
    }

    public static String generateSearchKey(Table sourceTable, Table targetTable) {
        return sourceTable.getFullyQualifiedTableName() + targetTable.getFullyQualifiedTableName();
    }

    public String getSearchKey() {
        return this.searchKey;
    }

    public boolean isMatchingTables(Table sourceTable, Table targetTable) {
        Column[] targetColumns = targetTable.getColumns();
        if (targetColumns.length != this.size()) {
            return false;
        }
        Column[] sourceColumns = sourceTable.getColumns();
        for (int targetColumnNo = 0; targetColumnNo < targetColumns.length; ++targetColumnNo) {
            Column targetColumn = targetColumns[targetColumnNo];
            ColumnSourceReferenceEntry columnReference = (ColumnSourceReferenceEntry)this.get(targetColumnNo);
            if (!targetColumn.getName().equals(columnReference.targetColumn.getName()) || targetColumnNo != columnReference.targetColumnNo) {
                return false;
            }
            if (columnReference.sourceColumnNo < sourceColumns.length && sourceColumns[columnReference.sourceColumnNo].getName().equals(columnReference.sourceColumn.getName())) continue;
            return false;
        }
        return true;
    }

    public record ColumnSourceReferenceEntry(int sourceColumnNo, int targetColumnNo, Column sourceColumn, Column targetColumn) {
    }
}

