/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jumpmind.db.model.PlatformTrigger;

public class Trigger
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    String triggerName;
    String catalogName;
    String schemaName;
    String tableName;
    String source;
    TriggerType triggerType;
    boolean enabled;
    Map<String, Object> metaData = new HashMap<String, Object>();
    Map<String, PlatformTrigger> platformTriggers;

    public Trigger(String name, String catalogName, String schemaName, String tableName, TriggerType triggerType) {
        this(name, catalogName, schemaName, tableName, triggerType, true);
    }

    public Trigger(String name, String catalogName, String schemaName, String tableName, TriggerType triggerType, boolean enabled) {
        this.triggerName = name;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.triggerType = triggerType;
        this.enabled = enabled;
    }

    public Trigger() {
    }

    public String getName() {
        return this.triggerName;
    }

    public void setName(String name) {
        this.triggerName = name;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public void setMetaData(Map<String, Object> metaData) {
        this.metaData = metaData;
    }

    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    public void setTriggerType(TriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public String getFullyQualifiedName() {
        return Trigger.getFullyQualifiedName(this.catalogName, this.schemaName, this.tableName, this.triggerName);
    }

    public void removePlatformTrigger(String databaseName) {
        if (this.platformTriggers != null) {
            this.platformTriggers.remove(databaseName);
        }
    }

    public void addPlatformTrigger(PlatformTrigger platformTrigger) {
        if (this.platformTriggers == null) {
            this.platformTriggers = new HashMap<String, PlatformTrigger>();
        }
        this.platformTriggers.put(platformTrigger.getName(), platformTrigger);
    }

    public Map<String, PlatformTrigger> getPlatformTriggers() {
        return this.platformTriggers;
    }

    public PlatformTrigger findPlatformTrigger(String name) {
        PlatformTrigger platformTrigger = null;
        if (this.platformTriggers != null && (platformTrigger = this.platformTriggers.get(name)) == null) {
            if (name.contains("mssql")) {
                return this.findDifferentVersionPlatformTrigger("mssql");
            }
            if (name.contains("oracle")) {
                return this.findDifferentVersionPlatformTrigger("oracle");
            }
            if (name.contains("postgres")) {
                return this.findDifferentVersionPlatformTrigger("postgres");
            }
            if (name.contains("sqlanywhere")) {
                return this.findDifferentVersionPlatformTrigger("sqlanywhere");
            }
            if (name.contains("firebird")) {
                return this.findDifferentVersionPlatformTrigger("firebird");
            }
            if (name.contains("hsqldb")) {
                return this.findDifferentVersionPlatformTrigger("hsqldb");
            }
        }
        return platformTrigger;
    }

    private PlatformTrigger findDifferentVersionPlatformTrigger(String name) {
        if (this.platformTriggers != null) {
            for (Map.Entry<String, PlatformTrigger> entry : this.platformTriggers.entrySet()) {
                if (entry.getKey() == null || !entry.getKey().contains(name)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public boolean anyPlatformTriggerNameContains(String name) {
        if (this.platformTriggers != null) {
            for (String platformTriggerName : this.platformTriggers.keySet()) {
                if (platformTriggerName == null || !platformTriggerName.contains(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean allPlatformTriggerNamesContain(String name) {
        if (this.platformTriggers != null) {
            for (String platformTriggerName : this.platformTriggers.keySet()) {
                if (platformTriggerName == null || platformTriggerName.contains(name)) continue;
                return false;
            }
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        Trigger result = (Trigger)super.clone();
        result.triggerName = this.triggerName;
        result.catalogName = this.catalogName;
        result.enabled = this.enabled;
        result.schemaName = this.schemaName;
        result.source = this.source;
        result.tableName = this.tableName;
        result.triggerType = this.triggerType;
        if (this.platformTriggers != null) {
            result.platformTriggers = new HashMap<String, PlatformTrigger>(this.platformTriggers.size());
            for (Map.Entry<String, PlatformTrigger> platformTrigger : this.platformTriggers.entrySet()) {
                result.platformTriggers.put(platformTrigger.getKey(), (PlatformTrigger)platformTrigger.getValue().clone());
            }
        }
        return result;
    }

    public static String getFullyQualifiedName(String catalog, String schema, String tableName, String triggerName) {
        Object fullName = "";
        if (catalog != null) {
            fullName = (String)fullName + catalog + ".";
        }
        if (schema != null) {
            fullName = (String)fullName + schema + ".";
        }
        fullName = (String)fullName + tableName + "." + triggerName;
        return fullName;
    }

    public static enum TriggerType {
        INSERT,
        UPDATE,
        DELETE;

    }
}

