/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.PlatformUtils;
import org.jumpmind.util.FormatUtils;

public class DefaultValueHelper {
    public String convert(String defaultValue, int originalTypeCode, int targetTypeCode) {
        String result = defaultValue;
        if (defaultValue != null) {
            switch (originalTypeCode) {
                case -7: {
                    result = this.convertBoolean(defaultValue, targetTypeCode).toString();
                    break;
                }
                case 91: {
                    if (targetTypeCode != 93) break;
                    try {
                        Date date = Date.valueOf(result);
                        return new Timestamp(date.getTime()).toString();
                    }
                    catch (IllegalArgumentException date) {
                        break;
                    }
                }
                case 92: {
                    if (targetTypeCode != 93) break;
                    try {
                        Time time = Time.valueOf(result);
                        return new Timestamp(time.getTime()).toString();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        break;
                    }
                }
                default: {
                    if (!PlatformUtils.supportsJava14JdbcTypes() || originalTypeCode != PlatformUtils.determineBooleanTypeCode()) break;
                    result = this.convertBoolean(defaultValue, targetTypeCode).toString();
                }
            }
        }
        return result;
    }

    private Object convertBoolean(String defaultValue, int targetTypeCode) {
        boolean value = FormatUtils.toBoolean((String)defaultValue);
        Object result = null;
        result = targetTypeCode == -7 || PlatformUtils.supportsJava14JdbcTypes() && targetTypeCode == PlatformUtils.determineBooleanTypeCode() ? Boolean.valueOf(value) : (TypeMap.isNumericType(targetTypeCode) ? (value ? Integer.valueOf(1) : Integer.valueOf(0)) : Boolean.toString(value));
        return result;
    }
}

