/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform;

import java.util.Map;
import java.util.TreeMap;
import org.jumpmind.db.platform.PermissionType;

public class PermissionResult {
    private PermissionType permissionType;
    private Status status = Status.FAIL;
    private Exception exception;
    private String solution;
    private PermissionCategory category;
    private String testDetails;
    private static Map<PermissionType, PermissionCategory> categories = new TreeMap<PermissionType, PermissionCategory>();

    public PermissionResult(PermissionType permissionType, String testDetails) {
        this.permissionType = permissionType;
        this.category = categories.get((Object)permissionType);
        this.testDetails = testDetails;
    }

    public PermissionType getPermissionType() {
        return this.permissionType;
    }

    public void setPermissionType(PermissionType permissionType) {
        this.permissionType = permissionType;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public String getSolution() {
        return this.solution;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }

    public PermissionCategory getCategory() {
        return this.category;
    }

    public void setCategory(PermissionCategory category) {
        this.category = category;
    }

    public String getTestDetails() {
        return this.testDetails;
    }

    public void setTestDetails(String testDetails) {
        this.testDetails = testDetails;
    }

    public String toString() {
        return "Permission Type: " + this.permissionType + ", Status: " + this.status;
    }

    static {
        categories.put(PermissionType.CREATE_TABLE, PermissionCategory.TABLE_MODIFICATION);
        categories.put(PermissionType.DROP_TABLE, PermissionCategory.TABLE_MODIFICATION);
        categories.put(PermissionType.ALTER_TABLE, PermissionCategory.TABLE_MODIFICATION);
        categories.put(PermissionType.CREATE_TRIGGER, PermissionCategory.TRIGGERS);
        categories.put(PermissionType.DROP_TRIGGER, PermissionCategory.TRIGGERS);
        categories.put(PermissionType.CREATE_FUNCTION, PermissionCategory.ADDITIONAL);
        categories.put(PermissionType.CREATE_ROUTINE, PermissionCategory.ADDITIONAL);
        categories.put(PermissionType.EXECUTE, PermissionCategory.ADDITIONAL);
        categories.put(PermissionType.LOG_MINE, PermissionCategory.ADDITIONAL);
    }

    public static enum Status {
        PASS,
        FAIL,
        UNIMPLEMENTED,
        UNSUPPORTED,
        NOT_APPLICABLE;

    }

    public static enum PermissionCategory {
        TABLE_MODIFICATION,
        TRIGGERS,
        ADDITIONAL;

    }
}

