/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.mysql;

import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.DmlStatementOptions;

public class MySqlDmlStatement
extends DmlStatement {
    public MySqlDmlStatement(DmlStatementOptions options) {
        super(options);
    }

    @Override
    protected void appendColumnParameter(StringBuilder sql, Column column) {
        if (StringUtils.equalsIgnoreCase((CharSequence)column.getJdbcTypeName(), (CharSequence)"GEOMETRY") || StringUtils.equalsIgnoreCase((CharSequence)column.getJdbcTypeName(), (CharSequence)"GEOGRAPHY")) {
            sql.append("geomfromtext(?)").append(",");
        } else {
            super.appendColumnParameter(sql, column);
        }
    }

    @Override
    protected void appendColumnEquals(StringBuilder sql, Column column) {
        if (StringUtils.equalsIgnoreCase((CharSequence)column.getJdbcTypeName(), (CharSequence)"GEOMETRY") || StringUtils.equalsIgnoreCase((CharSequence)column.getJdbcTypeName(), (CharSequence)"GEOGRAPHY")) {
            sql.append(this.quote).append(column.getName()).append(this.quote).append(" = ").append("geomfromtext(?)");
        } else {
            super.appendColumnEquals(sql, column);
        }
    }

    @Override
    protected String escapeText(String value) {
        value = super.escapeText(value);
        value = value.replace("\\", "\\\\");
        value = value.replace("$", "\\$");
        return value;
    }
}

