/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.oracle;

import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.DmlStatementOptions;

public class OracleDmlStatement
extends DmlStatement {
    public OracleDmlStatement(DmlStatementOptions options) {
        super(options);
    }

    @Override
    protected void appendColumnParameter(StringBuilder sql, Column column) {
        if (column.isTimestampWithTimezone()) {
            sql.append("TO_TIMESTAMP_TZ(?, 'YYYY-MM-DD HH24:MI:SS.FF TZH:TZM')").append(",");
        } else if (this.isGeometry(column)) {
            sql.append("SYM_WKT2GEOM(?,").append(this.buildSRIDSelect(column)).append(")").append(",");
        } else if (column.getJdbcTypeName().startsWith("XMLTYPE")) {
            sql.append("XMLTYPE(?)").append(",");
        } else {
            super.appendColumnParameter(sql, column);
        }
    }

    @Override
    protected void appendColumnEquals(StringBuilder sql, Column column) {
        if (column.isTimestampWithTimezone()) {
            sql.append(this.quote).append(column.getName()).append(this.quote).append(" = TO_TIMESTAMP_TZ(?, 'YYYY-MM-DD HH24:MI:SS.FF TZH:TZM')");
        } else if (this.isGeometry(column)) {
            sql.append(this.quote).append(column.getName()).append(this.quote).append(" = ").append("SYM_WKT2GEOM(?,").append(this.buildSRIDSelect(column)).append(")");
        } else if (column.getJdbcTypeName().startsWith("XMLTYPE")) {
            sql.append(this.quote).append(column.getName()).append(this.quote).append(" = ").append("XMLTYPE(?)");
        } else {
            super.appendColumnEquals(sql, column);
        }
    }

    @Override
    protected int getTypeCode(Column column, boolean isDateOverrideToTimestamp) {
        int typeCode = super.getTypeCode(column, isDateOverrideToTimestamp);
        if (typeCode == -1 || this.isGeometry(column) || column.getJdbcTypeName().startsWith("XMLTYPE")) {
            typeCode = 2005;
        }
        return typeCode;
    }

    @Override
    protected void appendColumnNameForSql(StringBuilder sql, Column column, boolean select) {
        String columnName = column.getName();
        if (select && column.isTimestampWithTimezone()) {
            if (column.getMappedTypeCode() == -102 || column.getJdbcTypeCode() == -102) {
                sql.append("to_char(").append(this.quote).append(columnName).append(this.quote).append(", 'YYYY-MM-DD HH24:MI:SS.FF9') as ").append(columnName);
            } else {
                sql.append("to_char(").append(this.quote).append(columnName).append(this.quote).append(", 'YYYY-MM-DD HH24:MI:SS.FF TZH:TZM') as ").append(columnName);
            }
        } else {
            super.appendColumnNameForSql(sql, column, select);
        }
    }

    protected boolean isGeometry(Column column) {
        String name = column.getJdbcTypeName();
        return name != null && (name.toUpperCase().contains("GEOMETRY") || name.toUpperCase().contains("GEOGRAPHY"));
    }

    protected String buildSRIDSelect(Column column) {
        if (!StringUtils.isEmpty((CharSequence)this.schemaName)) {
            return String.format("(select SRID from all_sdo_geom_metadata where owner = '%s' and table_name = '%s' and column_name = '%s')", this.schemaName.toUpperCase(), this.tableName.toUpperCase(), column.getName().toUpperCase());
        }
        return String.format("(select SRID from user_sdo_geom_metadata where table_name = '%s' and column_name = '%s')", this.tableName.toUpperCase(), column.getName().toUpperCase());
    }
}

