/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.redshift;

import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.DmlStatementOptions;

public class RedshiftDmlStatement
extends DmlStatement {
    public RedshiftDmlStatement(DmlStatementOptions options) {
        super(options);
    }

    @Override
    public String buildInsertSql(String tableName, Column[] keyColumns, Column[] columns) {
        if (keyColumns != null && keyColumns.length > 0 && keyColumns[0] != null) {
            StringBuilder sql = new StringBuilder("insert into ");
            sql.append(tableName);
            sql.append("(");
            this.appendColumns(sql, columns, false);
            sql.append(") (select ");
            this.appendColumnParameters(sql, columns);
            sql.append(" where (select count(*) from ");
            sql.append(tableName);
            sql.append(" where  ");
            if (keyColumns == null || keyColumns.length == 0) {
                sql.append("1 != 1");
            } else {
                this.appendColumnsEquals(sql, keyColumns, " and ");
            }
            sql.append(") = 0)");
            return sql.toString();
        }
        return super.buildInsertSql(tableName, keyColumns, columns);
    }

    @Override
    public Column[] getMetaData() {
        if (this.dmlType == DmlStatement.DmlType.INSERT) {
            return this.getColumnKeyMetaData();
        }
        return super.getMetaData();
    }

    @Override
    public <T> T[] getValueArray(T[] columnValues, T[] keyValues) {
        if (this.dmlType == DmlStatement.DmlType.INSERT) {
            return ArrayUtils.addAll((Object[])columnValues, (Object[])keyValues);
        }
        return super.getValueArray(columnValues, keyValues);
    }

    @Override
    public Object[] getValueArray(Map<String, Object> params) {
        Object[] args = null;
        int index = 0;
        if (params != null) {
            if (this.dmlType == DmlStatement.DmlType.INSERT) {
                args = new Object[this.columns.length + this.keys.length];
                for (Column column : this.columns) {
                    args[index++] = params.get(column.getName());
                }
                for (Column column : this.keys) {
                    args[index++] = params.get(column.getName());
                }
            } else {
                args = super.getValueArray(params);
            }
        }
        return args;
    }

    @Override
    protected int[] buildTypes(Column[] keys, Column[] columns, boolean isDateOverrideToTimestamp) {
        if (this.dmlType == DmlStatement.DmlType.INSERT) {
            int[] columnTypes = this.buildTypes(columns, isDateOverrideToTimestamp);
            int[] keyTypes = this.buildTypes(keys, isDateOverrideToTimestamp);
            return ArrayUtils.addAll((int[])columnTypes, (int[])keyTypes);
        }
        return super.buildTypes(keys, columns, isDateOverrideToTimestamp);
    }
}

