/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.sqlanywhere;

import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.alter.AddColumnChange;
import org.jumpmind.db.alter.AddPrimaryKeyChange;
import org.jumpmind.db.alter.ColumnAutoIncrementChange;
import org.jumpmind.db.alter.ColumnChange;
import org.jumpmind.db.alter.ColumnDefaultValueChange;
import org.jumpmind.db.alter.CopyColumnValueChange;
import org.jumpmind.db.alter.IModelChange;
import org.jumpmind.db.alter.PrimaryKeyChange;
import org.jumpmind.db.alter.RemoveColumnChange;
import org.jumpmind.db.alter.RemovePrimaryKeyChange;
import org.jumpmind.db.alter.TableChange;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractDdlBuilder;
import org.jumpmind.db.platform.PlatformUtils;

public class SqlAnywhereDdlBuilder
extends AbstractDdlBuilder {
    public SqlAnywhereDdlBuilder() {
        super("sqlanywhere");
        this.databaseInfo.setMaxIdentifierLength(128);
        this.databaseInfo.setNullAsDefaultValueRequired(true);
        this.databaseInfo.setCommentPrefix("/*");
        this.databaseInfo.setCommentSuffix("*/");
        this.databaseInfo.setDelimiterToken("\"");
        this.databaseInfo.addNativeTypeMapping(2003, "IMAGE");
        this.databaseInfo.addNativeTypeMapping(-7, "SMALLINT", 5);
        this.databaseInfo.addNativeTypeMapping(2004, "IMAGE", -4);
        this.databaseInfo.addNativeTypeMapping(2005, "TEXT", -1);
        this.databaseInfo.addNativeTypeMapping(91, "DATETIME", 93);
        this.databaseInfo.addNativeTypeMapping(2001, "IMAGE", -4);
        this.databaseInfo.addNativeTypeMapping(8, "DOUBLE PRECISION");
        this.databaseInfo.addNativeTypeMapping(6, "DOUBLE PRECISION", 8);
        this.databaseInfo.addNativeTypeMapping(4, "INT");
        this.databaseInfo.addNativeTypeMapping(2000, "IMAGE", -4);
        this.databaseInfo.addNativeTypeMapping(-4, "IMAGE");
        this.databaseInfo.addNativeTypeMapping(-1, "TEXT");
        this.databaseInfo.addNativeTypeMapping(0, "IMAGE", -4);
        this.databaseInfo.addNativeTypeMapping(1111, "IMAGE", -4);
        this.databaseInfo.addNativeTypeMapping(2006, "IMAGE", -4);
        this.databaseInfo.addNativeTypeMapping(2002, "IMAGE", -4);
        this.databaseInfo.addNativeTypeMapping(92, "DATETIME", 93);
        this.databaseInfo.addNativeTypeMapping(93, "DATETIME", 93);
        this.databaseInfo.addNativeTypeMapping(-101, "DATETIME");
        this.databaseInfo.addNativeTypeMapping(-102, "DATETIME");
        this.databaseInfo.addNativeTypeMapping(-6, "SMALLINT", 5);
        this.databaseInfo.addNativeTypeMapping("BOOLEAN", "SMALLINT", "SMALLINT");
        this.databaseInfo.addNativeTypeMapping("DATALINK", "IMAGE", "LONGVARBINARY");
        this.databaseInfo.addNativeTypeMapping(-16, "LONG NVARCHAR", -16);
        this.databaseInfo.setDefaultSize(-2, 254);
        this.databaseInfo.setDefaultSize(-3, 254);
        this.databaseInfo.setDefaultSize(1, 254);
        this.databaseInfo.setDefaultSize(12, 254);
        this.databaseInfo.setMaxSize("TIMESTAMP", 6);
        this.databaseInfo.setMaxSize("TIMESTAMP WITH TIME ZONE", 6);
        this.databaseInfo.setMaxSize("TIME", 6);
        this.databaseInfo.setDateOverridesToTimestamp(true);
        this.databaseInfo.setNonBlankCharColumnSpacePadded(false);
        this.databaseInfo.setBlankCharColumnSpacePadded(false);
        this.databaseInfo.setCharColumnSpaceTrimmed(false);
        this.databaseInfo.setEmptyStringNulled(false);
        this.databaseInfo.setAutoIncrementUpdateAllowed(false);
        this.databaseInfo.setRequiresAutoCommitForDdl(true);
        this.databaseInfo.setRequiredCharColumnEmptyStringSameAsNull(true);
    }

    @Override
    protected void createTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        this.writeQuotationOnStatement(ddl);
        super.createTable(table, ddl, temporary, recreate);
    }

    @Override
    protected void writeColumn(Table table, Column column, StringBuilder ddl) {
        this.printIdentifier(this.getColumnName(column), ddl);
        ddl.append(" ");
        ddl.append(this.getSqlType(column));
        this.writeColumnDefaultValueStmt(table, column, ddl);
        if (column.isAutoIncrement()) {
            ddl.append(" ");
            this.writeColumnAutoIncrementStmt(table, column, ddl);
        } else {
            ddl.append(" ");
            if (column.isRequired()) {
                this.writeColumnNotNullableStmt(ddl);
            } else {
                this.writeColumnNullableStmt(ddl);
            }
        }
    }

    @Override
    protected String getNativeDefaultValue(Column column) {
        if (column.getMappedTypeCode() == -7 || PlatformUtils.supportsJava14JdbcTypes() && column.getMappedTypeCode() == PlatformUtils.determineBooleanTypeCode()) {
            return this.getDefaultValueHelper().convert(column.getDefaultValue(), column.getMappedTypeCode(), 5);
        }
        return super.getNativeDefaultValue(column);
    }

    @Override
    protected void dropTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        this.writeQuotationOnStatement(ddl);
        ddl.append("IF EXISTS (SELECT 1 FROM dbo.sysobjects WHERE type = 'U' AND name = ");
        this.printAlwaysSingleQuotedIdentifier(this.getTableName(table.getName()), ddl);
        this.println(")", ddl);
        this.println("BEGIN", ddl);
        this.printIndent(ddl);
        ddl.append("DROP TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(table));
        ddl.append(" END");
        this.printEndOfStatement(ddl);
    }

    @Override
    protected void writeExternalForeignKeyDropStmt(Table table, ForeignKey foreignKey, StringBuilder ddl) {
        String constraintName = this.getForeignKeyName(table, foreignKey);
        ddl.append("IF EXISTS (SELECT 1 FROM dbo.sysobjects WHERE type = 'RI' AND name = ");
        this.printAlwaysSingleQuotedIdentifier(constraintName, ddl);
        this.println(")", ddl);
        this.printIndent(ddl);
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(table));
        ddl.append(" DROP CONSTRAINT ");
        this.printIdentifier(constraintName, ddl);
        this.printEndOfStatement(ddl);
    }

    @Override
    public void writeExternalIndexDropStmt(Table table, IIndex index, StringBuilder ddl) {
        ddl.append("DROP INDEX ");
        ddl.append(table.getSchema()).append(".").append(table.getName());
        ddl.append(".");
        this.printIdentifier(this.getIndexName(index), ddl);
        this.printEndOfStatement(ddl);
    }

    @Override
    public void dropExternalForeignKeys(Table table, StringBuilder ddl) {
        this.writeQuotationOnStatement(ddl);
        super.dropExternalForeignKeys(table, ddl);
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        return "SELECT @@IDENTITY";
    }

    protected String getQuotationOnStatement() {
        if (this.delimitedIdentifierModeOn) {
            return "SET quoted_identifier on";
        }
        return "";
    }

    private void writeQuotationOnStatement(StringBuilder ddl) {
        ddl.append(this.getQuotationOnStatement());
        this.printEndOfStatement(ddl);
    }

    private void printAlwaysSingleQuotedIdentifier(String identifier, StringBuilder ddl) {
        ddl.append("'");
        ddl.append(identifier);
        ddl.append("'");
    }

    @Override
    protected void writeCastExpression(Column sourceColumn, Column targetColumn, StringBuilder ddl) {
        String targetNativeType;
        String sourceNativeType = this.getBareNativeType(sourceColumn);
        if (sourceNativeType.equals(targetNativeType = this.getBareNativeType(targetColumn))) {
            this.printIdentifier(this.getColumnName(sourceColumn), ddl);
        } else {
            ddl.append("CONVERT(");
            ddl.append(this.getNativeType(targetColumn));
            ddl.append(",");
            this.printIdentifier(this.getColumnName(sourceColumn), ddl);
            ddl.append(")");
        }
    }

    @Override
    protected void processChanges(Database currentModel, Database desiredModel, List<IModelChange> changes, StringBuilder ddl) {
        if (!changes.isEmpty()) {
            this.writeQuotationOnStatement(ddl);
        }
        super.processChanges(currentModel, desiredModel, changes, ddl);
    }

    @Override
    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Table sourceTable, Table targetTable, List<TableChange> changes, StringBuilder ddl) {
        ArrayList changesPerColumn;
        TableChange change;
        Iterator<TableChange> changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            TableChange change2 = changeIt.next();
            if (change2 instanceof RemovePrimaryKeyChange) {
                this.processChange(currentModel, desiredModel, (RemovePrimaryKeyChange)change2, ddl);
                changeIt.remove();
                continue;
            }
            if (!(change2 instanceof PrimaryKeyChange)) continue;
            PrimaryKeyChange pkChange = (PrimaryKeyChange)change2;
            RemovePrimaryKeyChange removePkChange = new RemovePrimaryKeyChange(pkChange.getChangedTable(), pkChange.getOldPrimaryKeyColumns());
            this.processChange(currentModel, desiredModel, removePkChange, ddl);
        }
        HashMap<Column, ArrayList<ColumnChange>> columnChanges = new HashMap<Column, ArrayList<ColumnChange>>();
        Iterator<TableChange> changeIt2 = changes.iterator();
        while (changeIt2.hasNext()) {
            change = changeIt2.next();
            if (change instanceof AddColumnChange) {
                AddColumnChange addColumnChange = (AddColumnChange)change;
                if (!addColumnChange.isAtEnd()) continue;
                this.processChange(currentModel, desiredModel, addColumnChange, ddl);
                changeIt2.remove();
                continue;
            }
            if (change instanceof RemoveColumnChange) {
                this.processChange(currentModel, desiredModel, (RemoveColumnChange)change, ddl);
                changeIt2.remove();
                continue;
            }
            if (change instanceof CopyColumnValueChange) {
                CopyColumnValueChange copyColumnChange = (CopyColumnValueChange)change;
                this.processChange(currentModel, desiredModel, copyColumnChange, ddl);
                changeIt2.remove();
                continue;
            }
            if (change instanceof ColumnAutoIncrementChange) {
                columnChanges = null;
                continue;
            }
            if (!(change instanceof ColumnChange) || columnChanges == null) continue;
            ColumnChange columnChange = (ColumnChange)change;
            changesPerColumn = (ArrayList)columnChanges.get(columnChange.getChangedColumn());
            if (changesPerColumn == null) {
                changesPerColumn = new ArrayList();
                columnChanges.put(columnChange.getChangedColumn(), changesPerColumn);
            }
            changesPerColumn.add(columnChange);
        }
        if (columnChanges != null) {
            for (Map.Entry entry : columnChanges.entrySet()) {
                Column sourceColumn = (Column)entry.getKey();
                changesPerColumn = (ArrayList)entry.getValue();
                if (changesPerColumn.size() == 1 && changesPerColumn.get(0) instanceof ColumnDefaultValueChange) {
                    this.processChange(currentModel, desiredModel, (ColumnDefaultValueChange)changesPerColumn.get(0), ddl);
                } else {
                    Column targetColumn = targetTable.findColumn(sourceColumn.getName(), this.delimitedIdentifierModeOn);
                    this.processColumnChange(sourceTable, targetTable, sourceColumn, targetColumn, ddl);
                }
                Iterator changeIt3 = changesPerColumn.iterator();
                while (changeIt3.hasNext()) {
                    ((ColumnChange)changeIt3.next()).apply(currentModel, this.delimitedIdentifierModeOn);
                }
            }
        }
        changeIt2 = changes.iterator();
        while (changeIt2.hasNext()) {
            change = changeIt2.next();
            if (change instanceof AddPrimaryKeyChange) {
                this.processChange(currentModel, desiredModel, (AddPrimaryKeyChange)change, ddl);
                changeIt2.remove();
                continue;
            }
            if (!(change instanceof PrimaryKeyChange)) continue;
            PrimaryKeyChange pkChange = (PrimaryKeyChange)change;
            AddPrimaryKeyChange addPkChange = new AddPrimaryKeyChange(pkChange.getChangedTable(), pkChange.getNewPrimaryKeyColumns());
            this.processChange(currentModel, desiredModel, addPkChange, ddl);
            changeIt2.remove();
        }
    }

    protected void processChange(Database currentModel, Database desiredModel, AddColumnChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("ADD ");
        this.writeColumn(change.getChangedTable(), change.getNewColumn(), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, RemoveColumnChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("DROP ");
        this.printIdentifier(this.getColumnName(change.getColumn()), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, RemovePrimaryKeyChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("DROP PRIMARY KEY");
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, ColumnDefaultValueChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("REPLACE ");
        this.printIdentifier(this.getColumnName(change.getChangedColumn()), ddl);
        Table curTable = currentModel.findTable(change.getChangedTable().getName(), this.delimitedIdentifierModeOn);
        Column curColumn = curTable.findColumn(change.getChangedColumn().getName(), this.delimitedIdentifierModeOn);
        ddl.append(" DEFAULT ");
        if (this.isValidDefaultValue(change.getNewDefaultValue(), curColumn.getMappedTypeCode())) {
            this.printDefaultValue(change.getNewDefaultValue(), curColumn, ddl);
        } else {
            ddl.append("NULL");
        }
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processColumnChange(Table sourceTable, Table targetTable, Column sourceColumn, Column targetColumn, StringBuilder ddl) {
        boolean defaultChanges;
        Object oldParsedDefault = sourceColumn.getParsedDefaultValue();
        Object newParsedDefault = targetColumn.getParsedDefaultValue();
        String newDefault = targetColumn.getDefaultValue();
        boolean bl = defaultChanges = oldParsedDefault == null && newParsedDefault != null || oldParsedDefault != null && !oldParsedDefault.equals(newParsedDefault);
        if (newDefault != null) {
            targetColumn.setDefaultValue(null);
        }
        if (defaultChanges) {
            ddl.append("ALTER TABLE ");
            ddl.append(this.getFullyQualifiedTableNameShorten(sourceTable));
            this.printIndent(ddl);
            ddl.append("REPLACE ");
            this.printIdentifier(this.getColumnName(sourceColumn), ddl);
            ddl.append(" DEFAULT NULL");
            this.printEndOfStatement(ddl);
        }
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(sourceTable));
        this.printIndent(ddl);
        ddl.append("MODIFY ");
        this.writeColumn(sourceTable, targetColumn, ddl);
        this.printEndOfStatement(ddl);
        if (defaultChanges) {
            ddl.append("ALTER TABLE ");
            ddl.append(this.getFullyQualifiedTableNameShorten(sourceTable));
            this.printIndent(ddl);
            ddl.append("REPLACE ");
            this.printIdentifier(this.getColumnName(sourceColumn), ddl);
            if (newDefault != null) {
                targetColumn.setDefaultValue(newDefault);
                this.writeColumnDefaultValueStmt(sourceTable, targetColumn, ddl);
            } else {
                ddl.append(" DEFAULT NULL");
            }
            this.printEndOfStatement(ddl);
        }
    }

    protected String createUniqueIdentifier() {
        return new UID().toString().replace(':', '_').replace('-', '_');
    }

    @Override
    protected void writeCascadeAttributesForForeignKeyUpdate(ForeignKey key, StringBuilder ddl) {
        ForeignKey.ForeignKeyAction original = key.getOnUpdateAction();
        if (key.getOnUpdateAction() == ForeignKey.ForeignKeyAction.NOACTION) {
            key.setOnUpdateAction(ForeignKey.ForeignKeyAction.RESTRICT);
        }
        super.writeCascadeAttributesForForeignKeyUpdate(key, ddl);
        key.setOnUpdateAction(original);
    }

    @Override
    protected void writeCascadeAttributesForForeignKeyDelete(ForeignKey key, StringBuilder ddl) {
        ForeignKey.ForeignKeyAction original = key.getOnDeleteAction();
        if (key.getOnDeleteAction() == ForeignKey.ForeignKeyAction.NOACTION) {
            key.setOnDeleteAction(ForeignKey.ForeignKeyAction.RESTRICT);
        }
        super.writeCascadeAttributesForForeignKeyDelete(key, ddl);
        key.setOnDeleteAction(original);
    }

    @Override
    public boolean areMappedTypesTheSame(Column sourceColumn, Column targetColumn) {
        int sourceTypeCode = sourceColumn.getMappedTypeCode();
        int targetTypeCode = targetColumn.getMappedTypeCode();
        return super.areMappedTypesTheSame(sourceColumn, targetColumn) || sourceTypeCode == 1 && targetTypeCode == 12 || sourceTypeCode == 12 && targetTypeCode == 1;
    }
}

