/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.sqlite;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractDdlBuilder;

public class SqliteDdlBuilder
extends AbstractDdlBuilder {
    public SqliteDdlBuilder() {
        super("sqlite");
        this.databaseInfo.setMinIsolationLevelToPreventPhantomReads(8);
        this.databaseInfo.setPrimaryKeyEmbedded(true);
        this.databaseInfo.setNonPKIdentityColumnsSupported(false);
        this.databaseInfo.setIdentityOverrideAllowed(false);
        this.databaseInfo.setSystemForeignKeyIndicesAlwaysNonUnique(true);
        this.databaseInfo.setNullAsDefaultValueRequired(false);
        this.databaseInfo.setRequiresAutoCommitForDdl(true);
        this.databaseInfo.addNativeTypeMapping(2003, "BINARY", -2);
        this.databaseInfo.addNativeTypeMapping(1, "VARCHAR", 12);
        this.databaseInfo.addNativeTypeMapping(-5, "INTEGER", 4);
        this.databaseInfo.addNativeTypeMapping(2001, "BINARY", -2);
        this.databaseInfo.addNativeTypeMapping(0, "BINARY", -2);
        this.databaseInfo.addNativeTypeMapping(2006, "BINARY", -2);
        this.databaseInfo.addNativeTypeMapping(2002, "BINARY", -2);
        this.databaseInfo.addNativeTypeMapping(70, "BINARY", -2);
        this.databaseInfo.addNativeTypeMapping(93, "TIMESTAMP", 93);
        this.databaseInfo.addNativeTypeMapping(92, "TIME", 92);
        this.databaseInfo.addNativeTypeMapping(91, "DATETIME", 91);
        this.databaseInfo.addNativeTypeMapping(-7, "INTEGER", 4);
        this.databaseInfo.addNativeTypeMapping(-6, "INTEGER", 4);
        this.databaseInfo.addNativeTypeMapping(5, "INTEGER", 4);
        this.databaseInfo.addNativeTypeMapping(-2, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(2004, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(2005, "VARCHAR", 12);
        this.databaseInfo.addNativeTypeMapping(-1, "VARCHAR", 12);
        this.databaseInfo.addNativeTypeMapping(6, "FLOAT", 6);
        this.databaseInfo.addNativeTypeMapping(2000, "OTHER");
        this.databaseInfo.setDefaultSize(1, Integer.MAX_VALUE);
        this.databaseInfo.setDefaultSize(12, Integer.MAX_VALUE);
        this.databaseInfo.setDefaultSize(-2, Integer.MAX_VALUE);
        this.databaseInfo.setDefaultSize(-3, Integer.MAX_VALUE);
        this.databaseInfo.setHasSize(1, false);
        this.databaseInfo.setHasSize(12, false);
        this.databaseInfo.setHasSize(-2, false);
        this.databaseInfo.setHasSize(-3, false);
        this.databaseInfo.setHasPrecisionAndScale(3, false);
        this.databaseInfo.setHasPrecisionAndScale(2, false);
        this.databaseInfo.setDateOverridesToTimestamp(false);
        this.databaseInfo.setEmptyStringNulled(false);
        this.databaseInfo.setBlankCharColumnSpacePadded(false);
        this.databaseInfo.setNonBlankCharColumnSpacePadded(false);
        this.databaseInfo.setForeignKeysSupported(true);
        this.databaseInfo.setForeignKeysEmbedded(true);
        this.databaseInfo.setEmbeddedForeignKeysNamed(false);
    }

    @Override
    protected void writeExternalForeignKeyCreateStmt(Database database, Table table, ForeignKey key, StringBuilder ddl) {
    }

    @Override
    protected void writeExternalForeignKeyDropStmt(Table table, ForeignKey foreignKey, StringBuilder ddl) {
    }

    @Override
    public void writeExternalIndexDropStmt(Table table, IIndex index, StringBuilder ddl) {
        ddl.append("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index), ddl);
        this.printEndOfStatement(ddl);
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column, StringBuilder ddl) {
        ddl.append("AUTOINCREMENT");
    }

    @Override
    protected void writeColumnEmbeddedPrimaryKey(Table table, Column column, StringBuilder ddl) {
        if (table.getPrimaryKeyColumnCount() == 1) {
            ddl.append(" PRIMARY KEY ");
        }
    }

    @Override
    protected void writeEmbeddedPrimaryKeysStmt(Table table, StringBuilder ddl) {
        if (table.getPrimaryKeyColumnCount() > 1) {
            super.writeEmbeddedPrimaryKeysStmt(table, ddl);
        }
    }

    @Override
    protected void dropTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        ddl.append("DROP TABLE IF EXISTS ");
        ddl.append(this.getFullyQualifiedTableNameShorten(table));
        this.printEndOfStatement(ddl);
    }

    @Override
    public String getIndexName(IIndex index) {
        return super.getIndexName(index).replace("-", "_");
    }

    @Override
    public String mapDefaultValue(Object defaultValue, Column column) {
        if (defaultValue != null) {
            String defaultValueStr = defaultValue.toString();
            Map<String, String> defaultValuesToTranslate = this.databaseInfo.getDefaultValuesToTranslate();
            if (defaultValuesToTranslate.containsKey(defaultValueStr)) {
                return defaultValuesToTranslate.get(defaultValueStr);
            }
            if (TypeMap.isDateTimeType(column.getMappedTypeCode())) {
                if (defaultValueStr.toUpperCase().startsWith("SYSDATE") || defaultValueStr.toUpperCase().startsWith("CURRENT_DATE")) {
                    return "CURRENT_DATE";
                }
                if (defaultValueStr.toUpperCase().startsWith("SYSTIMESTAMP") || defaultValueStr.toUpperCase().startsWith("CURRENT_TIMESTAMP")) {
                    return "CURRENT_TIMESTAMP";
                }
                if (defaultValueStr.toUpperCase().startsWith("SYSTIME") || defaultValueStr.toUpperCase().startsWith("CURRENT_TIME")) {
                    return "CURRENT_TIME";
                }
                if (defaultValueStr.contains("('")) {
                    int beginIndex = defaultValueStr.indexOf("('");
                    int lastIndex = defaultValueStr.lastIndexOf(")");
                    if (lastIndex > beginIndex) {
                        return defaultValueStr.substring(beginIndex, lastIndex);
                    }
                    return defaultValueStr.substring(beginIndex);
                }
            } else {
                if (defaultValueStr.toUpperCase().startsWith("NEWID(")) {
                    return "HEX(RANDOMBLOB(4)) || '-' || HEX(RANDOMBLOB(2)) || '-' || HEX(RANDOMBLOB(2)) || '-' || HEX(RANDOMBLOB(2)) || '-' || HEX(RANDOMBLOB(6))";
                }
                if (defaultValueStr.toUpperCase().startsWith("NEWSEQUENTIALID(")) {
                    return "HEX(RANDOMBLOB(4)) || '-' || HEX(RANDOMBLOB(2)) || '-' || HEX(RANDOMBLOB(2)) || '-' || HEX(RANDOMBLOB(2)) || '-' || SUBSTR(PRINTF('%014X', (STRFTIME('%s', 'now') * 1000 + SUBSTR(STRFTIME('%f','now'), 4, 3))), 3, 12)";
                }
            }
        }
        return super.mapDefaultValue(defaultValue, column);
    }

    @Override
    protected void writeColumnDefaultValueStmt(Table table, Column column, StringBuilder ddl) {
        if (!StringUtils.containsIgnoreCase((CharSequence)this.getNativeDefaultValue(column), (CharSequence)"NEXT VALUE FOR")) {
            super.writeColumnDefaultValueStmt(table, column, ddl);
        }
    }

    @Override
    protected void writeColumnDefaultValue(Table table, Column column, StringBuilder ddl) {
        ddl.append("(");
        super.writeColumnDefaultValue(table, column, ddl);
        ddl.append(")");
    }

    @Override
    protected boolean shouldUseQuotes(String defaultValue, Column column) {
        String defaultValueStr;
        for (defaultValueStr = this.mapDefaultValue(defaultValue, column); defaultValueStr != null && defaultValueStr.startsWith("(") && defaultValueStr.endsWith(")"); defaultValueStr = defaultValueStr.substring(1, defaultValueStr.length() - 1)) {
        }
        return super.shouldUseQuotes(defaultValue, column) && !defaultValueStr.trim().toUpperCase().startsWith("HEX(RANDOMBLOB(");
    }

    @Override
    protected void createTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        if (table.getPrimaryKeyColumnCount() > 1 && table.hasAutoIncrementColumn()) {
            for (Column column : table.getColumns()) {
                column.setAutoIncrement(false);
            }
        }
        super.createTable(table, ddl, temporary, recreate);
    }
}

