/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.util;

import org.jumpmind.db.model.Database;
import org.jumpmind.db.platform.IAlterDatabaseInterceptor;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.sql.LogSqlResultsListener;
import org.jumpmind.db.sql.SqlScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDatabaseUpgrader {
    private static final Logger log = LoggerFactory.getLogger(ConfigDatabaseUpgrader.class);
    protected String tablePrefix = "SYM";
    protected IDatabasePlatform configDatabasePlatform;
    protected boolean logOutput = true;
    protected String schemaXml;

    public ConfigDatabaseUpgrader(String schemaXml, IDatabasePlatform configDatabasePlatform, boolean logOutput, String tablePrefix) {
        this.configDatabasePlatform = configDatabasePlatform;
        this.logOutput = logOutput;
        this.schemaXml = schemaXml;
        this.tablePrefix = tablePrefix;
    }

    public ConfigDatabaseUpgrader() {
    }

    public boolean upgrade() {
        try {
            if (this.logOutput) {
                log.info("Checking if config tables need created or altered");
            }
            Database modelFromXml = this.configDatabasePlatform.readDatabaseFromXml(this.schemaXml, true);
            this.configDatabasePlatform.prefixDatabase(this.tablePrefix, modelFromXml);
            Database modelFromDatabase = this.configDatabasePlatform.readFromDatabase(modelFromXml.getTables());
            IDdlBuilder builder = this.configDatabasePlatform.getDdlBuilder();
            if (builder.isAlterDatabase(modelFromDatabase, modelFromXml, new IAlterDatabaseInterceptor[0])) {
                if (this.logOutput) {
                    log.info("There are config tables that needed altered");
                }
                String delimiter = this.configDatabasePlatform.getDatabaseInfo().getSqlCommandDelimiter();
                String alterSql = builder.alterDatabase(modelFromDatabase, modelFromXml, new IAlterDatabaseInterceptor[0]);
                log.debug("Alter SQL generated: {}", (Object)alterSql);
                SqlScript script = new SqlScript(alterSql, this.configDatabasePlatform.getSqlTemplate(), true, false, false, delimiter, null);
                if (this.logOutput) {
                    script.setListener(new LogSqlResultsListener());
                }
                script.execute(this.configDatabasePlatform.getDatabaseInfo().isRequiresAutoCommitForDdl());
                if (this.logOutput) {
                    log.info("Done with auto update of config tables");
                }
                return true;
            }
            return false;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setLogOutput(boolean logOutput) {
        this.logOutput = logOutput;
    }

    public boolean isLogOutput() {
        return this.logOutput;
    }

    public void setConfigDatabasePlatform(IDatabasePlatform configDatabasePlatform) {
        this.configDatabasePlatform = configDatabasePlatform;
    }

    public IDatabasePlatform getConfigDatabasePlatform() {
        return this.configDatabasePlatform;
    }

    public void setSchemaXml(String schemaXml) {
        this.schemaXml = schemaXml;
    }

    public String getSchemaXml() {
        return this.schemaXml;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }
}

