/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.net.CookieHandler;
import java.net.CookieManager;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.security.SecurityServiceFactory;
import org.jumpmind.symmetric.SymmetricWebServer;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class SymmetricBootPropertySetupListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        TypedProperties sysProps = new TypedProperties(System.getProperties());
        boolean httpEnabled = sysProps.is("http.enable", true);
        boolean httpsEnabled = sysProps.is("https.enable");
        int httpPort = sysProps.getInt("http.port", Integer.parseInt(SymmetricWebServer.DEFAULT_HTTP_PORT));
        int httpsPort = sysProps.getInt("https.port", Integer.parseInt(SymmetricWebServer.DEFAULT_HTTPS_PORT));
        ConfigurableEnvironment environment = event.getEnvironment();
        Properties bootProps = new Properties();
        this.setIfNotBlank("host.bind.name", "server.address", sysProps, bootProps);
        this.setIfNotBlank("server.access.log.enabled", "server.jetty.accesslog.enabled", sysProps, bootProps);
        this.setIfNotBlank("server.access.log.file", "server.jetty.accesslog.filename", sysProps, bootProps);
        this.setIfNotBlank("symmetric.server.web.home", "server.servlet.context-path", sysProps, bootProps);
        this.setIfNotBlank("server.cookie.name", "server.servlet.session.cookie.name", sysProps, bootProps, SymmetricBootPropertySetupListener.getCookieName(httpEnabled, httpsEnabled, httpPort, httpsPort));
        this.setIfNotBlank("org.eclipse.jetty.server.Request.maxFormContentSize", "server.jetty.max-http-form-post-size", sysProps, bootProps);
        bootProps.put("server.jetty.connection-idle-timeout", (Object)sysProps.getInt("server.connection.idle.timeout", 90000));
        bootProps.put("server.servlet.jsp.init-parameters.listings", (Object)sysProps.is("server.allow.dir.list"));
        bootProps.put("server.servlet.session.cookie.http-only", Boolean.toString(true));
        bootProps.put("spring.web.resources.static-locations", "classpath:[/META-INF/resources/,/resources/,/static/],file:" + sysProps.get("symmetric.default.web.dir", "web"));
        if (sysProps.is("https.need.client.auth")) {
            bootProps.put("server.ssl.client-auth", "need");
        } else if (sysProps.is("https.want.client.auth")) {
            bootProps.put("server.ssl.client-auth", "want");
        }
        if (httpEnabled && !httpsEnabled) {
            bootProps.put("server.port", String.valueOf(httpPort));
        } else if (httpsEnabled) {
            bootProps.put("server.port", String.valueOf(httpsPort));
            bootProps.put("server.ssl.enabled", Boolean.toString(true));
            this.setIfNotBlank("https2.enable", "server.http2.enabled", sysProps, bootProps);
            if (!httpEnabled) {
                bootProps.setProperty("server.servlet.session.cookie.secure", Boolean.toString(true));
            }
            ISecurityService securityService = SecurityServiceFactory.create((SecurityServiceFactory.SecurityServiceType)SecurityServiceFactory.SecurityServiceType.SERVER, (TypedProperties)sysProps);
            bootProps.put("server.ssl.key-store", sysProps.get("sym.keystore.file"));
            bootProps.put("server.ssl.key-store-password", StringUtils.defaultIfBlank((CharSequence)securityService.unobfuscateIfNeeded("javax.net.ssl.keyStorePassword"), (CharSequence)"changeit"));
            bootProps.put("server.ssl.key-store-type", securityService.getKeyStore().getType());
            bootProps.put("server.ssl.key-alias", sysProps.get("sym.keystore.ssl.cert.alias", "sym"));
            String trustStore = sysProps.get("javax.net.ssl.trustStore");
            if (StringUtils.isNotBlank((CharSequence)trustStore)) {
                bootProps.put("server.ssl.trust-store", trustStore);
                bootProps.put("server.ssl.trust-store-password", StringUtils.defaultIfBlank((CharSequence)securityService.unobfuscateIfNeeded("javax.net.ssl.trustStorePassword"), (CharSequence)"changeit"));
                bootProps.put("server.ssl.trust-store-type", "JKS");
            }
        }
        environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("symBootProps", bootProps));
        if (sysProps.is("server.http.cookies.enabled") && CookieHandler.getDefault() == null) {
            CookieHandler.setDefault(new CookieManager());
        }
    }

    protected static String getCookieName(boolean httpEnable, boolean httpsEnable, int httpPort, int httpsPort) {
        StringBuilder sb = new StringBuilder("JSESSIONID_");
        if (httpsEnable) {
            sb.append(httpsPort);
        }
        if (httpEnable) {
            sb.append("_").append(httpPort);
        }
        return sb.toString();
    }

    protected void setIfNotBlank(String sysName, String bootName, TypedProperties sysProps, Properties bootProps) {
        String value = sysProps.getProperty(sysName);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            bootProps.put(bootName, value);
        }
    }

    protected void setIfNotBlank(String sysName, String bootName, TypedProperties sysProps, Properties bootProps, String defaultValue) {
        String value = sysProps.getProperty(sysName);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            bootProps.put(bootName, value);
        } else {
            bootProps.put(bootName, defaultValue);
        }
    }
}

