/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import jakarta.servlet.ServletContext;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.AbstractCommandLauncher;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.JettyCustomizer;
import org.jumpmind.symmetric.SymmetricBoot;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.symmetric.web.ServletUtils;
import org.jumpmind.symmetric.web.SymmetricEngineHolder;
import org.jumpmind.util.AppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class SymmetricWebServer {
    private static final Logger log = LoggerFactory.getLogger(SymmetricWebServer.class);
    protected static final String DEFAULT_WEBAPP_DIR = System.getProperty("symmetric.default.web.dir", AppUtils.getSymHome() + "/web");
    public static final String DEFAULT_HTTP_PORT = System.getProperty("symmetric.default.http.port", "31415");
    public static final String DEFAULT_HTTPS_PORT = System.getProperty("symmetric.default.https.port", "31417");
    public static final int DEFAULT_MAX_IDLE_TIME = 90000;
    protected ConfigurableApplicationContext context;
    protected boolean join = true;
    protected String webHome = "/";
    protected int maxIdleTime = 90000;
    protected boolean httpEnabled = true;
    protected int httpPort = Integer.parseInt(DEFAULT_HTTP_PORT);
    protected boolean httpsEnabled = false;
    protected boolean https2Enabled = false;
    protected int httpsPort = Integer.parseInt(DEFAULT_HTTPS_PORT);
    protected String propertiesFile = null;
    protected String host = null;
    protected String webAppDir = DEFAULT_WEBAPP_DIR;
    protected String name = "SymmetricDS";
    protected boolean httpsNeedClientAuth = false;
    protected boolean httpsWantClientAuth = false;

    public SymmetricWebServer() {
        this(null, DEFAULT_WEBAPP_DIR);
    }

    public SymmetricWebServer(String propertiesUrl) {
        this(propertiesUrl, DEFAULT_WEBAPP_DIR);
    }

    public SymmetricWebServer(int maxIdleTime, String propertiesUrl) {
        this(propertiesUrl, DEFAULT_WEBAPP_DIR);
        this.maxIdleTime = maxIdleTime;
    }

    public SymmetricWebServer(String webappDir, int maxIdleTime, String propertiesUrl, boolean join) {
        this(propertiesUrl, webappDir);
        this.maxIdleTime = maxIdleTime;
        this.join = join;
    }

    public SymmetricWebServer(String propertiesUrl, String webappDir) {
        this.propertiesFile = propertiesUrl;
        this.webAppDir = webappDir;
        this.initFromProperties();
    }

    protected final void initFromProperties() {
        try {
            Class.forName(AbstractCommandLauncher.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        TypedProperties serverProperties = new TypedProperties(System.getProperties());
        this.httpEnabled = serverProperties.is("http.enable", true);
        this.httpsEnabled = serverProperties.is("https.enable", false);
        this.https2Enabled = serverProperties.is("https2.enable", false);
        this.httpPort = serverProperties.getInt("http.port", this.httpPort);
        this.httpsPort = serverProperties.getInt("https.port", this.httpsPort);
        this.host = serverProperties.get("host.bind.name", this.host);
        this.httpsNeedClientAuth = serverProperties.is("https.need.client.auth", false);
        this.httpsWantClientAuth = serverProperties.is("https.want.client.auth", false);
        this.webHome = serverProperties.get("symmetric.server.web.home", this.webHome);
    }

    public SymmetricWebServer start() throws Exception {
        if (!(this.httpEnabled && this.httpPort > 0 || this.httpsEnabled && this.httpsPort > 0)) {
            throw new IllegalStateException("Either an http or https port needs to be set and enabled before starting the server.");
        }
        SymmetricUtils.logNotices();
        String protocolName = this.httpEnabled ? "HTTP/1.1" : (this.httpsEnabled && this.https2Enabled ? "HTTPS/2" : "HTTPS/1.1");
        int port = this.httpEnabled ? this.httpPort : this.httpsPort;
        log.info("About to start {} web server on {}:{}:{} with context path {}", new Object[]{this.name, this.host == null ? "default" : this.host, port, protocolName, this.webHome});
        System.setProperty("symmetric.standalone.web", Boolean.toString(true));
        System.setProperty("http.enable", Boolean.valueOf(this.httpEnabled).toString());
        System.setProperty("https.enable", Boolean.valueOf(this.httpsEnabled).toString());
        System.setProperty("http.port", Integer.toString(this.httpPort));
        System.setProperty("https.port", Integer.toString(this.httpsPort));
        System.setProperty("server.connection.idle.timeout", Integer.toString(this.maxIdleTime));
        this.setSystemPropertyIfNotNull("host.bind.name", this.host);
        this.setSystemPropertyIfNotNull("symmetric.server.web.home", this.webHome);
        this.setSystemPropertyIfNotNull("server.single.properties.file", this.propertiesFile);
        this.setSystemPropertyIfNotNull("symmetric.default.web.dir", this.webAppDir);
        this.context = SymmetricBoot.run(new String[0]);
        return this;
    }

    protected void setSystemPropertyIfNotNull(String property, String value) {
        if (value != null) {
            System.setProperty(property, value);
        }
    }

    public SymmetricWebServer start(int httpPort) throws Exception {
        this.httpPort = httpPort;
        this.httpEnabled = true;
        this.httpsEnabled = false;
        return this.start();
    }

    public SymmetricWebServer startSecure(int httpsPort) throws Exception {
        this.httpsPort = httpsPort;
        this.httpEnabled = false;
        this.httpsEnabled = true;
        return this.start();
    }

    public SymmetricWebServer startMixed(int httpPort, int httpsPort) throws Exception {
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.httpEnabled = true;
        this.httpsEnabled = true;
        return this.start();
    }

    public ServletContext getServletContext() {
        JettyCustomizer jettyCustomized = (JettyCustomizer)this.context.getBean(JettyCustomizer.class);
        return jettyCustomized != null ? jettyCustomized.getServletContext() : null;
    }

    public ISymmetricEngine getEngine() {
        SymmetricEngineHolder engineHolder;
        ISymmetricEngine engine = null;
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null && (engineHolder = ServletUtils.getSymmetricEngineHolder(servletContext)) != null) {
            if (engineHolder.getEngines().size() == 1) {
                return (ISymmetricEngine)engineHolder.getEngines().values().iterator().next();
            }
            throw new IllegalStateException("Could not choose a single engine to return.  There are " + engineHolder.getEngines().size() + " engines configured.");
        }
        return engine;
    }

    public ISymmetricEngine getEngine(String name) {
        SymmetricEngineHolder engineHolder;
        ISymmetricEngine engine = null;
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null && (engineHolder = ServletUtils.getSymmetricEngineHolder(servletContext)) != null) {
            return (ISymmetricEngine)engineHolder.getEngines().get(name);
        }
        return engine;
    }

    public void waitForEnginesToComeOnline(long maxWaitTimeInMs) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null) {
            SymmetricEngineHolder engineHolder = ServletUtils.getSymmetricEngineHolder(servletContext);
            while (engineHolder.areEnginesStarting()) {
                AppUtils.sleep((long)500L);
                if (System.currentTimeMillis() - startTime <= maxWaitTimeInMs) continue;
                throw new InterruptedException("Timed out waiting for engines to start");
            }
        }
    }

    public void stop() throws Exception {
        if (this.context != null) {
            this.context.stop();
        }
    }

    public static void main(String[] args) throws Exception {
        new SymmetricWebServer().start(Integer.parseInt(DEFAULT_HTTP_PORT));
    }

    public boolean isJoin() {
        return this.join;
    }

    public void setJoin(boolean join) {
        this.join = join;
    }

    public void setWebHome(String webHome) {
        this.webHome = webHome;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setWebAppDir(String webAppDir) {
        this.webAppDir = webAppDir;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setHttpEnabled(boolean httpEnabled) {
        this.httpEnabled = httpEnabled;
    }

    public boolean isHttpEnabled() {
        return this.httpEnabled;
    }

    public void setHttpsEnabled(boolean httpsEnabled) {
        this.httpsEnabled = httpsEnabled;
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    public void setHttps2Enabled(boolean https2Enabled) {
        this.https2Enabled = https2Enabled;
    }

    public boolean isHttps2Enabled() {
        return this.https2Enabled;
    }

    public void setHttpsNeedClientAuth(boolean httpsNeedClientAuth) {
        this.httpsNeedClientAuth = httpsNeedClientAuth;
    }

    public boolean isHttpsNeedClientAuth() {
        return this.httpsNeedClientAuth;
    }

    public boolean isHttpsWantClientAuth() {
        return this.httpsWantClientAuth;
    }

    public void setHttpsWantClientAuth(boolean httpsWantClientAuth) {
        this.httpsWantClientAuth = httpsWantClientAuth;
    }
}

