/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.integrate;

import java.util.Collections;
import java.util.Set;
import org.jdom2.Element;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.integrate.AbstractXmlPublisherExtensionPoint;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.jumpmind.util.Context;

public class XmlPublisherDataRouter
extends AbstractXmlPublisherExtensionPoint
implements IDataRouter,
ISymmetricEngineAware {
    boolean onePerBatch = false;

    public void contextCommitted(SimpleRouterContext context) {
        if (this.doesXmlExistToPublish((Context)context)) {
            this.finalizeXmlAndPublish((Context)context);
        }
    }

    public void completeBatch(SimpleRouterContext context, OutgoingBatch batch) {
        if (this.onePerBatch && this.doesXmlExistToPublish((Context)context)) {
            this.finalizeXmlAndPublish((Context)context);
        }
    }

    public Set<String> routeToNodes(SimpleRouterContext context, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {
        Data data = dataMetaData.getData();
        if (this.tableNamesToPublishAsGroup == null || this.tableNamesToPublishAsGroup.contains(data.getTableName())) {
            String[] rowData = data.getParsedData("rowData");
            if (data.getDataEventType() == DataEventType.DELETE) {
                rowData = data.getParsedData("oldData");
            }
            TriggerHistory triggerHistory = dataMetaData.getTriggerHistory();
            Element xml = this.getXmlFromCache((Context)context, this.engine.getSymmetricDialect().getBinaryEncoding(), triggerHistory.getParsedColumnNames(), rowData, triggerHistory.getParsedPkColumnNames(), data.toParsedPkData());
            if (xml != null) {
                this.toXmlElement(data.getDataEventType(), xml, triggerHistory.getSourceCatalogName(), triggerHistory.getSourceSchemaName(), data.getTableName(), triggerHistory.getParsedColumnNames(), rowData, triggerHistory.getParsedPkColumnNames(), data.toParsedPkData());
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("'{}' not in list to publish", (Object)data.getTableName());
        }
        return Collections.emptySet();
    }

    public void setOnePerBatch(boolean onePerBatch) {
        this.onePerBatch = onePerBatch;
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean isDmlOnly() {
        return true;
    }
}

