/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jumpmind.symmetric.model.BatchAck;
import org.jumpmind.symmetric.service.IAcknowledgeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.transport.AbstractTransportManager;
import org.jumpmind.symmetric.web.AbstractUriHandler;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.ServletUtils;

public class AckUriHandler
extends AbstractUriHandler {
    private static final Comparator<BatchAck> BATCH_ID_COMPARATOR = new Comparator<BatchAck>(){

        @Override
        public int compare(BatchAck batchInfo1, BatchAck batchInfo2) {
            Long batchId1 = batchInfo1.getBatchId();
            Long batchId2 = batchInfo2.getBatchId();
            return batchId1.compareTo(batchId2);
        }
    };
    private IAcknowledgeService acknowledgeService;
    private boolean isStandalone = false;

    public AckUriHandler(IParameterService parameterService, IAcknowledgeService acknowledgeService, IInterceptor ... interceptors) {
        super("/ack/*", parameterService, interceptors);
        this.acknowledgeService = acknowledgeService;
        if ("true".equals(System.getProperty("symmetric.standalone.web"))) {
            this.isStandalone = true;
        }
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Reading ack from node {} at remote address {}: {}", new Object[]{ServletUtils.getParameter(req, "nodeId"), req.getRemoteAddr(), req.getParameterMap()});
        }
        String queue = req.getHeader("threadChannel");
        List batches = AbstractTransportManager.readAcknowledgement((Map)req.getParameterMap());
        Collections.sort(batches, BATCH_ID_COMPARATOR);
        if (this.isStandalone) {
            res.setHeader("Transfer-Encoding", "chunked");
        }
        long keepAliveMillis = this.parameterService.getLong("send.ack.keepalive.ms");
        long ts = System.currentTimeMillis();
        PrintWriter writer = res.getWriter();
        for (BatchAck batchInfo : batches) {
            this.acknowledgeService.ack(batchInfo);
            if (keepAliveMillis > 0L && System.currentTimeMillis() - ts >= keepAliveMillis) {
                try {
                    writer.write("1=1&");
                    writer.flush();
                }
                catch (Exception e) {
                    this.log.info("Unable to keep client connection alive.  " + e.getClass().getName() + ": " + e.getMessage());
                    keepAliveMillis = 0L;
                }
            }
            ts = System.currentTimeMillis();
        }
        writer.close();
        this.acknowledgeService.checkMissingAck(batches, queue);
    }
}

