/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.transport.TransportUtils;
import org.jumpmind.symmetric.web.AbstractUriHandler;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.ServletUtils;

public class ConfigurationUriHandler
extends AbstractUriHandler {
    private IDataExtractorService dataExtractorService;

    public ConfigurationUriHandler(IParameterService parameterService, IDataExtractorService dataExtractorService, IInterceptor ... interceptors) {
        super("/config/*", parameterService, interceptors);
        this.dataExtractorService = dataExtractorService;
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Node remoteNode = new Node();
        String symVersion = ServletUtils.getParameter(req, "symmetricVersion");
        String configVersion = ServletUtils.getParameter(req, "configVersion");
        remoteNode.setNodeId(ServletUtils.getParameter(req, "nodeId"));
        remoteNode.setSymmetricVersion(symVersion);
        remoteNode.setConfigVersion(configVersion);
        this.log.info("Configuration request from node ID " + remoteNode.getNodeId() + " {symmetricVersion={}, configVersion={}}", (Object)symVersion, (Object)configVersion);
        if (StringUtils.isBlank((CharSequence)configVersion) || Version.isOlderMinorVersion((String)configVersion, (String)Version.version())) {
            this.log.info("Sending configuration to node ID " + remoteNode.getNodeId());
            ServletOutputStream outputStream = res.getOutputStream();
            this.dataExtractorService.extractConfigurationStandalone(remoteNode, (Writer)TransportUtils.toWriter((OutputStream)outputStream), TableConstants.getConfigTablesExcludedFromExport());
        }
    }
}

