/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.web.AbstractUriHandler;
import org.jumpmind.symmetric.web.IInterceptor;

public class InfoUriHandler
extends AbstractUriHandler {
    private INodeService nodeService;
    private IConfigurationService configurationService;
    private IClusterService clusterService;

    public InfoUriHandler(IParameterService parameterService, INodeService nodeService, IConfigurationService configurationService, IClusterService clusterService, IInterceptor[] interceptors) {
        super("/info/*", parameterService, interceptors);
        this.nodeService = nodeService;
        this.configurationService = configurationService;
        this.clusterService = clusterService;
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        res.setContentType("text/plain");
        Node node = this.nodeService.findIdentity();
        List nodeGroupLinks = this.configurationService.getNodeGroupLinks(true);
        Properties properties = new Properties();
        properties.setProperty("external.id", this.parameterService.getExternalId());
        properties.setProperty("group.id", this.parameterService.getNodeGroupId());
        properties.setProperty("external.id", this.parameterService.getExternalId());
        if (nodeGroupLinks != null) {
            HashSet<String> groups = new HashSet<String>();
            StringBuilder b = new StringBuilder();
            for (NodeGroupLink nodeGroupLink : nodeGroupLinks) {
                if (nodeGroupLink.getSourceNodeGroupId().equals(node.getNodeGroupId())) {
                    groups.add(nodeGroupLink.getTargetNodeGroupId());
                    continue;
                }
                if (!nodeGroupLink.getTargetNodeGroupId().equals(node.getNodeGroupId())) continue;
                groups.add(nodeGroupLink.getSourceNodeGroupId());
            }
            for (String group : groups) {
                b.append(group).append(",");
            }
            properties.setProperty("group.ids", b.substring(0, b.length() > 0 ? b.length() - 1 : 0));
        }
        if (node != null) {
            properties.setProperty("node.id", node.getNodeId());
            if (node.getDatabaseType() != null) {
                properties.setProperty("database.type", node.getDatabaseType());
            }
            if (node.getDatabaseVersion() != null) {
                properties.setProperty("database.version", node.getDatabaseVersion());
            }
            if (node.getDeploymentType() != null) {
                properties.setProperty("deployment.type", node.getDeploymentType());
            }
            if (node.getSymmetricVersion() != null) {
                properties.setProperty("symmetric.version", node.getSymmetricVersion());
            }
        }
        properties.setProperty("bulk.loader.enabled", String.valueOf(this.configurationService.isBulkLoaderEnabled()));
        boolean isClustered = this.parameterService.is("cluster.lock.enabled");
        properties.setProperty("cluster.lock.enabled", Boolean.toString(isClustered));
        if (isClustered) {
            properties.setProperty("cluster.server.id", this.clusterService.getServerId());
        }
        properties.store((OutputStream)res.getOutputStream(), "SymmetricDS");
        res.flushBuffer();
    }
}

