/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.web.AbstractUriHandler;
import org.jumpmind.symmetric.web.IInterceptor;

public class PingUriHandler
extends AbstractUriHandler {
    public PingUriHandler(IParameterService parameterService, IInterceptor[] interceptors) {
        super("/ping/*", parameterService, interceptors);
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        res.setContentType("text/plain");
        res.getWriter().write("pong");
    }

    public void bandwidthTest(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        res.setContentType("text/plain");
        Long start = System.currentTimeMillis();
        long end = start + 5000L;
        while (System.currentTimeMillis() < end) {
            res.getWriter().write(StringEscapeUtils.escapeHtml4((String)RandomStringUtils.randomAlphabetic((int)600)));
        }
    }
}

