/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.jumpmind.symmetric.service.INodeCommunicationService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.web.AbstractUriHandler;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.ServletUtils;
import org.springframework.util.StringUtils;

public class PushStatusUriHandler
extends AbstractUriHandler {
    private INodeCommunicationService nodeCommunicationService;

    public PushStatusUriHandler(IParameterService parameterService, INodeCommunicationService nodeCommunicationService, IInterceptor ... interceptors) {
        super("/pushstatus/*", parameterService, interceptors);
        this.nodeCommunicationService = nodeCommunicationService;
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException, FileUploadException {
        String nodeId = ServletUtils.getParameter(req, "nodeId");
        String batchToSendCountParam = ServletUtils.getParameter(req, "Batch-To-Send-Count");
        this.log.debug("Push stats for nodeId: {} batchToSendCountParam: '{}'", (Object)nodeId, (Object)batchToSendCountParam);
        if (StringUtils.hasLength((String)batchToSendCountParam)) {
            try {
                Map queuesToBatchCounts = this.nodeCommunicationService.parseQueueToBatchCounts(batchToSendCountParam);
                this.log.debug("Push stats for nodeId: {} queuesToBatchCounts: '{}'", (Object)nodeId, (Object)queuesToBatchCounts);
                this.nodeCommunicationService.updateBatchToSendCounts(nodeId, queuesToBatchCounts);
            }
            catch (Exception ex) {
                String msg = "Failed to parse batchToSendCountParam [" + batchToSendCountParam + "] " + req;
                this.log.warn(msg, (Throwable)ex);
                res.sendError(603, "Couldn't parse batch_to_send_count.");
            }
        }
    }
}

