/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.util.SnapshotUtil;
import org.jumpmind.symmetric.web.AbstractUriHandler;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.ServletUtils;

public class SnapshotUriHandler
extends AbstractUriHandler {
    private ISymmetricEngine engine;

    public SnapshotUriHandler(ISymmetricEngine engine, IInterceptor[] interceptors) {
        super("/snapshot/*", engine.getParameterService(), interceptors);
        this.engine = engine;
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (req.getMethod().equals("POST")) {
            String secret;
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (new File(tmpDir, secret = IOUtils.toString((InputStream)req.getInputStream(), (Charset)StandardCharsets.UTF_8)).exists()) {
                try (ServletOutputStream resOutputStream = res.getOutputStream();){
                    resOutputStream.print("Taking snapshot");
                    File snapshot = SnapshotUtil.createSnapshot((ISymmetricEngine)this.engine, (engineName, stepNumber, totalSteps) -> {
                        try {
                            resOutputStream.print(".");
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                    resOutputStream.println();
                    resOutputStream.println("Created snapshot file in " + snapshot.getCanonicalPath());
                }
            } else {
                ServletUtils.sendError(res, 659);
            }
        } else {
            ServletUtils.sendError(res, 659);
        }
    }
}

