/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.extension.IExtensionPoint;
import org.jumpmind.properties.DefaultParameterParser;
import org.jumpmind.properties.SortedProperties;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.security.SecurityServiceFactory;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ITypedPropertiesFactory;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.common.ParameterConstants;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.ext.IDatabaseInstallStatementListener;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroup;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.util.PropertiesUtil;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.symmetric.web.FailedEngineInfo;
import org.jumpmind.symmetric.web.ServerSymmetricEngine;
import org.jumpmind.symmetric.web.SymmetricEngineStarter;
import org.jumpmind.util.CustomizableThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class SymmetricEngineHolder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static Map<String, ServerSymmetricEngine> staticEngines = Collections.synchronizedMap(new HashMap());
    private static Set<SymmetricEngineStarter> staticEnginesStarting = Collections.synchronizedSet(new HashSet());
    private static Set<String> staticEnginesStartingNames = Collections.synchronizedSortedSet(new TreeSet());
    private static Map<String, FailedEngineInfo> staticEnginesFailed = Collections.synchronizedMap(new HashMap());
    private Map<String, ServerSymmetricEngine> engines = Collections.synchronizedMap(new HashMap());
    private Set<SymmetricEngineStarter> enginesStarting = Collections.synchronizedSet(new HashSet());
    private Set<String> enginesStartingNames = Collections.synchronizedSortedSet(new TreeSet());
    private Map<String, FailedEngineInfo> enginesFailed = Collections.synchronizedMap(new HashMap());
    private ExecutorService restartExecutor;
    private boolean staticEnginesMode = false;
    private boolean multiServerMode = false;
    private boolean autoStart = true;
    private boolean autoCreate = true;
    private ApplicationContext springContext;
    private String singleServerPropertiesFile;
    private String deploymentType = "server";
    private boolean holderHasBeenStarted = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            SymmetricUtils.logNotices();
            if (this.staticEnginesMode) {
                this.log.info("In static engine mode");
                this.engines = staticEngines;
                this.enginesStarting = staticEnginesStarting;
                this.enginesStartingNames = staticEnginesStartingNames;
                this.enginesFailed = staticEnginesFailed;
            }
            if (this.autoCreate) {
                this.log.info("Current directory is {}", (Object)System.getProperty("user.dir"));
                if (this.isMultiServerMode()) {
                    String enginesDirname = PropertiesUtil.getEnginesDir();
                    this.log.info("Starting in multi-server mode with engines directory at {}", (Object)enginesDirname);
                    File enginesDir = new File(enginesDirname);
                    File[] files = null;
                    if (enginesDir != null) {
                        files = enginesDir.listFiles();
                    }
                    if (files == null) {
                        String firstAttempt = enginesDir.getAbsolutePath();
                        enginesDir = new File(".");
                        this.log.warn("Unable to retrieve engine properties files from {}.  Trying current working directory {}", (Object)firstAttempt, (Object)enginesDir.getAbsolutePath());
                        if (enginesDir != null) {
                            files = enginesDir.listFiles();
                        }
                    }
                    if (files != null) {
                        this.validateEngineFiles(files);
                        boolean found = false;
                        for (int i = 0; i < files.length; ++i) {
                            File file = files[i];
                            if (!file.getName().endsWith(".properties")) continue;
                            this.enginesStarting.add(new SymmetricEngineStarter(file.getAbsolutePath(), this));
                            found = true;
                        }
                        if (!found) {
                            this.log.info("No engine *.properties files found");
                        }
                    } else {
                        this.log.error("Unable to retrieve engine properties files from default location or from current working directory.  No engines to start.");
                    }
                } else {
                    URL singleServerPropertiesURL;
                    this.log.info("Starting in single-server mode");
                    if (StringUtils.isBlank((CharSequence)this.singleServerPropertiesFile) && (singleServerPropertiesURL = this.getClass().getClassLoader().getResource("/symmetric.properties")) != null) {
                        this.singleServerPropertiesFile = singleServerPropertiesURL.getFile();
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.singleServerPropertiesFile)) {
                        this.enginesStarting.add(new SymmetricEngineStarter(this.singleServerPropertiesFile, this));
                    } else {
                        this.log.info("No engine symmetric.properties file found");
                    }
                }
                int poolSize = Integer.parseInt(System.getProperty("symmetric.concurrent.engines.starting.count", "5"));
                ExecutorService executor = Executors.newFixedThreadPool(poolSize, (ThreadFactory)new CustomizableThreadFactory("symmetric-engine-startup"));
                for (SymmetricEngineStarter starter : this.enginesStarting) {
                    executor.execute(starter);
                }
                executor.shutdown();
            }
        }
        finally {
            this.holderHasBeenStarted = true;
        }
    }

    public synchronized void restart(String engineName) {
        FailedEngineInfo info = this.enginesFailed.get(engineName);
        if (info != null) {
            ISymmetricEngine engine = (ISymmetricEngine)this.engines.get(engineName);
            if (engine != null) {
                try {
                    engine.destroy();
                }
                catch (Exception e) {
                    this.log.warn("Destroy of engine failed", (Throwable)e);
                }
                this.engines.remove(engineName);
            }
            this.enginesFailed.remove(engineName);
            if (this.restartExecutor == null) {
                int poolSize = Integer.parseInt(System.getProperty("symmetric.concurrent.engines.starting.count", "5"));
                this.restartExecutor = Executors.newFixedThreadPool(poolSize, (ThreadFactory)new CustomizableThreadFactory("symmetric-engine-restart"));
            }
            SymmetricEngineStarter starter = new SymmetricEngineStarter(info.getPropertyFileName(), this);
            this.enginesStarting.add(starter);
            this.restartExecutor.execute(starter);
        }
    }

    public synchronized void stop() {
        for (ServerSymmetricEngine engine : this.engines.values()) {
            engine.destroy();
        }
        this.engines.clear();
        this.enginesFailed.clear();
    }

    public ISymmetricEngine install(Properties passedInProperties) throws Exception {
        return this.install(passedInProperties, null);
    }

    public ISymmetricEngine install(Properties passedInProperties, IDatabaseInstallStatementListener listener) throws Exception {
        String loadOnlyPassword;
        ITypedPropertiesFactory factory = PropertiesUtil.createTypedPropertiesFactory(null, (Properties)passedInProperties);
        TypedProperties properties = factory.reload(passedInProperties);
        String password = properties.getProperty("db.password");
        if (StringUtils.isNotBlank((CharSequence)password) && !password.startsWith("enc:")) {
            try {
                ISecurityService service = SecurityServiceFactory.create((SecurityServiceFactory.SecurityServiceType)SecurityServiceFactory.SecurityServiceType.CLIENT, (TypedProperties)properties);
                properties.setProperty("db.password", "enc:" + service.encrypt(password));
            }
            catch (Exception ex) {
                this.log.warn("Could not encrypt password", (Throwable)ex);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(loadOnlyPassword = properties.getProperty("target.db.password"))) && !loadOnlyPassword.startsWith("enc:")) {
            try {
                ISecurityService service = SecurityServiceFactory.create((SecurityServiceFactory.SecurityServiceType)SecurityServiceFactory.SecurityServiceType.CLIENT, (TypedProperties)properties);
                properties.setProperty("target.db.password", "enc:" + service.encrypt(loadOnlyPassword));
            }
            catch (Exception ex) {
                this.log.warn("Could not encrypt load-only password", (Throwable)ex);
            }
        }
        String engineName = this.validateRequiredProperties((Properties)properties);
        passedInProperties.setProperty("engine.name", engineName);
        properties = factory.reload((Properties)properties);
        if (this.engines.get(engineName) != null) {
            try {
                this.engines.get(engineName).stop();
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
            this.engines.remove(engineName);
        }
        File enginesDir = new File(PropertiesUtil.getEnginesDir());
        File symmetricProperties = new File(enginesDir, engineName + ".properties");
        try {
            SortedProperties sortedProperties = new SortedProperties();
            sortedProperties.putAll((Properties)properties);
            factory.save((Properties)sortedProperties, symmetricProperties, "Updated by SymmetricDS Pro");
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to write symmetric.properties to engine directory", ex);
        }
        ISymmetricEngine engine = null;
        try {
            String registrationUrl = properties.getProperty("registration.url");
            if (StringUtils.isNotBlank((CharSequence)registrationUrl)) {
                Collection<ServerSymmetricEngine> all = this.getEngines().values();
                for (ISymmetricEngine iSymmetricEngine : all) {
                    IRegistrationService registrationService;
                    if (!iSymmetricEngine.getParameterService().getSyncUrl().equals(registrationUrl)) continue;
                    String serverNodeGroupId = iSymmetricEngine.getParameterService().getNodeGroupId();
                    String clientNodeGroupId = properties.getProperty("group.id");
                    String externalId = properties.getProperty("external.id");
                    IConfigurationService configurationService = iSymmetricEngine.getConfigurationService();
                    ITriggerRouterService triggerRouterService = iSymmetricEngine.getTriggerRouterService();
                    List groups = configurationService.getNodeGroups();
                    boolean foundGroup = false;
                    for (NodeGroup nodeGroup : groups) {
                        if (!nodeGroup.getNodeGroupId().equals(clientNodeGroupId)) continue;
                        foundGroup = true;
                    }
                    if (!foundGroup) {
                        configurationService.saveNodeGroup(new NodeGroup(clientNodeGroupId));
                        NodeGroupLink serverToClientLink = new NodeGroupLink(serverNodeGroupId, clientNodeGroupId, NodeGroupLinkAction.W);
                        configurationService.saveNodeGroupLink(serverToClientLink);
                        NodeGroupLink clientToServerLink = new NodeGroupLink(clientNodeGroupId, serverNodeGroupId, NodeGroupLinkAction.P);
                        configurationService.saveNodeGroupLink(clientToServerLink);
                        Router serverToClientRouter = new Router("", serverToClientLink);
                        serverToClientRouter.setRouterId(serverToClientRouter.createDefaultName());
                        Router clientToServerRouter = new Router("", clientToServerLink);
                        clientToServerRouter.setRouterId(clientToServerRouter.createDefaultName());
                        triggerRouterService.saveRouter(serverToClientRouter);
                        triggerRouterService.saveRouter(clientToServerRouter);
                        triggerRouterService.syncTriggers();
                    } else {
                        boolean foundLink = false;
                        List links = configurationService.getNodeGroupLinksFor(serverNodeGroupId, false);
                        for (NodeGroupLink nodeGroupLink : links) {
                            if (!nodeGroupLink.getTargetNodeGroupId().equals(clientNodeGroupId)) continue;
                            foundLink = true;
                        }
                        if (!foundLink) {
                            configurationService.saveNodeGroupLink(new NodeGroupLink(serverNodeGroupId, clientNodeGroupId, NodeGroupLinkAction.W));
                            triggerRouterService.syncTriggers();
                        }
                    }
                    if ((registrationService = iSymmetricEngine.getRegistrationService()).isAutoRegistration() || registrationService.isRegistrationOpen(clientNodeGroupId, externalId)) continue;
                    Node node = new Node((Properties)properties);
                    if (TableConstants.getTables((String)"").contains("console_user")) {
                        node.setDeploymentType("professional");
                    }
                    registrationService.openRegistration(node);
                }
            }
            if ((engine = this.create(symmetricProperties.getAbsolutePath())) != null) {
                if (listener != null) {
                    engine.getExtensionService().addExtensionPoint((IExtensionPoint)listener);
                }
                engine.start();
            } else {
                FileUtils.deleteQuietly((File)symmetricProperties);
                this.log.warn("The engine could not be created.  It will not be started");
            }
            return engine;
        }
        catch (RuntimeException ex) {
            if (engine != null) {
                engine.destroy();
            }
            FileUtils.deleteQuietly((File)symmetricProperties);
            throw ex;
        }
    }

    public void uninstallEngine(ISymmetricEngine engine) {
        Node node = engine.getNodeService().getCachedIdentity();
        String engineName = engine.getEngineName();
        File file = PropertiesUtil.findPropertiesFileForEngineWithName((String)engineName, (Map)engine.getParameterService().getReplacementValues());
        engine.uninstall();
        engine.destroy();
        if (file != null) {
            file.delete();
        }
        this.getEngines().remove(engineName);
        for (ISymmetricEngine iSymmetricEngine : this.getEngines().values()) {
            iSymmetricEngine.removeAndCleanupNode(node.getNodeId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISymmetricEngine create(String propertiesFile) {
        ServerSymmetricEngine engine = null;
        File file = new File(propertiesFile);
        String engineName = FilenameUtils.removeExtension((String)file.getName());
        try {
            TypedProperties properties = new TypedProperties();
            try (FileInputStream is = new FileInputStream(file.getAbsolutePath());){
                properties.load((InputStream)is);
            }
            engineName = this.getEngineName((Properties)properties);
            this.enginesStartingNames.add(engineName);
            this.validateRequiredProperties((Properties)properties);
            engine = new ServerSymmetricEngine(file, this.springContext, this);
            engine.setDeploymentType(this.deploymentType);
            engine.setDeploymentSubType(SymmetricUtils.getDeploymentSubType((Properties)properties));
            SymmetricEngineHolder symmetricEngineHolder = this;
            synchronized (symmetricEngineHolder) {
                if (!this.engines.containsKey(engine.getEngineName())) {
                    this.engines.put(engine.getEngineName(), engine);
                } else {
                    String message = "An engine with the name of " + engine.getEngineName() + " was not started because an engine of the same name has already been started.  Please set the engine.name property in the properties file to a unique name.";
                    this.log.error(message);
                    this.enginesFailed.put(engineName, new FailedEngineInfo(engineName, propertiesFile, message));
                    engine = null;
                }
            }
        }
        catch (Exception e) {
            this.log.error("Failed to initialize engine", (Throwable)e);
            this.enginesFailed.put(engineName, new FailedEngineInfo(engineName, propertiesFile, e));
            engine = null;
        }
        this.enginesStartingNames.remove(engineName);
        return engine;
    }

    protected void validateEngineFiles(File[] files) {
        LinkedHashMap<String, String> dbToPropertyFiles = new LinkedHashMap<String, String>();
        for (File file : files) {
            if (!file.getName().endsWith(".properties")) continue;
            Properties properties = new Properties();
            try (FileInputStream fileInputStream = new FileInputStream(file.getAbsolutePath());){
                properties.load(fileInputStream);
                String userUrl = String.format("%s@%s", properties.getProperty("db.user", ""), properties.getProperty("db.url", ""));
                String KEY = String.format("%s@%s", "db.user", "db.url");
                this.checkDuplicate(userUrl, KEY, dbToPropertyFiles, file);
            }
            catch (Exception ex) {
                if (ex instanceof SymmetricException) {
                    this.log.error("**** FATAL **** error " + ex);
                    throw (SymmetricException)ex;
                }
                this.log.warn("Failed to validate engine properties file " + file, (Throwable)ex);
            }
        }
    }

    protected void checkDuplicate(String value, String key, Map<String, String> values, File propertiesFile) {
        if (values.containsKey(value)) {
            throw new SymmetricException(String.format("Invalid configuration detected. 2 properties files reference the same %s: '%s'. Maybe an engines file was copied and needs to be moved. See: %s and %s.", key, value, values.get(value), propertiesFile.getAbsolutePath()), new Object[0]);
        }
        values.put(value, propertiesFile.getAbsolutePath());
    }

    public String getEngineName(Properties properties) {
        Object engineName = properties.getProperty("engine.name");
        if (StringUtils.isBlank((CharSequence)engineName)) {
            String groupId;
            String externalId = properties.getProperty("external.id", "");
            engineName = externalId.equals(groupId = properties.getProperty("group.id", "")) ? groupId : groupId + "-" + externalId;
            engineName = ((String)engineName).replaceAll(" ", "_");
            Object engineExt = "";
            int engineNumber = 0;
            while (new File(PropertiesUtil.getEnginesDir(), (String)engineName + (String)engineExt + ".properties").exists()) {
                engineExt = "-" + ++engineNumber;
            }
            engineName = (String)engineName + (String)engineExt;
        }
        return engineName;
    }

    public String validateRequiredProperties(Properties properties) {
        String externalId = properties.getProperty("external.id");
        if (StringUtils.isBlank((CharSequence)externalId)) {
            throw new IllegalStateException("Missing property external.id");
        }
        String groupId = properties.getProperty("group.id");
        if (StringUtils.isBlank((CharSequence)groupId)) {
            throw new IllegalStateException("Missing property group.id");
        }
        String engineName = this.getEngineName(properties);
        properties.setProperty("engine.name", engineName);
        if (StringUtils.isBlank((CharSequence)properties.getProperty("sync.url"))) {
            DefaultParameterParser.ParameterMetaData parameterMeta = (DefaultParameterParser.ParameterMetaData)ParameterConstants.getParameterMetaData().get("sync.url");
            String defaultValue = "http://$(hostName):31415/sync/$(engineName)";
            if (parameterMeta != null) {
                defaultValue = parameterMeta.getDefaultValue();
            }
            this.log.debug("Defaulting node {} sync.url to {}", (Object)externalId, (Object)defaultValue);
            properties.setProperty("sync.url", defaultValue);
        }
        if (StringUtils.isBlank((CharSequence)properties.getProperty("db.driver"))) {
            throw new IllegalStateException("Missing property db.driver");
        }
        if (StringUtils.isBlank((CharSequence)properties.getProperty("db.url"))) {
            throw new IllegalStateException("Missing property db.url");
        }
        if (!properties.containsKey("db.user")) {
            throw new IllegalStateException("Missing property db.user");
        }
        if (!properties.containsKey("db.password")) {
            throw new IllegalStateException("Missing property db.password");
        }
        if (!properties.containsKey("registration.url")) {
            properties.setProperty("registration.url", "");
        }
        return engineName;
    }

    public boolean hasAnyEngineInitialized() {
        for (ServerSymmetricEngine engine : this.engines.values()) {
            if (!engine.isInitialized()) continue;
            return true;
        }
        return false;
    }

    public boolean areEnginesStarting() {
        return !this.holderHasBeenStarted || this.enginesStarting.size() > 0;
    }

    public boolean areEnginesConfigured() {
        return this.enginesStarting.size() > 0 || this.engines.size() > 0 || this.enginesFailed.size() > 0;
    }

    public boolean areEnginesInError() {
        return this.enginesFailed.size() > 0;
    }

    public int getNumerOfEnginesStarting() {
        return this.enginesStarting.size();
    }

    public Map<String, ServerSymmetricEngine> getEngines() {
        return this.engines;
    }

    public int getEngineCount() {
        return this.engines.size() + this.enginesFailed.size();
    }

    public Set<SymmetricEngineStarter> getEnginesStarting() {
        return this.enginesStarting;
    }

    public Set<String> getEnginesStartingNames() {
        return this.enginesStartingNames;
    }

    public Map<String, FailedEngineInfo> getEnginesFailed() {
        return this.enginesFailed;
    }

    public Set<String> getEnginesFailedNames() {
        return this.enginesFailed.keySet();
    }

    public void setSpringContext(ApplicationContext applicationContext) {
        this.springContext = applicationContext;
    }

    public ApplicationContext getSpringContext() {
        return this.springContext;
    }

    public void setDeploymentType(String deploymentType) {
        this.deploymentType = deploymentType;
    }

    public String getDeploymentType() {
        return this.deploymentType;
    }

    public void setMultiServerMode(boolean multiServerMode) {
        this.multiServerMode = multiServerMode;
    }

    public boolean isMultiServerMode() {
        return this.multiServerMode;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public void setStaticEnginesMode(boolean staticEnginesMode) {
        this.staticEnginesMode = staticEnginesMode;
    }

    public boolean isStaticEnginesMode() {
        return this.staticEnginesMode;
    }

    public void setSingleServerPropertiesFile(String singleServerPropertiesFile) {
        this.singleServerPropertiesFile = singleServerPropertiesFile;
    }

    public String getSingleServerPropertiesFile() {
        return this.singleServerPropertiesFile;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }
}

