/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.IUriHandler;
import org.jumpmind.symmetric.web.ServerSymmetricEngine;
import org.jumpmind.symmetric.web.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SymmetricServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final int MAX_NETWORK_ERROR_FOR_LOGGING = 5;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected Map<String, Integer> rejectionStatusByEngine = new HashMap<String, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServerSymmetricEngine engine = ServletUtils.findEngine(req, this.getServletContext());
        MDC.put((String)"engineName", (String)(engine != null ? engine.getEngineName() : "?"));
        if (engine == null) {
            if (ServletUtils.getSymmetricEngineHolder(this.getServletContext()).areEnginesStarting()) {
                if (this.shouldLog(ServletUtils.getEngineNameFromUrl(req), 1)) {
                    this.log.info("Requests for engine {} are being rejected because nodes are still initializing", (Object)ServletUtils.getEngineNameFromUrl(req));
                }
                this.sendError(req, res, 660, "Service is starting");
                return;
            } else {
                this.log.warn("Rejected request for unknown engine {} from host {} with URI of {}", new Object[]{ServletUtils.getEngineNameFromUrl(req), this.getHost(req), ServletUtils.normalizeRequestUri(req)});
                this.sendError(req, res, 602, "No engine here with that name");
            }
            return;
        } else if (engine.isStarted()) {
            IUriHandler handler = this.findMatchingHandler(engine, req);
            if (handler != null) {
                List<IInterceptor> beforeInterceptors = handler.getInterceptors();
                ArrayList<IInterceptor> afterInterceptors = null;
                try {
                    String nodeId = req.getParameter("nodeId");
                    if (beforeInterceptors != null) {
                        afterInterceptors = new ArrayList<IInterceptor>(beforeInterceptors.size());
                        for (IInterceptor interceptor : beforeInterceptors) {
                            if (!interceptor.before(req, res)) {
                                return;
                            }
                            afterInterceptors.add(interceptor);
                        }
                    }
                    handler.handle(req, res);
                    engine.resetErrorCountForNode(nodeId);
                    return;
                }
                catch (Exception e) {
                    this.logException(req, engine, e);
                    if (!res.isCommitted()) {
                        ServletUtils.sendError(res, 600, "Internal error occurred, see log file");
                    }
                }
                finally {
                    if (afterInterceptors == null) return;
                    for (IInterceptor interceptor : afterInterceptors) {
                        interceptor.after(req, res);
                    }
                    return;
                }
            } else {
                this.sendError(req, res, 603, "No matching URI handler");
            }
            return;
        } else if (engine.isStarting()) {
            if (this.shouldLog(engine.getEngineName(), 2)) {
                this.log.info("Requests for engine {} are being rejected while it is starting", (Object)engine.getEngineName());
            }
            this.sendError(req, res, 660, "Engine is starting");
            return;
        } else if (!engine.isConfigured()) {
            if (this.shouldLog(engine.getEngineName(), 3)) {
                this.log.info("Requests for engine {} are being rejected because it is not configured properly", (Object)engine.getEngineName());
            }
            this.sendError(req, res, 660, "Engine is not configured");
            return;
        } else {
            if (this.shouldLog(engine.getEngineName(), 4)) {
                this.log.info("Requests for engine {} are being rejected because it is not started", (Object)engine.getEngineName());
            }
            this.sendError(req, res, 660, "Engine is not started");
        }
    }

    protected Collection<IUriHandler> getUriHandlersFrom(ServerSymmetricEngine engine) {
        if (engine != null) {
            return engine.getUriHandlers();
        }
        return null;
    }

    protected IUriHandler findMatchingHandler(ServerSymmetricEngine engine, HttpServletRequest req) throws ServletException {
        Collection<IUriHandler> handlers = this.getUriHandlersFrom(engine);
        if (handlers != null) {
            for (IUriHandler handler : handlers) {
                if (!this.matchesUriPattern(this.normalizeUri((ISymmetricEngine)engine, req), handler.getUriPattern()) || !handler.isEnabled()) continue;
                return handler;
            }
        }
        return null;
    }

    protected boolean matchesUriPattern(String uri, String uriPattern) {
        boolean retVal = false;
        String path = (String)StringUtils.defaultIfEmpty((CharSequence)uri, (CharSequence)"/");
        String pattern = (String)StringUtils.defaultIfEmpty((CharSequence)uriPattern, (CharSequence)"/");
        if ("/".equals(pattern) || "/*".equals(pattern) || pattern.equals(path)) {
            retVal = true;
        } else {
            String[] patternParts = StringUtils.split((String)pattern, (String)"/");
            String[] pathParts = StringUtils.split((String)path, (String)"/");
            boolean matches = true;
            for (int i = 0; i < patternParts.length && i < pathParts.length && matches; ++i) {
                String patternPart = patternParts[i];
                matches = "*".equals(patternPart) || patternPart.equals(pathParts[i]);
            }
            retVal = matches;
        }
        return retVal;
    }

    protected String normalizeUri(ISymmetricEngine engine, HttpServletRequest req) {
        String removeString;
        String uri = ServletUtils.normalizeRequestUri(req);
        if (engine != null && uri.startsWith(removeString = "/" + engine.getEngineName())) {
            uri = uri.substring(removeString.length());
        }
        return uri;
    }

    protected void logException(HttpServletRequest req, ServerSymmetricEngine engine, Exception ex) {
        String nodeId = req.getParameter("nodeId");
        String externalId = req.getParameter("externalId");
        String method = req instanceof HttpServletRequest ? req.getMethod() : "";
        Throwable root = ExceptionUtils.getRootCause((Throwable)ex);
        int errorCount = engine.getErrorCountFor(nodeId);
        Object msg = String.format("Error while processing %s request for node: %s", method, nodeId);
        if (!StringUtils.isEmpty((CharSequence)externalId) && !StringUtils.equals((CharSequence)nodeId, (CharSequence)externalId)) {
            msg = (String)msg + String.format(" externalId: %s", externalId);
        }
        msg = (String)msg + " at " + this.getHost(req);
        msg = (String)msg + String.format(" with path: %s", ServletUtils.normalizeRequestUri(req));
        if (!(ex instanceof IOException) && !(root instanceof IOException) || errorCount >= 5) {
            this.log.error((String)msg, (Throwable)ex);
        } else if (this.log.isDebugEnabled()) {
            this.log.info((String)msg, (Throwable)ex);
        } else {
            this.log.info((String)msg + " The message is: {} {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
        }
        engine.incrementErrorCountForNode(nodeId);
    }

    protected String getHost(HttpServletRequest req) {
        String address = req.getRemoteAddr();
        String hostName = req.getRemoteHost();
        if (!StringUtils.isEmpty((CharSequence)hostName) && !StringUtils.isEmpty((CharSequence)address)) {
            if (StringUtils.equals((CharSequence)hostName, (CharSequence)address)) {
                return hostName;
            }
            return hostName + " (" + address + ")";
        }
        if (!StringUtils.isEmpty((CharSequence)hostName)) {
            return hostName;
        }
        return address;
    }

    protected void sendError(HttpServletRequest req, HttpServletResponse res, int code, String message) throws IOException {
        this.log.debug("Rejecting request {} from host {} with code {} and message: {}", new Object[]{ServletUtils.normalizeRequestUri(req), this.getHost(req), code, message});
        ServletUtils.sendError(res, code, message);
    }

    protected boolean shouldLog(String engineName, int status) {
        Integer lastStatus = this.rejectionStatusByEngine.get(engineName);
        if (lastStatus == null || lastStatus < status) {
            if (this.rejectionStatusByEngine.size() > 10000) {
                this.rejectionStatusByEngine.clear();
            }
            this.rejectionStatusByEngine.put(engineName, status);
            return true;
        }
        return false;
    }
}

