/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Objects;
import org.apache.commons.collections4.bloomfilter.BitMap;
import org.apache.commons.collections4.bloomfilter.BitMapProducer;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.CellProducer;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IndexProducer;

public interface CountingBloomFilter
extends BloomFilter,
CellProducer {
    public boolean add(CellProducer var1);

    @Override
    public CountingBloomFilter copy();

    public int getMaxCell();

    default public int getMaxInsert(BitMapProducer bitMapProducer) {
        if (!this.contains(bitMapProducer)) {
            return 0;
        }
        long[] bitMaps = bitMapProducer.asBitMapArray();
        int[] max = new int[]{Integer.MAX_VALUE};
        this.forEachCell((x, y) -> {
            if ((bitMaps[BitMap.getLongIndex(x)] & BitMap.getLongBit(x)) != 0L) {
                max[0] = max[0] <= y ? max[0] : y;
            }
            return true;
        });
        return max[0];
    }

    default public int getMaxInsert(BloomFilter bloomFilter) {
        return this.getMaxInsert((BitMapProducer)bloomFilter);
    }

    public int getMaxInsert(CellProducer var1);

    default public int getMaxInsert(Hasher hasher) {
        return this.getMaxInsert(hasher.indices(this.getShape()));
    }

    default public int getMaxInsert(IndexProducer idxProducer) {
        return this.getMaxInsert(CellProducer.from(idxProducer.uniqueIndices()));
    }

    public boolean isValid();

    @Override
    default public boolean merge(BitMapProducer bitMapProducer) {
        Objects.requireNonNull(bitMapProducer, "bitMapProducer");
        return this.merge(IndexProducer.fromBitMapProducer(bitMapProducer));
    }

    @Override
    default public boolean merge(BloomFilter other) {
        Objects.requireNonNull(other, "other");
        return this.merge((IndexProducer)other);
    }

    @Override
    default public boolean merge(Hasher hasher) {
        Objects.requireNonNull(hasher, "hasher");
        return this.merge(hasher.indices(this.getShape()));
    }

    @Override
    default public boolean merge(IndexProducer indexProducer) {
        Objects.requireNonNull(indexProducer, "indexProducer");
        try {
            return this.add(CellProducer.from(indexProducer.uniqueIndices()));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format("Filter only accepts values in the [0,%d) range", this.getShape().getNumberOfBits()), e);
        }
    }

    default public boolean remove(BitMapProducer bitMapProducer) {
        Objects.requireNonNull(bitMapProducer, "bitMapProducer");
        return this.remove(IndexProducer.fromBitMapProducer(bitMapProducer));
    }

    default public boolean remove(BloomFilter other) {
        Objects.requireNonNull(other, "other");
        return this.remove((IndexProducer)other);
    }

    default public boolean remove(Hasher hasher) {
        Objects.requireNonNull(hasher, "hasher");
        return this.remove(hasher.indices(this.getShape()));
    }

    default public boolean remove(IndexProducer indexProducer) {
        Objects.requireNonNull(indexProducer, "indexProducer");
        try {
            return this.subtract(CellProducer.from(indexProducer.uniqueIndices()));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format("Filter only accepts values in the [0,%d) range", this.getShape().getNumberOfBits()));
        }
    }

    public boolean subtract(CellProducer var1);

    @Override
    default public IndexProducer uniqueIndices() {
        return this;
    }
}

