/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import org.apache.commons.collections4.bloomfilter.BitMapProducer;
import org.apache.commons.collections4.bloomfilter.IndexUtils;

@FunctionalInterface
public interface IndexProducer {
    public static IndexProducer fromBitMapProducer(BitMapProducer producer) {
        Objects.requireNonNull(producer, "producer");
        return consumer -> {
            LongPredicate longPredicate = new LongPredicate(){
                int wordIdx;

                @Override
                public boolean test(long word) {
                    int i = this.wordIdx;
                    while (word != 0L) {
                        if ((word & 1L) == 1L && !consumer.test(i)) {
                            return false;
                        }
                        word >>>= 1;
                        ++i;
                    }
                    this.wordIdx += 64;
                    return true;
                }
            };
            return producer.forEachBitMap(longPredicate::test);
        };
    }

    public static IndexProducer fromIndexArray(final int ... values) {
        return new IndexProducer(){

            @Override
            public int[] asIndexArray() {
                return (int[])values.clone();
            }

            @Override
            public boolean forEachIndex(IntPredicate predicate) {
                for (int value : values) {
                    if (predicate.test(value)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    default public int[] asIndexArray() {
        class Indices {
            private int[] data = new int[32];
            private int size;

            Indices() {
            }

            boolean add(int index) {
                this.data = IndexUtils.ensureCapacityForAdd(this.data, this.size);
                this.data[this.size++] = index;
                return true;
            }

            int[] toArray() {
                return this.size == this.data.length ? this.data : Arrays.copyOf(this.data, this.size);
            }
        }
        Indices indices = new Indices();
        this.forEachIndex(indices::add);
        return indices.toArray();
    }

    public boolean forEachIndex(IntPredicate var1);

    default public IndexProducer uniqueIndices() {
        final BitSet bitSet = new BitSet();
        this.forEachIndex(i -> {
            bitSet.set(i);
            return true;
        });
        return new IndexProducer(){

            @Override
            public boolean forEachIndex(IntPredicate predicate) {
                int idx = bitSet.nextSetBit(0);
                while (idx >= 0) {
                    if (!predicate.test(idx)) {
                        return false;
                    }
                    idx = bitSet.nextSetBit(idx + 1);
                }
                return true;
            }

            @Override
            public IndexProducer uniqueIndices() {
                return this;
            }
        };
    }
}

