/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.db2;

import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.db2.Db2TriggerTemplate;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IParameterService;

public class Db2SymmetricDialect
extends AbstractSymmetricDialect
implements ISymmetricDialect {
    public static final String VAR_SOURCE_NODE_ID = "_source_node_id";
    public static final String VAR_TRIGGER_DISABLED = "_trigger_disabled";
    public static final String FUNCTION_TRANSACTION_ID = "_transactionid";
    static final String SQL_DROP_FUNCTION = "DROP FUNCTION $(functionName)";

    public Db2SymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new Db2TriggerTemplate(this);
    }

    public boolean createOrAlterTablesIfNecessary(String ... tables) {
        boolean tablesCreated = super.createOrAlterTablesIfNecessary(tables);
        if (tablesCreated) {
            this.log.info("Resetting auto increment columns for {}{}", (Object)this.parameterService.getTablePrefix(), (Object)"_data");
            long dataId = this.platform.getSqlTemplate().queryForLong("select max(data_id) from " + this.parameterService.getTablePrefix() + "_data", new Object[0]) + 1L;
            this.platform.getSqlTemplate().update("alter table " + this.parameterService.getTablePrefix() + "_data alter column data_id restart with " + dataId, new Object[0]);
        }
        return tablesCreated;
    }

    protected boolean doesTriggerExistOnPlatform(StringBuilder sqlBuffer, String catalog, String schema, String tableName, String triggerName) {
        if (schema == null) {
            schema = this.platform.getDefaultSchema();
        }
        if (schema != null) {
            schema = schema.toUpperCase();
        }
        triggerName = triggerName == null ? null : triggerName.toUpperCase();
        return this.platform.getSqlTemplate().queryForInt("SELECT COUNT(*) FROM " + this.getSystemSchemaName() + ".SYSTRIGGERS WHERE NAME = ? AND SCHEMA = ?", new Object[]{triggerName, schema}) > 0;
    }

    public String massageDataExtractionSql(String sql, boolean isContainsBigLob) {
        if (!this.getParameterService().is("db2.capture.transaction.id", false)) {
            sql = sql.replace("d.transaction_id, ", "");
        }
        return super.massageDataExtractionSql(sql, isContainsBigLob);
    }

    protected String getSystemSchemaName() {
        return "SYSIBM";
    }

    public void createRequiredDatabaseObjectsImpl(StringBuilder ddl) {
        Object sql;
        block8: {
            block7: {
                sql = "select " + this.getSourceNodeExpression() + " from sysibm.sysdummy1";
                try {
                    this.platform.getSqlTemplate().query((String)sql);
                }
                catch (Exception e) {
                    this.log.debug("Failed checking for variable (usually means it doesn't exist yet) '" + (String)sql + "'", (Throwable)e);
                    sql = "create variable " + this.getSourceNodeExpression() + " varchar(50)";
                    this.logSql((String)sql, ddl);
                    if (ddl != null) break block7;
                    this.platform.getSqlTemplate().update((String)sql, new Object[0]);
                }
            }
            sql = "select " + this.parameterService.getTablePrefix() + "_trigger_disabled from sysibm.sysdummy1";
            try {
                this.platform.getSqlTemplate().query((String)sql);
            }
            catch (Exception e) {
                this.log.debug("Failed checking for variable (usually means it doesn't exist yet) '" + (String)sql + "'", (Throwable)e);
                sql = "create variable " + this.parameterService.getTablePrefix() + "_trigger_disabled varchar(50)";
                this.logSql((String)sql, ddl);
                if (ddl != null) break block8;
                this.platform.getSqlTemplate().update((String)sql, new Object[0]);
            }
        }
        if (this.getParameterService().is("db2.capture.transaction.id", false)) {
            String transactionIdFunction = this.parameterService.getTablePrefix() + FUNCTION_TRANSACTION_ID;
            sql = "CREATE OR REPLACE FUNCTION $(functionName)()                                          RETURNS VARCHAR(100)                                                           LANGUAGE SQL                                                                   READS SQL DATA                                                                 RETURN                                                                              select c.application_id || '_' || u.uow_id                                     from sysibmadm.mon_connection_summary c ,sysibmadm.mon_current_uow u           where u.application_handle = c.application_handle and c.application_id = application_id()    ";
            try {
                this.install((String)sql, transactionIdFunction, ddl);
            }
            catch (Exception e) {
                this.log.warn("Unable to install function " + this.parameterService.getTablePrefix() + FUNCTION_TRANSACTION_ID);
            }
        }
    }

    public void dropRequiredDatabaseObjects() {
        if (this.getParameterService().is("db2.capture.transaction.id", false)) {
            String transactionIdFunction = this.parameterService.getTablePrefix() + FUNCTION_TRANSACTION_ID;
            try {
                this.uninstall(SQL_DROP_FUNCTION, transactionIdFunction);
            }
            catch (Exception e) {
                this.log.warn("Unable to uninstall function " + this.parameterService.getTablePrefix() + FUNCTION_TRANSACTION_ID);
            }
        }
    }

    public boolean isBlobSyncSupported() {
        return true;
    }

    public boolean isClobSyncSupported() {
        return true;
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.HEX;
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
        transaction.prepareAndExecute("set " + this.parameterService.getTablePrefix() + "_trigger_disabled = null", new Object[0]);
        transaction.prepareAndExecute("set " + this.getSourceNodeExpression() + " = null", new Object[0]);
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        transaction.prepareAndExecute("set " + this.parameterService.getTablePrefix() + "_trigger_disabled = 1", new Object[0]);
        if (nodeId != null) {
            transaction.prepareAndExecute("set " + this.getSourceNodeExpression() + " = '" + nodeId + "'", new Object[0]);
        }
    }

    public String getSyncTriggersExpression() {
        return this.parameterService.getTablePrefix() + "_trigger_disabled is null";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        if (this.getParameterService().is("db2.capture.transaction.id", false)) {
            return "sym_transactionid()";
        }
        return "null";
    }

    public boolean supportsTransactionId() {
        return this.getParameterService().is("db2.capture.transaction.id", false);
    }

    public void cleanDatabase() {
    }

    public void truncateTable(String tableName) {
        this.platform.getSqlTemplate().update("delete from " + tableName, new Object[0]);
    }

    protected String getDbSpecificDataHasChangedCondition(Trigger trigger) {
        return "var_old_data is null or var_row_data != var_old_data";
    }

    public String getSourceNodeExpression() {
        return this.parameterService.getTablePrefix() + VAR_SOURCE_NODE_ID;
    }

    public String getDatabaseTimeSQL() {
        return "select current_timestamp from sysibm.sysdummy1";
    }
}

