/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.db2;

import java.util.HashMap;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.db.AbstractTriggerTemplate;
import org.jumpmind.symmetric.db.ISymmetricDialect;

public class Db2TriggerTemplate
extends AbstractTriggerTemplate {
    public Db2TriggerTemplate(ISymmetricDialect symmetricDialect) {
        super(symmetricDialect);
        this.emptyColumnTemplate = "''";
        this.stringColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then $(oracleToClob)'' else $(oracleToClob)'\"' || replace(replace($(tableAlias).\"$(columnName)\",'\\','\\\\'),'\"','\\\"') || '\"' end";
        this.arrayColumnTemplate = null;
        this.numberColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else $(oracleToClob)'\"' || trim(char($(tableAlias).\"$(columnName)\")) || '\"' end";
        this.datetimeColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else $(oracleToClob)'\"' || lpad(rtrim(char(year(timestamp_iso($(tableAlias).\"$(columnName)\")))),4,'0') ||'-'||substr(digits(month(timestamp_iso($(tableAlias).\"$(columnName)\"))),9)||'-'||substr(digits(day(timestamp_iso($(tableAlias).\"$(columnName)\"))),9)||' '||substr(digits(hour(timestamp_iso($(tableAlias).\"$(columnName)\"))),9)||':'||substr(digits(minute(timestamp_iso($(tableAlias).\"$(columnName)\"))),9)||':'||substr(digits(second(timestamp_iso($(tableAlias).\"$(columnName)\"))),9)||'.'||RIGHT(REPEAT('0',6)||rtrim(char(microsecond(timestamp_iso($(tableAlias).\"$(columnName)\")))),6) || '\"' end";
        this.timeColumnTemplate = null;
        this.dateColumnTemplate = null;
        this.clobColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' when length($(tableAlias).\"$(columnName)\") > 32672 then '\b' else '\"' || replace(replace(cast($(tableAlias).\"$(columnName)\" as varchar(32672)),'\\','\\\\'),'\"','\\\"') || '\"' end";
        this.blobColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' when length($(tableAlias).\"$(columnName)\") > 16336 then hex('\b') else '\"' || hex(cast($(tableAlias).\"$(columnName)\" as varchar(16336) for bit data)) || '\"' end";
        this.xmlColumnTemplate = "'\"\b\"'";
        this.wrappedBlobColumnTemplate = null;
        this.booleanColumnTemplate = null;
        this.triggerConcatCharacter = "||";
        this.newTriggerValue = "new";
        this.oldTriggerValue = "old";
        this.oldColumnPrefix = "";
        this.newColumnPrefix = "";
        this.otherColumnTemplate = this.stringColumnTemplate;
        this.sqlTemplates = new HashMap();
        this.sqlTemplates.put("insertTriggerTemplate", "CREATE TRIGGER $(schemaName)$(triggerName)                                                                                                                                                             \n                                AFTER INSERT ON $(schemaName)$(tableName)                                                                                                                              \n                                REFERENCING NEW AS NEW                                                                                                                                                 \n                                FOR EACH ROW MODE DB2SQL                                                                                                                                               \n                                BEGIN ATOMIC                                                                                                                                                           \n                                    $(custom_before_insert_text) \n                                    IF $(syncOnInsertCondition) and $(syncOnIncomingBatchCondition) then                                                                                               \n                                        INSERT into $(defaultSchema)$(prefixName)_data                                                                                                                 \n                                            (table_name, event_type, trigger_hist_id, row_data, channel_id, transaction_id, source_node_id, external_data, create_time)                                \n                                        VALUES('$(targetTableName)', 'I', $(triggerHistoryId),                                                                                                         \n                                            $(oracleToClob)$(columns),                                                                                                                                 \n                                            $(channelExpression), $(txIdExpression), $(sourceNodeExpression),                                                                                              \n                                            $(externalSelect),                                                                                                                                         \n                                            CURRENT_TIMESTAMP);                                                                                                                                        \n                                    END IF;                                                                                                                                                            \n                                    $(custom_on_insert_text)                                                                                                                                           \n                                END                                                                                                                                                                    ");
        this.sqlTemplates.put("insertReloadTriggerTemplate", "CREATE TRIGGER $(schemaName)$(triggerName)                                                                                                                                                             \n                                AFTER INSERT ON $(schemaName)$(tableName)                                                                                                                              \n                                REFERENCING NEW AS NEW                                                                                                                                                 \n                                FOR EACH ROW MODE DB2SQL                                                                                                                                               \n                                BEGIN ATOMIC                                                                                                                                                           \n                                    $(custom_before_insert_text) \n                                    IF $(syncOnInsertCondition) and $(syncOnIncomingBatchCondition) then                                                                                               \n                                        INSERT into $(defaultSchema)$(prefixName)_data                                                                                                                 \n                                            (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id, source_node_id, external_data, create_time)                                \n                                        VALUES('$(targetTableName)', 'R', $(triggerHistoryId),                                                                                                         \n                                            $(oracleToClob)$(newKeys),                                                                                                                                 \n                                            $(channelExpression), $(txIdExpression), $(sourceNodeExpression),                                                                                              \n                                            $(externalSelect),                                                                                                                                         \n                                            CURRENT_TIMESTAMP);                                                                                                                                        \n                                    END IF;                                                                                                                                                            \n                                    $(custom_on_insert_text)                                                                                                                                           \n                                END                                                                                                                                                                    ");
        this.sqlTemplates.put("updateTriggerTemplate", "CREATE TRIGGER $(schemaName)$(triggerName)                                                                                                                                                             \n                                AFTER UPDATE ON $(schemaName)$(tableName)                                                                                                                              \n                                REFERENCING OLD AS OLD NEW AS NEW                                                                                                                                      \n                                FOR EACH ROW MODE DB2SQL                                                                                                                                               \n                                BEGIN ATOMIC                                                                                                                                                           \n                                    DECLARE var_row_data VARCHAR(16336);                                                                                                                               \n                                    DECLARE var_old_data VARCHAR(16336);                                                                                                                               \n                                    $(custom_before_update_text) \n                                    IF $(syncOnUpdateCondition) and $(syncOnIncomingBatchCondition) then                                                                                               \n                                        SET var_row_data = $(oracleToClob)$(columns);                                                                                                                                 \n                                        SET var_old_data = $(oracleToClob)$(oldColumns);                                                                                                                              \n                                        IF $(dataHasChangedCondition) THEN                                                                                                                             \n                                            INSERT into $(defaultSchema)$(prefixName)_data                                                                                                             \n                                                (table_name, event_type, trigger_hist_id, pk_data, row_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time)         \n                                            VALUES('$(targetTableName)', 'U', $(triggerHistoryId),                                                                                                     \n                                                $(oracleToClob)$(oldKeys),                                                                                                                             \n                                                var_row_data,                                                                                                                                          \n                                                var_old_data,                                                                                                                                          \n                                                $(channelExpression),                                                                                                                                      \n                                                $(txIdExpression),                                                                                                                                     \n                                                $(sourceNodeExpression),                                                                                                                               \n                                                $(externalSelect),                                                                                                                                     \n                                                CURRENT_TIMESTAMP);                                                                                                                                    \n                                        END IF;                                                                                                                                                        \n                                    END IF;                                                                                                                                                            \n                                    $(custom_on_update_text)                                                                                                                                           \n                                END                                                                                                                                                                    ");
        this.sqlTemplates.put("updateReloadTriggerTemplate", "CREATE TRIGGER $(schemaName)$(triggerName)                                                                                                                                                             \n                                AFTER UPDATE ON $(schemaName)$(tableName)                                                                                                                              \n                                REFERENCING OLD AS OLD NEW AS NEW                                                                                                                                      \n                                FOR EACH ROW MODE DB2SQL                                                                                                                                               \n                                BEGIN ATOMIC                                                                                                                                                           \n                                    $(custom_before_update_text) \n                                    IF $(syncOnUpdateCondition) and $(syncOnIncomingBatchCondition) then                                                                                               \n                                            INSERT into $(defaultSchema)$(prefixName)_data                                                                                                             \n                                                (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id, source_node_id, external_data, create_time)         \n                                            VALUES('$(targetTableName)', 'R', $(triggerHistoryId),                                                                                                     \n                                                $(oracleToClob)$(newKeys),                                                                                                                             \n                                                $(channelExpression),                                                                                                                                      \n                                                $(txIdExpression),                                                                                                                                     \n                                                $(sourceNodeExpression),                                                                                                                               \n                                                $(externalSelect),                                                                                                                                     \n                                                CURRENT_TIMESTAMP);                                                                                                                                    \n                                    END IF;                                                                                                                                                            \n                                    $(custom_on_update_text)                                                                                                                                           \n                                END                                                                                                                                                                    ");
        this.sqlTemplates.put("deleteTriggerTemplate", "CREATE TRIGGER $(schemaName)$(triggerName)                                                                                                                                                             \n                                AFTER DELETE ON $(schemaName)$(tableName)                                                                                                                              \n                                REFERENCING OLD AS OLD                                                                                                                                                 \n                                FOR EACH ROW MODE DB2SQL                                                                                                                                               \n                                BEGIN ATOMIC                                                                                                                                                           \n                                    $(custom_before_delete_text) \n                                    IF $(syncOnDeleteCondition) and $(syncOnIncomingBatchCondition) then                                                                                               \n                                        INSERT into $(defaultSchema)$(prefixName)_data                                                                                                                 \n                                            (table_name, event_type, trigger_hist_id, pk_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time)                       \n                                        VALUES ('$(targetTableName)', 'D', $(triggerHistoryId),                                                                                                        \n                                            $(oracleToClob)$(oldKeys),                                                                                                                                 \n                                            $(oracleToClob)$(oldColumns),                                                                                                                              \n                                            $(channelExpression),                                                                                                                                          \n                                            $(txIdExpression),                                                                                                                                         \n                                            $(sourceNodeExpression),                                                                                                                                   \n                                            $(externalSelect),                                                                                                                                         \n                                            CURRENT_TIMESTAMP);                                                                                                                                        \n                                    END IF;                                                                                                                                                            \n                                    $(custom_on_delete_text)                                                                                                                                           \n                                END                                                                                                                                                                    ");
        this.sqlTemplates.put("initialLoadSqlTemplate", "select $(oracleToClob)$(columns) from $(schemaName)$(tableName) t where $(whereClause)                                                                                                                                ");
    }

    protected String toClobExpression(Table table) {
        if (table.hasNTypeColumns()) {
            return "nclob('')||";
        }
        return "clob('')||";
    }
}

