/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.db2;

import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.db2.Db2SymmetricDialect;
import org.jumpmind.symmetric.db.db2.Db2zOsTriggerTemplate;
import org.jumpmind.symmetric.service.IParameterService;

public class Db2zOsSymmetricDialect
extends Db2SymmetricDialect
implements ISymmetricDialect {
    public Db2zOsSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new Db2zOsTriggerTemplate(this);
    }

    @Override
    public void createRequiredDatabaseObjectsImpl(StringBuilder ddl) {
        block9: {
            String sql;
            block8: {
                try {
                    this.platform.getSqlTemplate().update("SET " + this.parameterService.getTablePrefix() + "_trigger_disabled = 1", new Object[0]);
                }
                catch (Exception e) {
                    sql = "CREATE VARIABLE " + this.parameterService.getTablePrefix() + "_trigger_disabled SMALLINT DEFAULT 0";
                    this.logSql(sql, ddl);
                    if (ddl != null) break block8;
                    try {
                        this.platform.getSqlTemplate().update(sql, new Object[0]);
                    }
                    catch (Exception ex) {
                        this.log.info("Unable to create a user defined global variable to provide loop back support trigger enabled/disabled.  Loopback support is only available in version 11 or higher.  This could also be a privilege issue.  At least one of the following is required.  The CREATEIN privilege on the schema, System DBADM authority,  SYSADM authority, SYSCTRL authority.", (Throwable)ex);
                    }
                }
            }
            try {
                this.platform.getSqlTemplate().update("SET " + this.parameterService.getTablePrefix() + "_source_node_id = 'null'", new Object[0]);
            }
            catch (Exception e) {
                sql = "CREATE VARIABLE " + this.parameterService.getTablePrefix() + "_source_node_id VARCHAR(50)";
                this.logSql(sql, ddl);
                if (ddl != null) break block9;
                try {
                    this.platform.getSqlTemplate().update(sql, new Object[0]);
                }
                catch (Exception ex) {
                    this.log.info("Unable to create a user defined global variable to provide loop back support for source node id.  Loopback support is only available in version 11 or higher.  This could also be a privilege issue.  At least one of the following is required.  The CREATEIN privilege on the schema, System DBADM authority,  SYSADM authority, SYSCTRL authority.", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        transaction.prepareAndExecute("set " + this.parameterService.getTablePrefix() + "_trigger_disabled = 1", new Object[0]);
        if (nodeId != null) {
            transaction.prepareAndExecute("set " + this.getSourceNodeExpression() + " = '" + nodeId + "'", new Object[0]);
        }
    }

    @Override
    public void enableSyncTriggers(ISqlTransaction transaction) {
        transaction.prepareAndExecute("set " + this.parameterService.getTablePrefix() + "_trigger_disabled = 0", new Object[0]);
        transaction.prepareAndExecute("set " + this.getSourceNodeExpression() + " = 'null'", new Object[0]);
    }

    @Override
    public String getSyncTriggersExpression() {
        return this.parameterService.getTablePrefix() + "_trigger_disabled = 0";
    }

    @Override
    public String getSourceNodeExpression() {
        return this.parameterService.getTablePrefix() + "_source_node_id";
    }
}

