/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.h2;

import java.util.HashMap;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.db.AbstractTriggerTemplate;
import org.jumpmind.symmetric.db.ISymmetricDialect;

public class H2TriggerTemplate
extends AbstractTriggerTemplate {
    public H2TriggerTemplate(ISymmetricDialect symmetricDialect) {
        super(symmetricDialect);
        this.emptyColumnTemplate = "''''";
        this.stringColumnTemplate = "case when $(tableAlias)\"$(columnName)\" is null then '''' else ''\"''||replace(replace($(tableAlias)\"$(columnName)\",''\\'',''\\\\''),''\"'',''\\\"'')||''\"'' end";
        this.numberColumnTemplate = "case when $(tableAlias)\"$(columnName)\" is null then '''' else ''\"''||cast($(tableAlias)\"$(columnName)\" as varchar(50))||''\"'' end";
        this.datetimeColumnTemplate = "case when $(tableAlias)\"$(columnName)\" is null then '''' else ''\"''||formatdatetime($(tableAlias)\"$(columnName)\", ''yyyy-MM-dd HH:mm:ss.SSS'')||''\"'' end";
        this.clobColumnTemplate = "case when $(tableAlias)\"$(columnName)\" is null then '''' else ''\"''||replace(replace($(tableAlias)\"$(columnName)\",''\\'',''\\\\''),''\"'',''\\\"'')||''\"'' end";
        this.blobColumnTemplate = "case when $(tableAlias)\"$(columnName)\" is null then '''' else ''\"''||replace(replace(sym_BASE64_ENCODE($(tableAlias)\"$(columnName)\"),''\\'',''\\\\''),''\"'',''\\\"'')||''\"'' end";
        this.booleanColumnTemplate = "case when $(tableAlias)\"$(columnName)\" is null then '''' when $(tableAlias)\"$(columnName)\" then ''\"1\"'' else ''\"0\"'' end";
        if (!Version.isOlderThanVersion((String)symmetricDialect.getProductVersion(), (String)"2.0.202")) {
            this.timeColumnTemplate = "case when $(tableAlias)\"$(columnName)\" is null then '''' else ''\"''||to_char($(tableAlias)\"$(columnName)\", ''HH:MI:SSXFF3'')||''\"'' end";
        }
        this.triggerConcatCharacter = "||";
        this.newTriggerValue = "";
        this.oldTriggerValue = "";
        this.oldColumnPrefix = "OLD_";
        this.newColumnPrefix = "NEW_";
        this.sqlTemplates = new HashMap();
        this.sqlTemplates.put("insertTriggerTemplate", "CREATE TABLE $(schemaName)$(triggerName)_CONFIG (CONDITION_SQL CLOB, INSERT_DATA_SQL CLOB);                                                                                                                                                         INSERT INTO $(schemaName)$(triggerName)_CONFIG values(                                                                                                                                                              'select count(*) from $(virtualOldNewTable) where $(syncOnInsertCondition) and $(syncOnIncomingBatchCondition)',                                                                                       'insert into $(defaultSchema)$(prefixName)_data (table_name, event_type, trigger_hist_id, row_data, channel_id, transaction_id, source_node_id, external_data, create_time)                                  (select ''$(targetTableName)'',''I'',$(triggerHistoryId),$(columns), $(channelExpression), $(txIdExpression), @node_value, $(externalSelect), CURRENT_TIMESTAMP from $(virtualOldNewTable))'                                 ); COMMIT;                                                                                                                                                                                                    CREATE TRIGGER $(schemaName)$(triggerName) AFTER INSERT ON $(schemaName)$(tableName) FOR EACH ROW CALL \"org.jumpmind.symmetric.db.h2.H2Trigger\";                                               ");
        this.sqlTemplates.put("insertReloadTriggerTemplate", "CREATE TABLE $(schemaName)$(triggerName)_CONFIG (CONDITION_SQL CLOB, INSERT_DATA_SQL CLOB);                                                                                                                                                         INSERT INTO $(schemaName)$(triggerName)_CONFIG values(                                                                                                                                                              'select count(*) from $(virtualOldNewTable) where $(syncOnInsertCondition) and $(syncOnIncomingBatchCondition)',                                                                                       'insert into $(defaultSchema)$(prefixName)_data (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id, source_node_id, external_data, create_time)                                  (select ''$(targetTableName)'',''R'',$(triggerHistoryId),$(newKeys), $(channelExpression), $(txIdExpression), @node_value, $(externalSelect), CURRENT_TIMESTAMP from $(virtualOldNewTable))'                                 ); COMMIT;                                                                                                                                                                                                    CREATE TRIGGER $(schemaName)$(triggerName) AFTER INSERT ON $(schemaName)$(tableName) FOR EACH ROW CALL \"org.jumpmind.symmetric.db.h2.H2Trigger\";                                               ");
        this.sqlTemplates.put("updateTriggerTemplate", "CREATE TABLE $(schemaName)$(triggerName)_CONFIG (CONDITION_SQL CLOB, INSERT_DATA_SQL CLOB);                                                                                                                                                         INSERT INTO $(schemaName)$(triggerName)_CONFIG values(                                                                                                                                                                'select count(*) from $(virtualOldNewTable) where $(syncOnUpdateCondition) and $(syncOnIncomingBatchCondition)',                                                                                       'insert into $(defaultSchema)$(prefixName)_data (table_name, event_type, trigger_hist_id, pk_data, row_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time)                                    (select ''$(targetTableName)'',''U'',$(triggerHistoryId),$(oldKeys),$(columns),$(oldColumns), $(channelExpression), $(txIdExpression), @node_value, $(externalSelect), CURRENT_TIMESTAMP from $(virtualOldNewTable))'                                ); COMMIT;                                                                                                                                                                                                    CREATE TRIGGER $(schemaName)$(triggerName) AFTER UPDATE ON $(schemaName)$(tableName) FOR EACH ROW CALL \"org.jumpmind.symmetric.db.h2.H2Trigger\";                                               ");
        this.sqlTemplates.put("updateReloadTriggerTemplate", "CREATE TABLE $(schemaName)$(triggerName)_CONFIG (CONDITION_SQL CLOB, INSERT_DATA_SQL CLOB);                                                                                                                                                         INSERT INTO $(schemaName)$(triggerName)_CONFIG values(                                                                                                                                                                'select count(*) from $(virtualOldNewTable) where $(syncOnUpdateCondition) and $(syncOnIncomingBatchCondition)',                                                                                       'insert into $(defaultSchema)$(prefixName)_data (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id, source_node_id, external_data, create_time)                                    (select ''$(targetTableName)'',''R'',$(triggerHistoryId),$(oldKeys), $(channelExpression), $(txIdExpression), @node_value, $(externalSelect), CURRENT_TIMESTAMP from $(virtualOldNewTable))'                                ); COMMIT;                                                                                                                                                                                                    CREATE TRIGGER $(schemaName)$(triggerName) AFTER UPDATE ON $(schemaName)$(tableName) FOR EACH ROW CALL \"org.jumpmind.symmetric.db.h2.H2Trigger\";                                               ");
        this.sqlTemplates.put("deleteTriggerTemplate", "CREATE TABLE $(schemaName)$(triggerName)_CONFIG (CONDITION_SQL CLOB, INSERT_DATA_SQL CLOB);                                                                                                                                                         INSERT INTO $(schemaName)$(triggerName)_CONFIG values(                                                                                                                                                                'select count(*) from $(virtualOldNewTable) where $(syncOnDeleteCondition) and $(syncOnIncomingBatchCondition)',                                                                                       'insert into $(defaultSchema)$(prefixName)_data (table_name, event_type, trigger_hist_id, pk_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time)                                    (select ''$(targetTableName)'',''D'',$(triggerHistoryId),$(oldKeys),$(oldColumns),$(channelExpression), $(txIdExpression), @node_value, $(externalSelect), CURRENT_TIMESTAMP from $(virtualOldNewTable))'                                ); COMMIT;                                                                                                                                                                                                    CREATE TRIGGER $(schemaName)$(triggerName) AFTER DELETE ON $(schemaName)$(tableName) FOR EACH ROW CALL \"org.jumpmind.symmetric.db.h2.H2Trigger\";                                               ");
        this.sqlTemplates.put("initialLoadSqlTemplate", "select $(columns) from $(schemaName)$(tableName) t where $(whereClause)                                                                                                                                ");
    }
}

