/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.mssql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.IConnectionCallback;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.symmetric.db.mssql.MsSql2008TriggerTemplate;
import org.jumpmind.symmetric.db.mssql.MsSqlSymmetricDialect;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IParameterService;

public class MsSql2008SymmetricDialect
extends MsSqlSymmetricDialect {
    public MsSql2008SymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new MsSql2008TriggerTemplate(this);
        this.supportsDdlTriggers = true;
    }

    @Override
    protected String getDbSpecificDataHasChangedCondition(Trigger trigger) {
        return "$(anyColumnChanged)";
    }

    public boolean doesDdlTriggerExist(final String catalogName, String schema, final String triggerName) {
        return (Boolean)((JdbcSqlTemplate)this.platform.getSqlTemplate()).execute((IConnectionCallback)new IConnectionCallback<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean execute(Connection con) throws SQLException {
                String previousCatalog = con.getCatalog();
                PreparedStatement stmt = con.prepareStatement("select count(*) from sys.triggers where name = ?");
                try {
                    if (catalogName != null) {
                        con.setCatalog(catalogName);
                    }
                    stmt.setString(1, triggerName);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        int count = rs.getInt(1);
                        Boolean bl = count > 0;
                        return bl;
                    }
                }
                finally {
                    if (catalogName != null) {
                        con.setCatalog(previousCatalog);
                    }
                    stmt.close();
                }
                return Boolean.FALSE;
            }
        });
    }
}

