/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.mssql;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.db.AbstractTriggerTemplate;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.util.FormatUtils;

public class MsSqlTriggerTemplate
extends AbstractTriggerTemplate {
    boolean castToNVARCHAR;
    String delimiter;

    public MsSqlTriggerTemplate(ISymmetricDialect symmetricDialect) {
        super(symmetricDialect);
        this.castToNVARCHAR = symmetricDialect.getParameterService().is("mssql.use.ntypes.for.sync");
        this.delimiter = symmetricDialect.getParameterService().getString("trigger.capture.ddl.delimiter", "$");
        String triggerExecuteAs = symmetricDialect.getParameterService().getString("mssql.trigger.execute.as", "self");
        String defaultCatalog = symmetricDialect.getParameterService().is("mssql.include.catalog.in.triggers", true) ? "$(defaultCatalog)" : "";
        this.emptyColumnTemplate = "''";
        this.stringColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' + replace(replace(convert(" + (this.castToNVARCHAR ? "n" : "") + "varchar($(columnSizeOrMax)),$(tableAlias).\"$(columnName)\") $(masterCollation),'\\','\\\\'),'\"','\\\"') + '\"' end";
        this.geometryColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' + replace(replace(convert(" + (this.castToNVARCHAR ? "n" : "") + "varchar(max),$(tableAlias).\"$(columnName)\".STAsText()) $(masterCollation),'\\','\\\\'),'\"','\\\"') + '\"' end";
        this.geographyColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' + replace(replace(convert(" + (this.castToNVARCHAR ? "n" : "") + "varchar(max),$(tableAlias).\"$(columnName)\".STAsText()) $(masterCollation),'\\','\\\\'),'\"','\\\"') + '\"' end";
        this.numberColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else ('\"' + convert(varchar(40), $(tableAlias).\"$(columnName)\",2) + '\"') end";
        this.datetimeColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else ('\"' + convert(varchar,$(tableAlias).\"$(columnName)\",121) + '\"') end";
        this.clobColumnTemplate = "case when $(origTableAlias).\"$(columnName)\" is null then '' else '\"' + replace(replace(cast($(origTableAlias).\"$(columnName)\" as " + (this.castToNVARCHAR ? "n" : "") + "varchar(max)),'\\','\\\\'),'\"','\\\"') + '\"' end";
        this.blobColumnTemplate = "case when $(origTableAlias).\"$(columnName)\" is null then '' else '\"' + replace(replace(" + defaultCatalog + "dbo.$(prefixName)_base64_encode(CONVERT(VARBINARY(max), $(origTableAlias).\"$(columnName)\")),'\\','\\\\'),'\"','\\\"') + '\"' end";
        this.binaryColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' + replace(replace(" + defaultCatalog + "dbo.$(prefixName)_base64_encode(CONVERT(VARBINARY(max), $(tableAlias).\"$(columnName)\")),'\\','\\\\'),'\"','\\\"') + '\"' end";
        this.booleanColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' when $(tableAlias).\"$(columnName)\" = 1 then '\"1\"' else '\"0\"' end";
        this.dateTimeWithTimeZoneColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else ('\"' + convert(varchar,cast($(tableAlias).\"$(columnName)\" as datetime2), 121) + ' ' + case when datepart(tz, $(tableAlias).\"$(columnName)\") > 0 then '+' else '-' end + RIGHT('0' + cast(abs(datepart(tz, $(tableAlias).\"$(columnName)\") / 60) as varchar), 2) + ':' +  RIGHT('0' + cast(datepart(tz, $(tableAlias).\"$(columnName)\") % 60 as varchar), 2) + '\"') end";
        this.triggerConcatCharacter = "+";
        this.newTriggerValue = "inserted";
        this.oldTriggerValue = "deleted";
        this.oldColumnPrefix = "";
        this.newColumnPrefix = "";
        this.sqlTemplates = new HashMap();
        this.sqlTemplates.put("insertTriggerTemplate", this.getCreateTriggerString() + " $(schemaNameOnly)$(triggerName) on $(schemaName)$(tableName) with execute as " + triggerExecuteAs + " after insert as                                                                                                \n   begin                                                                                                                                                                  \n     declare @NCT int \n     set @NCT = @@OPTIONS & 512 \n     set nocount on                                                                                                                                                       \n     declare @TransactionId varchar(1000)                                                                                                                                 \n     if (@@TRANCOUNT > 0) begin                                                                                                                                           \n       select @TransactionId = convert(VARCHAR(1000),transaction_id) from sys.dm_exec_requests where session_id=@@SPID and open_transaction_count > 0                     \n     end                                                                                                                                                                  \n     $(custom_before_insert_text) \n     if ($(syncOnIncomingBatchCondition)) begin                                                                                                                           \n         insert into  " + defaultCatalog + "$(defaultSchema)$(prefixName)_data \n           (table_name, event_type, trigger_hist_id, row_data, channel_id, transaction_id, source_node_id, external_data, create_time) \n          select '$(targetTableName)','I', $(triggerHistoryId), $(oracleToClob)$(columns), \n                  $(channelExpression), $(txIdExpression),  " + defaultCatalog + "dbo.$(prefixName)_node_disabled(), $(externalSelect), " + this.getCreateTimeExpression() + " \n       $(if:containsBlobClobColumns)                                                                                                                                      \n          from inserted inner join $(schemaName)$(tableName) $(origTableAlias) on $(tableNewPrimaryKeyJoin) \n       $(else:containsBlobClobColumns)                                                                                                                                    \n          from inserted                                                                                   \n       $(end:containsBlobClobColumns)                                                                                                                                     \n          where $(syncOnInsertCondition)               \n     end                                                                                                                                                                  \n     $(custom_on_insert_text)                                                                                                                                             \n     if (@NCT = 0) set nocount off                                                                                                                                        \n   end                                                                                                                                                                    \n---- go");
        this.sqlTemplates.put("insertReloadTriggerTemplate", this.getCreateTriggerString() + " $(schemaNameOnly)$(triggerName) on $(schemaName)$(tableName) with execute as " + triggerExecuteAs + " after insert as                                                                                                \n   begin                                                                                                                                                                  \n     declare @NCT int \n     set @NCT = @@OPTIONS & 512 \n     set nocount on                                                                                                                                                       \n     declare @TransactionId varchar(1000)                                                                                                                                 \n     if (@@TRANCOUNT > 0) begin                                                                                                                                           \n       select @TransactionId = convert(VARCHAR(1000),transaction_id) from sys.dm_exec_requests where session_id=@@SPID and open_transaction_count > 0                     \n     end                                                                                                                                                                  \n     $(custom_before_insert_text) \n     if ($(syncOnIncomingBatchCondition)) begin                                                                                                                           \n         insert into  " + defaultCatalog + "$(defaultSchema)$(prefixName)_data \n           (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id, source_node_id, external_data, create_time) \n          select '$(targetTableName)','R', $(triggerHistoryId), $(oracleToClob)$(newKeys), \n                  $(channelExpression), $(txIdExpression),  " + defaultCatalog + "dbo.$(prefixName)_node_disabled(), $(externalSelect), " + this.getCreateTimeExpression() + " \n       $(if:containsBlobClobColumns)                                                                                                                                      \n          from inserted inner join $(schemaName)$(tableName) $(origTableAlias) on $(tableNewPrimaryKeyJoin) \n       $(else:containsBlobClobColumns)                                                                                                                                    \n          from inserted                                                                                   \n       $(end:containsBlobClobColumns)                                                                                                                                     \n          where $(syncOnInsertCondition)               \n     end                                                                                                                                                                  \n     $(custom_on_insert_text)                                                                                                                                             \n     if (@NCT = 0) set nocount off                                                                                                                                        \n   end                                                                                                                                                                    \n---- go");
        IParameterService parameterService = symmetricDialect.getParameterService();
        if (parameterService.is("trigger.use.insert.delete.for.primary.key.changes", true)) {
            this.sqlTemplates.put("updateTriggerTemplate", this.getCreateTriggerString() + " $(schemaNameOnly)$(triggerName) on $(schemaName)$(tableName)                                                     \n       with execute as " + triggerExecuteAs + " after update as                                                    \nbegin                                                                                                          \n  declare @LOCALROWCOUNT int                                                                                   \n  declare @LOCALPKCHANGED int                                                                                  \n  set @LOCALROWCOUNT=@@ROWCOUNT                                                                                \n  set @LOCALPKCHANGED = 0                                                                                      \n  if ($(hasPrimaryKeysDefined))                                                                                \n  begin                                                                                                        \n    select @LOCALPKCHANGED = count(*) from inserted, deleted where $(oldNewPrimaryKeyJoin)                     \n  end                                                                                                          \n  declare @NCT int                                                                                             \n  set @NCT = @@OPTIONS & 512                                                                                   \n  set nocount on                                                                                               \n  declare @TransactionId varchar(1000)                                                                         \n  if (@@TRANCOUNT > 0)                                                                                         \n  begin                                                                                                        \n    select @TransactionId = convert(VARCHAR(1000),transaction_id)                                              \n    from sys.dm_exec_requests                                                                                  \n    where session_id=@@SPID and open_transaction_count > 0                                                     \n  end                                                                                                          \n  $(custom_before_update_text)                                                                                 \n  if ($(syncOnIncomingBatchCondition))                                                                         \n  begin                                                                                                        \n    if ($(hasPrimaryKeysDefined) $(primaryKeysUpdated) AND @LOCALROWCOUNT <> @LOCALPKCHANGED)                  \n    begin                                                                                                      \n      if (@LOCALROWCOUNT = 1)                                                                                  \n      begin                                                                                                    \n         insert into  " + defaultCatalog + "$(defaultSchema)$(prefixName)_data                                 \n            (table_name, event_type, trigger_hist_id, row_data, pk_data, old_data, channel_id,                 \n             transaction_id, source_node_id,                                                                   \n             external_data, create_time)                                                                       \n          select '$(targetTableName)','U', $(triggerHistoryId), $(oracleToClob)$(columns), $(oracleToClob)$(oldKeys), $(oracleToClob)$(oldColumns),         \n                   $(channelExpression),                                                                       \n               $(txIdExpression),  " + defaultCatalog + "dbo.$(prefixName)_node_disabled(), $(externalSelect), \n                " + this.getCreateTimeExpression() + "                                                              \n       $(if:containsBlobClobColumns)                                                                           \n          from inserted                                                                                        \n          inner join $(schemaName)$(tableName) $(origTableAlias) on $(tableNewPrimaryKeyJoin)                  \n          inner join deleted on 1=1                                                                            \n       $(else:containsBlobClobColumns)                                                                         \n          from inserted                                                                                        \n          inner join deleted on 1=1                                                                            \n       $(end:containsBlobClobColumns)                                                                          \n          where $(syncOnUpdateCondition) and ($(dataHasChangedCondition))                                      \n      end                                                                                                      \n      else                                                                                                     \n      begin                                                                                                    \n        insert into  " + defaultCatalog + "$(defaultSchema)$(prefixName)_data                                  \n           (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id,                      \n            source_node_id, external_data, create_time)                                                        \n          select '$(targetTableName)','D', $(triggerHistoryId), $(oracleToClob)$(oldKeys),                                    \n            $(specialSqlServerSybaseChannelExpression), $(txIdExpression),                                     \n" + defaultCatalog + "dbo.$(prefixName)_node_disabled(),                                               \n            $(externalSelectForDelete), " + this.getCreateTimeExpression() + "                                               \n          from deleted                                                                                         \n          where $(syncOnDeleteCondition)                                                                       \n        insert into  " + defaultCatalog + "$(defaultSchema)$(prefixName)_data                                  \n           (table_name, event_type, trigger_hist_id, row_data, channel_id, transaction_id,                     \n            source_node_id, external_data, create_time)                                                        \n          select '$(targetTableName)','I', $(triggerHistoryId), $(oracleToClob)$(columns),                                    \n            $(channelExpression), $(txIdExpression),                                                            \n" + defaultCatalog + "dbo.$(prefixName)_node_disabled(),                                                \n           $(externalSelectForInsert), " + this.getCreateTimeExpression() + "                                                \n       $(if:containsBlobClobColumns)                                                                           \n          from inserted                                                                                        \n          inner join $(schemaName)$(tableName) $(origTableAlias) on $(tableNewPrimaryKeyJoin)                  \n       $(else:containsBlobClobColumns)                                                                         \n          from inserted                                                                                        \n       $(end:containsBlobClobColumns)                                                                          \n          where $(syncOnInsertCondition)                                                                       \n      end                                                                                                      \n    end                                                                                                        \n    else                                                                                                       \n    begin                                                                                                      \n         insert into  " + defaultCatalog + "$(defaultSchema)$(prefixName)_data                                 \n            (table_name, event_type, trigger_hist_id, row_data, pk_data, old_data, channel_id,                 \n             transaction_id, source_node_id,                                                                   \n             external_data, create_time)                                                                       \n          select '$(targetTableName)','U', $(triggerHistoryId), $(oracleToClob)$(columns), $(oracleToClob)$(oldKeys), $(oracleToClob)$(oldColumns),         \n                   $(channelExpression),                                                                       \n               $(txIdExpression),  " + defaultCatalog + "dbo.$(prefixName)_node_disabled(), $(externalSelect), \n                " + this.getCreateTimeExpression() + "                                                              \n       $(if:containsBlobClobColumns)                                                                           \n          from inserted                                                                                        \n          inner join $(schemaName)$(tableName) $(origTableAlias) on $(tableNewPrimaryKeyJoin)                  \n          inner join deleted on $(oldNewPrimaryKeyJoin)                                                        \n       $(else:containsBlobClobColumns)                                                                         \n          from inserted                                                                                        \n          inner join deleted on $(oldNewPrimaryKeyJoin)                                                        \n       $(end:containsBlobClobColumns)                                                                          \n          where $(syncOnUpdateCondition) and ($(dataHasChangedCondition))                                      \n    end                                                                                                        \n  end                                                                                                          \n  $(custom_on_update_text)                                                                                     \n  if (@NCT = 0) set nocount off                                                                                \nend                                                                                                            \n---- go");
            this.sqlTemplates.put("updateReloadTriggerTemplate", this.getCreateTriggerString() + " $(schemaNameOnly)$(triggerName) on $(schemaName)$(tableName)                                                     \n       with execute as " + triggerExecuteAs + " after update as                                                    \nbegin                                                                                                          \n  declare @LOCALROWCOUNT int                                                                                   \n  set @LOCALROWCOUNT=@@ROWCOUNT                                                                                \n  declare @LOCALPKCHANGED int                                                                                  \n  set @LOCALPKCHANGED = 0                                                                                      \n  if ($(hasPrimaryKeysDefined))                                                                                \n  begin                                                                                                        \n    select @LOCALPKCHANGED = count(*) from inserted, deleted where $(oldNewPrimaryKeyJoin)                     \n  end                                                                                                          \n  declare @NCT int                                                                                             \n  set @NCT = @@OPTIONS & 512                                                                                   \n  set nocount on                                                                                               \n  declare @TransactionId varchar(1000)                                                                         \n  if (@@TRANCOUNT > 0)                                                                                         \n  begin                                                                                                        \n    select @TransactionId = convert(VARCHAR(1000),transaction_id)                                              \n    from sys.dm_exec_requests                                                                                  \n    where session_id=@@SPID and open_transaction_count > 0                                                     \n  end                                                                                                          \n  $(custom_before_update_text)                                                                                 \n  if ($(syncOnIncomingBatchCondition))                                                                         \n  begin                                                                                                        \n    if ($(hasPrimaryKeysDefined) $(primaryKeysUpdated) AND @LOCALROWCOUNT <> @LOCALPKCHANGED )                                                       \n    begin                                                                                                      \n      if (@LOCALROWCOUNT = 1)                                                                                  \n      begin                                                                                                    \n         insert into  " + defaultCatalog + "$(defaultSchema)$(prefixName)_data                                 \n            (table_name, event_type, trigger_hist_id, row_data, pk_data, old_data, channel_id,                 \n             transaction_id, source_node_id,                                                                   \n             external_data, create_time)                                                                       \n          select '$(targetTableName)','U', $(triggerHistoryId), $(oracleToClob)$(columns), $(oracleToClob)$(oldKeys), $(oracleToClob)$(oldColumns),         \n                   $(channelExpression),                                                                       \n               $(txIdExpression),  " + defaultCatalog + "dbo.$(prefixName)_node_disabled(), $(externalSelect), \n                " + this.getCreateTimeExpression() + "                                                              \n       $(if:containsBlobClobColumns)                                                                           \n          from inserted                                                                                        \n          inner join $(schemaName)$(tableName) $(origTableAlias) on $(tableNewPrimaryKeyJoin)                  \n          inner join deleted on 1=1                                                                            \n       $(else:containsBlobClobColumns)                                                                         \n          from inserted                                                                                        \n          inner join deleted on 1=1                                                                            \n       $(end:containsBlobClobColumns)                                                                          \n          where $(syncOnUpdateCondition) and ($(dataHasChangedCondition))                                      \n      end                                                                                                      \n      else                                                                                                     \n      begin                                                                                                    \n        insert into  " + defaultCatalog + "$(defaultSchema)$(prefixName)_data                                  \n           (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id,                      \n            source_node_id, external_data, create_time)                                                        \n          select '$(targetTableName)','D', $(triggerHistoryId), $(oracleToClob)$(oldKeys),                                    \n              $(specialSqlServerSybaseChannelExpression),                                                      \n              $(txIdExpression),  " + defaultCatalog + "dbo.$(prefixName)_node_disabled(),                     \n              $(externalSelectForDelete), " + this.getCreateTimeExpression() + "                                             \n          from deleted                                                                                         \n          where $(syncOnDeleteCondition)                                                                       \n        insert into  " + defaultCatalog + "$(defaultSchema)$(prefixName)_data                                  \n           (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id,                      \n            source_node_id, external_data, create_time)                                                        \n          select '$(targetTableName)','R', $(triggerHistoryId), $(oracleToClob)$(newKeys),                                    \n                  $(channelExpression), $(txIdExpression),                                                     \n" + defaultCatalog + "dbo.$(prefixName)_node_disabled(),                                         \n                  $(externalSelectForInsert), " + this.getCreateTimeExpression() + "                                         \n       $(if:containsBlobClobColumns)                                                                           \n          from inserted                                                                                        \n          inner join $(schemaName)$(tableName) $(origTableAlias) on $(tableNewPrimaryKeyJoin)                  \n       $(else:containsBlobClobColumns)                                                                         \n          from inserted                                                                                        \n       $(end:containsBlobClobColumns)                                                                          \n          where $(syncOnInsertCondition)                                                                       \n      end                                                                                                      \n    end                                                                                                        \n    else                                                                                                       \n    begin                                                                                                      \n         insert into  " + defaultCatalog + "$(defaultSchema)$(prefixName)_data                                 \n            (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id,                     \n             source_node_id, external_data, create_time)                                                       \n           select '$(targetTableName)','R', $(triggerHistoryId), $(oracleToClob)$(oldKeys), $(channelExpression),             \n               $(txIdExpression),  " + defaultCatalog + "dbo.$(prefixName)_node_disabled(),                    \n               $(externalSelect), " + this.getCreateTimeExpression() + "                                            \n       $(if:containsBlobClobColumns)                                                                           \n           from inserted                                                                                       \n           inner join $(schemaName)$(tableName) $(origTableAlias) on $(tableNewPrimaryKeyJoin)                 \n           inner join deleted on $(oldNewPrimaryKeyJoin)                                                       \n       $(else:containsBlobClobColumns)                                                                         \n           from inserted                                                                                       \n           inner join deleted on $(oldNewPrimaryKeyJoin)                                                       \n       $(end:containsBlobClobColumns)                                                                          \n          where $(syncOnUpdateCondition) and ($(dataHasChangedCondition))                                      \n    end                                                                                                        \n  end                                                                                                          \n  $(custom_on_update_text)                                                                                     \n  if (@NCT = 0) set nocount off                                                                                \nend                                                                                                            \n---- go");
        } else {
            this.sqlTemplates.put("updateTriggerTemplate", this.getCreateTriggerString() + " $(schemaNameOnly)$(triggerName) on $(schemaName)$(tableName) with execute as " + triggerExecuteAs + " after update as                                                                                                                             \n   begin                                                                                                                                                                  \n     declare @NCT int \n     set @NCT = @@OPTIONS & 512 \n     set nocount on                                                                                                                                                       \n     declare @TransactionId varchar(1000)                                                                                                                                 \n                                                                                                                                                                          \n     if (@@TRANCOUNT > 0) begin                                                                                                                                           \n       select @TransactionId = convert(VARCHAR(1000),transaction_id) from sys.dm_exec_requests where session_id=@@SPID and open_transaction_count > 0                                            \n     end                                                                                                                                                                  \n     $(custom_before_update_text) \n     if ($(syncOnIncomingBatchCondition)) begin                                                                                                                           \n         insert into  " + defaultCatalog + "$(defaultSchema)$(prefixName)_data (table_name, event_type, trigger_hist_id, row_data, pk_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time) \n             select '$(targetTableName)','U', $(triggerHistoryId), $(columns), $(oldKeys), $(oldColumns), $(channelExpression),                $(txIdExpression),  " + defaultCatalog + "dbo.$(prefixName)_node_disabled(), $(externalSelect), current_timestamp\n       $(if:containsBlobClobColumns)                                                                                                                                      \n          from (select $(nonBlobColumns), row_number() over (order by (select 1)) as __row_num from inserted) inserted inner join $(schemaName)$(tableName) $(origTableAlias) on $(tableNewPrimaryKeyJoin) inner join (select $(nonBlobColumns), row_number() over (order by (select 1)) as __row_num from deleted)deleted on (inserted.__row_num = deleted.__row_num)\n       $(else:containsBlobClobColumns)                                                                                                                                    \n          from (select *, row_number() over (order by (select 1)) as __row_num from inserted) inserted inner join (select *, row_number() over (order by (select 1)) as __row_num from deleted) deleted on (inserted.__row_num = deleted.__row_num)                                    \n       $(end:containsBlobClobColumns)                                                                                                                                     \n          where $(syncOnUpdateCondition) and ($(dataHasChangedCondition))                                                                     \n       end                                                                                                                                                                \n       $(custom_on_update_text)                                                                                                                                             \n     if (@NCT = 0) set nocount off                                                                                                                                        \n   end                                                                                                                                                                    \n---- go");
            this.sqlTemplates.put("updateReloadTriggerTemplate", this.getCreateTriggerString() + " $(schemaNameOnly)$(triggerName) on $(schemaName)$(tableName) with execute as " + triggerExecuteAs + " after update as                                                                                                \n   begin                                                                                                                                                                  \n     declare @NCT int \n     set @NCT = @@OPTIONS & 512 \n     set nocount on                                                                                                                                                       \n     declare @TransactionId varchar(1000)                                                                                                                                 \n     if (@@TRANCOUNT > 0) begin                                                                                                                                           \n       select @TransactionId = convert(VARCHAR(1000),transaction_id) from sys.dm_exec_requests where session_id=@@SPID and open_transaction_count > 0                     \n     end                                                                                                                                                                  \n     $(custom_before_update_text) \n     if ($(syncOnIncomingBatchCondition)) begin                                                                                                                           \n         insert into  " + defaultCatalog + "$(defaultSchema)$(prefixName)_data (table_name, event_type, trigger_hist_id, pk_data, channel_id, transaction_id, source_node_id, external_data, create_time) \n             select '$(targetTableName)','R', $(triggerHistoryId), $(oldKeys), $(channelExpression),                $(txIdExpression),  " + defaultCatalog + "dbo.$(prefixName)_node_disabled(), $(externalSelect), current_timestamp\n       $(if:containsBlobClobColumns)                                                                                                                                      \n          from inserted inner join $(schemaName)$(tableName) $(origTableAlias) on $(tableNewPrimaryKeyJoin) inner join deleted on $(oldNewPrimaryKeyJoin) \n       $(else:containsBlobClobColumns)                                                                                                                                    \n          from inserted inner join deleted on $(oldNewPrimaryKeyJoin)                                   \n       $(end:containsBlobClobColumns)                                                                                                                                     \n          where $(syncOnUpdateCondition) and ($(dataHasChangedCondition))                                                    \n       end                                                                                                                                                                \n       $(custom_on_update_text)                                                                                                                                             \n     if (@NCT = 0) set nocount off                                                                                                                                        \n   end                                                                                                                                                                    \n---- go");
        }
        this.sqlTemplates.put("deleteTriggerTemplate", this.getCreateTriggerString() + " $(schemaNameOnly)$(triggerName) on $(schemaName)$(tableName) with execute as " + triggerExecuteAs + " after delete as                                                                                                                             \n  begin                                                                                                                                                                  \n    declare @NCT int \n    set @NCT = @@OPTIONS & 512 \n    set nocount on                                                                                                                                                       \n    declare @TransactionId varchar(1000)                                                                                                                                 \n    if (@@TRANCOUNT > 0) begin                                                                                                                                           \n       select @TransactionId = convert(VARCHAR(1000),transaction_id)    from sys.dm_exec_requests where session_id=@@SPID and open_transaction_count > 0                                           \n    end                                                                                                                                                                  \n    $(custom_before_delete_text) \n    if ($(syncOnIncomingBatchCondition)) begin                                                                                                                           \n        insert into  " + defaultCatalog + "$(defaultSchema)$(prefixName)_data (table_name, event_type, trigger_hist_id, pk_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time) \n        select '$(targetTableName)','D', $(triggerHistoryId), $(oracleToClob)$(oldKeys), $(oracleToClob)$(oldColumns), $(channelExpression), \n              $(txIdExpression),  " + defaultCatalog + "dbo.$(prefixName)_node_disabled(), $(externalSelect), " + this.getCreateTimeExpression() + "\n        from deleted where $(syncOnDeleteCondition)                                                                      \n    end                                                                                                                                                                  \n    $(custom_on_delete_text)                                                                                                                                              \n    if (@NCT = 0) set nocount off                                                                                                                                         \n   end                                                                                                                                                                    \n---- go");
        this.sqlTemplates.put("filteredDdlTriggerTemplate", this.getCreateTriggerString() + " $(triggerName) on database\nfor create_table, drop_table, alter_table, rename,\ncreate_view, drop_view, alter_view,\ncreate_function, drop_function, alter_function,\ncreate_procedure, drop_procedure, alter_procedure,\ncreate_trigger, drop_trigger, alter_trigger,\ncreate_type, drop_type, \ncreate_schema, drop_schema, \ncreate_index, drop_index, alter_index as\ndeclare @data xml\ndeclare @eventType nvarchar(128)\ndeclare @tableName nvarchar(255)\ndeclare @histId int\ndeclare @channelId nvarchar(128)\nset @data = eventdata()\nif (@data.value('(/EVENT_INSTANCE/ObjectName)[1]', 'nvarchar(128)') not like '$(prefixName)%') begin\n  set @eventType = @data.value('(/EVENT_INSTANCE/EventType)[1]', 'nvarchar(128)')\n  set @tableName = '$(prefixName)_node'\n  if (@eventType like '%_TABLE')\n    set @tableName = @data.value('(/EVENT_INSTANCE/ObjectName)[1]', 'nvarchar(128)')\n  if (@eventType like '%_TRIGGER' or @eventType like '%_INDEX')\n    set @tableName = @data.value('(/EVENT_INSTANCE/TargetObjectName)[1]', 'nvarchar(128)')\n  select @histId = max(trigger_hist_id) from " + defaultCatalog + "$(defaultSchema)$(prefixName)_trigger_hist where source_table_name = @tableName and inactive_time is null\n  if (@histId is not null) begin\n    select @channelId = channel_id from " + defaultCatalog + "$(defaultSchema)$(prefixName)_trigger where source_table_name = @tableName\n    if (@channelId is null)\n      set @channelId = 'config'\n    insert into " + defaultCatalog + "$(defaultSchema)$(prefixName)_data\n    (table_name, event_type, trigger_hist_id, row_data, channel_id, source_node_id, create_time)\n    values (@tableName, '" + DataEventType.SQL.getCode() + "', @histId,\n    '\"delimiter " + this.delimiter + ";' + CHAR(13) + char(10) + replace(replace(@data.value('(/EVENT_INSTANCE/TSQLCommand/CommandText)[1]', 'nvarchar(max)'),'\\','\\\\'),'\"','\\\"') + '\",ddl',\n    @channelId, " + defaultCatalog + "$(defaultSchema)$(prefixName)_node_disabled(), " + this.getCreateTimeExpression() + ")\n  end\nend\n---- go");
        this.sqlTemplates.put("allDdlTriggerTemplate", this.getCreateTriggerString() + " $(triggerName) on database\nfor create_table, drop_table, alter_table,rename,\ncreate_view, drop_view, alter_view,\ncreate_function, drop_function, alter_function,\ncreate_procedure, drop_procedure, alter_procedure,\ncreate_trigger, drop_trigger, alter_trigger,\ncreate_type, drop_type, \ncreate_schema, drop_schema, \ncreate_index, drop_index, alter_index as\ndeclare @data xml\ndeclare @eventType nvarchar(128)\ndeclare @tableName nvarchar(255)\ndeclare @histId int\ndeclare @channelId nvarchar(128)\nset @data = eventdata()\nif (@data.value('(/EVENT_INSTANCE/ObjectName)[1]', 'nvarchar(128)') not like '$(prefixName)%') begin\n  set @eventType = @data.value('(/EVENT_INSTANCE/EventType)[1]', 'nvarchar(128)')\n  if (@eventType like '%_TABLE')\n    set @tableName = @data.value('(/EVENT_INSTANCE/ObjectName)[1]', 'nvarchar(128)')\n  if (@eventType like '%_TRIGGER' or @eventType like '%_INDEX')\n    set @tableName = @data.value('(/EVENT_INSTANCE/TargetObjectName)[1]', 'nvarchar(128)')\n  if (@tableName is not null)\n    select @histId = max(trigger_hist_id) from " + defaultCatalog + "$(defaultSchema)$(prefixName)_trigger_hist where source_table_name = @tableName and inactive_time is null\n  if (@histId is null)\n    set @tableName = '$(prefixName)_node';\n    select @histId = max(trigger_hist_id) from " + defaultCatalog + "$(defaultSchema)$(prefixName)_trigger_hist where source_table_name = @tableName and inactive_time is null\n  select @channelId = channel_id from " + defaultCatalog + "$(defaultSchema)$(prefixName)_trigger where source_table_name = @tableName\n  if (@channelId is null)\n    set @channelId = 'config'\n  insert into " + defaultCatalog + "$(defaultSchema)$(prefixName)_data\n  (table_name, event_type, trigger_hist_id, row_data, channel_id, source_node_id, create_time)\n  values (@tableName, '" + DataEventType.SQL.getCode() + "', @histId,\n  '\"delimiter " + this.delimiter + ";' + CHAR(13) + char(10) + replace(replace(@data.value('(/EVENT_INSTANCE/TSQLCommand/CommandText)[1]', 'nvarchar(max)'),'\\','\\\\'),'\"','\\\"') + '\",ddl',\n  @channelId, " + defaultCatalog + "$(defaultSchema)$(prefixName)_node_disabled(), " + this.getCreateTimeExpression() + ")\nend\n---- go");
        this.sqlTemplates.put("initialLoadSqlTemplate", "select $(columns) from $(schemaName)$(tableName) t where $(whereClause) ");
    }

    protected String replaceTemplateVariables(DataEventType dml, Trigger trigger, TriggerHistory history, Channel channel, String tablePrefix, Table originalTable, Table table, String defaultCatalog, String defaultSchema, String ddl) {
        ddl = super.replaceTemplateVariables(dml, trigger, history, channel, tablePrefix, originalTable, table, defaultCatalog, defaultSchema, ddl);
        ddl = FormatUtils.replace((String)"anyNonBlobColumnChanged", (String)this.buildNonLobColumnsAreNotEqualString(table, this.newTriggerValue, this.oldTriggerValue), (String)ddl);
        ddl = FormatUtils.replace((String)"nonBlobColumns", (String)this.buildNonLobColumnsString(table), (String)ddl);
        return ddl;
    }

    protected boolean isNotComparable(Column column) {
        String columnType = column.getJdbcTypeName();
        return StringUtils.equalsIgnoreCase((CharSequence)columnType, (CharSequence)"IMAGE") || StringUtils.equalsIgnoreCase((CharSequence)columnType, (CharSequence)"TEXT") || StringUtils.equalsIgnoreCase((CharSequence)columnType, (CharSequence)"NTEXT");
    }

    private String buildNonLobColumnsAreNotEqualString(Table table, String table1Name, String table2Name) {
        StringBuilder builder = new StringBuilder();
        for (Column column : table.getColumns()) {
            if (this.isNotComparable(column)) continue;
            if (builder.length() > 0) {
                builder.append(" or ");
            }
            builder.append(String.format("((%1$s.\"%2$s\" IS NOT NULL AND %3$s.\"%2$s\" IS NOT NULL AND %1$s.\"%2$s\"<>%3$s.\"%2$s\") or (%1$s.\"%2$s\" IS NULL AND %3$s.\"%2$s\" IS NOT NULL) or (%1$s.\"%2$s\" IS NOT NULL AND %3$s.\"%2$s\" IS NULL))", table1Name, column.getName(), table2Name));
        }
        if (builder.length() == 0) {
            builder.append("1=1");
        }
        return builder.toString();
    }

    private String buildNonLobColumnsString(Table table) {
        StringBuilder builder = new StringBuilder();
        for (Column column : table.getColumns()) {
            if (this.isNotComparable(column)) continue;
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append('\"');
            builder.append(column.getName());
            builder.append('\"');
        }
        return builder.toString();
    }

    protected String getSourceTablePrefix(TriggerHistory triggerHistory) {
        Object prefix = StringUtils.isNotBlank((CharSequence)triggerHistory.getSourceSchemaName()) ? SymmetricUtils.quote((ISymmetricDialect)this.symmetricDialect, (String)triggerHistory.getSourceSchemaName()) + this.symmetricDialect.getPlatform().getDatabaseInfo().getSchemaSeparator() : "";
        prefix = (String)(StringUtils.isNotBlank((CharSequence)triggerHistory.getSourceCatalogName()) ? SymmetricUtils.quote((ISymmetricDialect)this.symmetricDialect, (String)triggerHistory.getSourceCatalogName()) + this.symmetricDialect.getPlatform().getDatabaseInfo().getCatalogSeparator() : "") + (String)prefix;
        if (StringUtils.isBlank((CharSequence)prefix)) {
            Object object = prefix = StringUtils.isNotBlank((CharSequence)this.symmetricDialect.getPlatform().getDefaultSchema()) ? SymmetricUtils.quote((ISymmetricDialect)this.symmetricDialect, (String)this.symmetricDialect.getPlatform().getDefaultSchema()) + "." : "";
            if (this.symmetricDialect.getParameterService().is("mssql.include.catalog.in.triggers", true)) {
                prefix = (String)(StringUtils.isNotBlank((CharSequence)this.symmetricDialect.getPlatform().getDefaultCatalog()) ? SymmetricUtils.quote((ISymmetricDialect)this.symmetricDialect, (String)this.symmetricDialect.getPlatform().getDefaultCatalog()) + "." : "") + (String)prefix;
            }
        }
        return prefix;
    }

    protected String getCreateTimeExpression() {
        return "current_timestamp";
    }

    protected String getColumnSize(Table table, Column column) {
        int totalSize = 0;
        for (Column c : table.getColumns()) {
            totalSize += c.getSizeAsInt();
        }
        if (this.castToNVARCHAR && totalSize > 8000) {
            return "max";
        }
        if (this.castToNVARCHAR && column.getSizeAsInt() > 4000) {
            return "max";
        }
        return column.getSize();
    }

    protected boolean useTriggerTemplateForColumnTemplatesDuringInitialLoad(Column column) {
        int type;
        boolean result = super.useTriggerTemplateForColumnTemplatesDuringInitialLoad(column);
        if (column != null && ((type = column.getJdbcTypeCode()) == 3 || type == 6 || type == 8)) {
            result = true;
        }
        return result;
    }

    protected boolean requiresEmptyLobTemplateForDeletes() {
        return true;
    }

    protected String toClobExpression(Table table) {
        if (this.castToNVARCHAR) {
            return "cast(N'' as nvarchar(max)) +";
        }
        return "cast('' as varchar(max)) +";
    }
}

