/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import bsh.Interpreter;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.job.AbstractJob;
import org.jumpmind.symmetric.job.JobDefaults;
import org.jumpmind.symmetric.model.JobDefinition;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class BshJob
extends AbstractJob {
    public BshJob(String jobName, ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        super(jobName, engine, taskScheduler);
    }

    public JobDefinition.JobType getJobType() {
        return JobDefinition.JobType.BSH;
    }

    @Override
    public void doJob(boolean force) throws Exception {
        try {
            Interpreter interpreter = new Interpreter();
            interpreter.set("engine", (Object)this.engine);
            interpreter.set("sqlTemplate", (Object)this.engine.getDatabasePlatform().getSqlTemplate());
            interpreter.set("log", (Object)this.log);
            if (this.getJobDefinition().getJobExpression() != null) {
                interpreter.eval(this.getJobDefinition().getJobExpression());
            }
        }
        catch (Exception ex) {
            this.log.error("Exception during bsh job '" + this.getName() + "'\n" + this.getJobDefinition().getJobExpression(), (Throwable)ex);
        }
    }

    @Override
    public JobDefaults getDefaults() {
        return new JobDefaults();
    }
}

