/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.job.AbstractJob;
import org.jumpmind.symmetric.job.JobDefaults;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class OutgoingPurgeJob
extends AbstractJob {
    public OutgoingPurgeJob(ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        super("Purge Outgoing", engine, taskScheduler);
    }

    @Override
    public JobDefaults getDefaults() {
        return new JobDefaults().schedule("0 0 0 * * *").description("Purge sync'd outgoing data");
    }

    @Override
    public void doJob(boolean force) throws Exception {
        this.setProcessedCount(this.engine.getPurgeService().purgeOutgoing(force));
    }

    @Override
    public String getDeprecatedStartParameter() {
        return "start.purge.incoming.job";
    }
}

