/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.job.AbstractJob;
import org.jumpmind.symmetric.job.JobDefaults;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class WatchdogJob
extends AbstractJob {
    public WatchdogJob(ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        super("Watchdog", engine, taskScheduler);
    }

    @Override
    public JobDefaults getDefaults() {
        return new JobDefaults().requiresRegisteration(false).schedule("3600000").description("Disable nodes that have been offline for a while");
    }

    @Override
    public void doJob(boolean force) throws Exception {
        if (this.engine.getClusterService().lock(this.getName())) {
            try {
                this.engine.getNodeService().checkForOfflineNodes();
            }
            finally {
                this.engine.getClusterService().unlock(this.getName());
            }
        }
    }
}

