/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jumpmind.db.model.CatalogSchema;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Transaction;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.exception.IoException;
import org.jumpmind.extension.IProgressListener;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.common.ParameterConstants;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.csv.CsvWriter;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.firebird.FirebirdSymmetricDialect;
import org.jumpmind.symmetric.db.mysql.MySqlSymmetricDialect;
import org.jumpmind.symmetric.io.data.DbExport;
import org.jumpmind.symmetric.io.data.transform.TransformPoint;
import org.jumpmind.symmetric.io.data.transform.TransformTable;
import org.jumpmind.symmetric.job.IJob;
import org.jumpmind.symmetric.job.IJobManager;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataGap;
import org.jumpmind.symmetric.model.Lock;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.ITransformService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.impl.TransformService;
import org.jumpmind.symmetric.service.impl.UpdateService;
import org.jumpmind.symmetric.util.ISnapshotUtilListener;
import org.jumpmind.symmetric.util.LogSummaryAppenderUtils;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.util.AppUtils;
import org.jumpmind.util.LogSummary;
import org.jumpmind.util.ZipBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@IgnoreJRERequirement
public class SnapshotUtil {
    private static final Logger log = LoggerFactory.getLogger(SnapshotUtil.class);
    protected static final int THREAD_INDENT_SPACE = 50;
    public static final String SNAPSHOT_DIR = "snapshots";

    public static File getSnapshotDirectory(ISymmetricEngine engine) {
        File snapshotsDir = new File(engine.getParameterService().getTempDirectory(), SNAPSHOT_DIR);
        snapshotsDir.mkdirs();
        return snapshotsDir;
    }

    public static File createSnapshot(ISymmetricEngine engine, IProgressListener listener) {
        File backupConfig;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String dirName = engine.getEngineName().replaceAll(" ", "-") + "-" + dateFormat.format(new Date());
        IParameterService parameterService = engine.getParameterService();
        File tmpDir = new File(parameterService.getTempDirectory(), dirName);
        tmpDir.mkdirs();
        log.info("Creating snapshot file in " + tmpDir.getAbsolutePath());
        int stepNumber = 0;
        int totalSteps = 33;
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        try {
            log.info("Calling beforeSnapshot()");
            for (ISnapshotUtilListener snapshotListener : engine.getExtensionService().getExtensionPointList(ISnapshotUtilListener.class)) {
                snapshotListener.beforeSnapshot(engine, tmpDir);
            }
        }
        catch (Exception e) {
            log.info("Call to beforeSnapshot() threw exception", (Throwable)e);
        }
        log.info("Exporting configuration");
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        try (FileWriter fwriter = new FileWriter(new File(tmpDir, "config-export.csv"));){
            engine.getDataExtractorService().extractConfigurationStandalone(engine.getNodeService().findIdentity(), (Writer)fwriter, TableConstants.getConfigTablesExcludedFromExport());
        }
        catch (Exception e) {
            log.warn("Failed to export symmetric configuration", (Throwable)e);
        }
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        File serviceConfFile = new File("conf/sym_service.conf");
        try {
            if (serviceConfFile.exists()) {
                FileUtils.copyFileToDirectory((File)serviceConfFile, (File)tmpDir);
            }
        }
        catch (Exception e) {
            log.warn("Failed to copy " + serviceConfFile.getName() + " to the snapshot directory", (Throwable)e);
        }
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        log.info("Writing table definitions");
        IDatabasePlatform targetPlatform = engine.getSymmetricDialect().getTargetPlatform();
        ISymmetricDialect targetDialect = engine.getTargetDialect();
        try {
            HashMap<CatalogSchema, List<Table>> catalogSchemas = SnapshotUtil.getTablesForCaptureByCatalogSchema(engine);
            SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
            SnapshotUtil.addTablesForLoadByCatalogSchema(engine, catalogSchemas);
            SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
            for (CatalogSchema catalogSchema : catalogSchemas.keySet()) {
                DbExport export = new DbExport(targetPlatform);
                boolean isDefaultCatalog = StringUtils.equalsIgnoreCase((CharSequence)catalogSchema.getCatalog(), (CharSequence)targetPlatform.getDefaultCatalog());
                boolean isDefaultSchema = StringUtils.equalsIgnoreCase((CharSequence)catalogSchema.getSchema(), (CharSequence)targetPlatform.getDefaultSchema());
                Object filename = null;
                if (isDefaultCatalog && isDefaultSchema) {
                    filename = "table-definitions.xml";
                } else {
                    Object extra = "";
                    if (!isDefaultCatalog && catalogSchema.getCatalog() != null) {
                        extra = (String)extra + catalogSchema.getCatalog();
                        export.setCatalog(catalogSchema.getCatalog());
                    }
                    if (!isDefaultSchema && catalogSchema.getSchema() != null) {
                        if (!((String)extra).equals("")) {
                            extra = (String)extra + "-";
                        }
                        extra = (String)extra + catalogSchema.getSchema();
                        export.setSchema(catalogSchema.getSchema());
                    }
                    log.info("Writing table definitions for {}", extra);
                    filename = "table-definitions-" + (String)extra + ".xml";
                }
                try (FileOutputStream fos = new FileOutputStream(new File(tmpDir, (String)filename));){
                    List<Table> tables = catalogSchemas.get(catalogSchema);
                    export.setFormat(DbExport.Format.XML);
                    export.setNoData(true);
                    export.exportTables((OutputStream)fos, tables.toArray(new Table[tables.size()]));
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to export table definitions", (Throwable)e);
        }
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        log.info("Writing runtime data - nodes");
        String tablePrefix = engine.getTablePrefix();
        DbExport export = new DbExport(engine.getDatabasePlatform());
        export.setFormat(DbExport.Format.CSV_DQUOTE);
        export.setNoCreateInfo(true);
        export.setUseReadUncommitted(true);
        int maxBatches = parameterService.getInt("snapshot.max.batches");
        int maxNodeChannels = parameterService.getInt("snapshot.max.node.channels");
        SnapshotUtil.extract(export, new File(tmpDir, "sym_node_identity.csv"), TableConstants.getTableName((String)tablePrefix, (String)"node_identity"));
        SnapshotUtil.extract(export, new File(tmpDir, "sym_node.csv"), TableConstants.getTableName((String)tablePrefix, (String)"node"));
        SnapshotUtil.extract(export, new File(tmpDir, "sym_node_security.csv"), TableConstants.getTableName((String)tablePrefix, (String)"node_security"));
        SnapshotUtil.extract(export, new File(tmpDir, "sym_node_host.csv"), TableConstants.getTableName((String)tablePrefix, (String)"node_host"));
        SnapshotUtil.extract(export, maxNodeChannels, "", new File(tmpDir, "sym_node_channel_ctl.csv"), TableConstants.getTableName((String)tablePrefix, (String)"node_channel_ctl"));
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        log.info("Writing runtime data - locks");
        try {
            if (!parameterService.is("cluster.lock.enabled")) {
                engine.getNodeCommunicationService().persistToTableForSnapshot();
                engine.getClusterService().persistToTableForSnapshot();
            }
        }
        catch (Exception e) {
            log.warn("Unable to add SYM_NODE_COMMUNICATION to the snapshot.", (Throwable)e);
        }
        SnapshotUtil.extract(export, maxNodeChannels, "", new File(tmpDir, "sym_node_communication.csv"), TableConstants.getTableName((String)tablePrefix, (String)"node_communication"));
        SnapshotUtil.extract(export, new File(tmpDir, "sym_context.csv"), TableConstants.getTableName((String)tablePrefix, (String)"context"));
        SnapshotUtil.extract(export, new File(tmpDir, "sym_lock.csv"), TableConstants.getTableName((String)tablePrefix, (String)"lock"));
        log.info("Writing runtime data - outgoing batch");
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        Map nodeSecurities = engine.getNodeService().findAllNodeSecurity(true);
        Map channels = engine.getConfigurationService().getChannels(false);
        String byChannelId = "";
        if (nodeSecurities != null && channels != null && nodeSecurities.size() * channels.size() < maxNodeChannels) {
            byChannelId = "channel_id ,";
        }
        SnapshotUtil.extract(export, maxBatches, "where status = 'OK' order by batch_id desc", new File(tmpDir, "sym_outgoing_batch_ok.csv"), TableConstants.getTableName((String)tablePrefix, (String)"outgoing_batch"));
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        SnapshotUtil.extract(export, maxBatches, "where status != 'OK' order by batch_id", new File(tmpDir, "sym_outgoing_batch_not_ok.csv"), TableConstants.getTableName((String)tablePrefix, (String)"outgoing_batch"));
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        SnapshotUtil.extract(export, maxBatches, "order by start_id, end_id desc", new File(tmpDir, "sym_data_gap.csv"), TableConstants.getTableName((String)tablePrefix, (String)"data_gap"));
        SnapshotUtil.extractQuery(engine.getDatabasePlatform().getSqlTemplateDirty(), tmpDir + File.separator + "sym_outgoing_batch_summary.csv", "select node_id, " + byChannelId + "status, count(*) batch_count, sum(data_row_count) data_row_count, sum(byte_count) byte_count, sum(error_flag) error_flag, min(create_time) min_create_time, sum(router_millis) router_millis, sum(extract_millis) extract_millis, sum(network_millis) network_millis, sum(filter_millis) filter_millis, sum(load_millis) load_millis, sum(fallback_insert_count) fallback_insert_count, sum(fallback_update_count) fallback_update_count, sum(missing_delete_count) missing_delete_count, sum(skip_count) skip_count, sum(ignore_count) ignore_count from " + TableConstants.getTableName((String)tablePrefix, (String)"outgoing_batch") + " group by node_id, " + byChannelId + "status");
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        try {
            SnapshotUtil.outputSymDataForBatchesInError(engine, tmpDir);
        }
        catch (Exception e) {
            log.warn("Failed to export data from batch in error", (Throwable)e);
        }
        log.info("Writing runtime data - incoming batch");
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        SnapshotUtil.extract(export, maxBatches, "where status = 'OK' order by create_time desc", new File(tmpDir, "sym_incoming_batch_ok.csv"), TableConstants.getTableName((String)tablePrefix, (String)"incoming_batch"));
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        SnapshotUtil.extract(export, maxBatches, "where status != 'OK' order by create_time", new File(tmpDir, "sym_incoming_batch_not_ok.csv"), TableConstants.getTableName((String)tablePrefix, (String)"incoming_batch"));
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        SnapshotUtil.extractQuery(engine.getDatabasePlatform().getSqlTemplateDirty(), tmpDir + File.separator + "sym_incoming_batch_summary.csv", "select node_id, " + byChannelId + "status, count(*) batch_count, sum(data_row_count) data_row_count, sum(byte_count) byte_count, sum(error_flag) error_flag, min(create_time) min_create_time, sum(router_millis) router_millis, sum(extract_millis) extract_millis, sum(network_millis) network_millis, sum(filter_millis) filter_millis, sum(load_millis) load_millis, sum(fallback_insert_count) fallback_insert_count, sum(fallback_update_count) fallback_update_count, sum(missing_delete_count) missing_delete_count, sum(skip_count) skip_count, sum(ignore_count) ignore_count from " + TableConstants.getTableName((String)tablePrefix, (String)"incoming_batch") + " group by node_id, " + byChannelId + "status");
        log.info("Writing runtime data - requests");
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        SnapshotUtil.extract(export, new File(tmpDir, "sym_table_reload_request.csv"), TableConstants.getTableName((String)tablePrefix, (String)"table_reload_request"));
        SnapshotUtil.extract(export, new File(tmpDir, "sym_table_reload_status.csv"), TableConstants.getTableName((String)tablePrefix, (String)"table_reload_status"));
        SnapshotUtil.extract(export, new File(tmpDir, "sym_extract_request.csv"), TableConstants.getTableName((String)tablePrefix, (String)"extract_request"));
        SnapshotUtil.extract(export, new File(tmpDir, "sym_compare_request.csv"), TableConstants.getTableName((String)tablePrefix, (String)"compare_request"));
        SnapshotUtil.extract(export, new File(tmpDir, "sym_compare_status.csv"), TableConstants.getTableName((String)tablePrefix, (String)"compare_status"));
        SnapshotUtil.extract(export, new File(tmpDir, "sym_compare_table_status.csv"), TableConstants.getTableName((String)tablePrefix, (String)"compare_table_status"));
        SnapshotUtil.extract(export, new File(tmpDir, "sym_registration_request.csv"), TableConstants.getTableName((String)tablePrefix, (String)"registration_request"));
        log.info("Writing runtime data - history and stats");
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        SnapshotUtil.extract(export, new File(tmpDir, "sym_trigger_hist.csv"), TableConstants.getTableName((String)tablePrefix, (String)"trigger_hist"));
        SnapshotUtil.extract(export, 10000, "order by start_time desc", new File(tmpDir, "sym_node_host_channel_stats.csv"), TableConstants.getTableName((String)tablePrefix, (String)"node_host_channel_stats"));
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        SnapshotUtil.extract(export, 10000, "order by start_time desc", new File(tmpDir, "sym_node_host_stats.csv"), TableConstants.getTableName((String)tablePrefix, (String)"node_host_stats"));
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        if (parameterService.is("file.sync.enable")) {
            SnapshotUtil.extract(export, 5000, "order by relative_dir, file_name", new File(tmpDir, "sym_file_snapshot.csv"), TableConstants.getTableName((String)tablePrefix, (String)"file_snapshot"));
        }
        export.setIgnoreMissingTables(true);
        log.info("Writing runtime data - console and events");
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        SnapshotUtil.extract(export, new File(tmpDir, "sym_console_event.csv"), TableConstants.getTableName((String)tablePrefix, (String)"console_event"));
        SnapshotUtil.extract(export, new File(tmpDir, "sym_monitor_event.csv"), TableConstants.getTableName((String)tablePrefix, (String)"monitor_event"));
        log.info("Writing runtime data - parameters");
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        try {
            TypedProperties effectiveParameters = engine.getParameterService().getAllParameters();
            Properties parameters = new Properties();
            parameters.putAll((Map<?, ?>)effectiveParameters);
            parameters.remove("db.password");
            SnapshotUtil.writeProperties(parameters, tmpDir, "parameters.properties");
        }
        catch (Exception e) {
            log.warn("Failed to export parameter information", (Throwable)e);
        }
        try {
            Properties defaultParameters = new Properties();
            InputStream in = SnapshotUtil.class.getResourceAsStream("/symmetric-default.properties");
            defaultParameters.load(in);
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((in = SnapshotUtil.class.getResourceAsStream("/symmetric-console-default.properties")) != null) {
                defaultParameters.load(in);
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            TypedProperties effectiveParameters = engine.getParameterService().getAllParameters();
            Properties changedParameters = new Properties();
            Map parameters = ParameterConstants.getParameterMetaData();
            for (String key : parameters.keySet()) {
                String defaultValue = defaultParameters.getProperty(key);
                String currentValue = effectiveParameters.getProperty(key);
                if ((defaultValue != null || currentValue == null) && (defaultValue == null || defaultValue.equals(currentValue))) continue;
                changedParameters.put(key, currentValue == null ? "" : currentValue);
            }
            for (String name : new String[]{"db.password", "target.db.password", "smtp.password", "redshift.bulk.load.s3.access.key", "redshift.bulk.load.s3.secret.key", "opensearch.load.aws.access.key", "opensearch.load.aws.secret.key", "cloud.bulk.load.s3.access.key", "cloud.bulk.load.s3.secret.key", "cloud.bulk.load.azure.sas.token", "registration.secret"}) {
                changedParameters.remove(name);
            }
            SnapshotUtil.writeProperties(changedParameters, tmpDir, "parameters-changed.properties");
        }
        catch (Exception e) {
            log.warn("Failed to export parameters-changed information", (Throwable)e);
        }
        try {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)System.getProperties());
            SnapshotUtil.writeProperties(props, tmpDir, "system.properties");
        }
        catch (Exception e) {
            log.warn("Failed to export system information", (Throwable)e);
        }
        log.info("Writing runtime data - log summaries");
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        File logSummaryFile = new File(tmpDir, "log-summary.csv");
        try (FileOutputStream outputStream = new FileOutputStream(logSummaryFile);
             CsvWriter csvWriter = new CsvWriter((OutputStream)outputStream, ',', Charset.defaultCharset());){
            csvWriter.setEscapeMode(1);
            csvWriter.setForceQualifier(true);
            csvWriter.writeRecord(new String[]{"Level", "First Time", "Last Time", "Count", "Message", "Stack Trace"});
            String[] df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            List logSummaries = LogSummaryAppenderUtils.getLogSummaryErrors((String)engine.getEngineName());
            logSummaries.addAll(LogSummaryAppenderUtils.getLogSummaryWarnings((String)engine.getEngineName()));
            for (LogSummary s : logSummaries) {
                csvWriter.writeRecord(new String[]{s.getLevel().name(), df.format(new Date(s.getFirstOccurranceTime())), df.format(new Date(s.getMostRecentTime())), String.valueOf(s.getCount()), s.getMessage(), s.getStackTrace()});
            }
            csvWriter.flush();
        }
        catch (Exception e) {
            log.warn("Failed to write log summaries");
        }
        log.info("Writing runtime data - platform specific");
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        if (targetDialect instanceof FirebirdSymmetricDialect) {
            log.info("Writing Firebird info");
            String[] monTables = new String[]{"mon$database", "mon$attachments", "mon$transactions", "mon$statements", "mon$io_stats", "mon$record_stats", "mon$memory_usage", "mon$call_stack", "mon$context_variables"};
            DbExport dbexport = new DbExport(targetPlatform);
            dbexport.setFormat(DbExport.Format.CSV_DQUOTE);
            dbexport.setNoCreateInfo(true);
            for (String table : monTables) {
                SnapshotUtil.extract(dbexport, new File(tmpDir, "firebird-" + table + ".csv"), table);
            }
        }
        if (targetDialect instanceof MySqlSymmetricDialect) {
            log.info("Writing MySQL info");
            SnapshotUtil.extractQuery(targetPlatform.getSqlTemplate(), tmpDir + File.separator + "mysql-processlist.csv", "show processlist");
            SnapshotUtil.extractQuery(targetPlatform.getSqlTemplate(), tmpDir + File.separator + "mysql-global-variables.csv", "show global variables");
            SnapshotUtil.extractQuery(targetPlatform.getSqlTemplate(), tmpDir + File.separator + "mysql-session-variables.csv", "show session variables");
        }
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        if (!engine.getParameterService().is("cluster.lock.enabled")) {
            try (FileOutputStream fos = new FileOutputStream(new File(tmpDir, "sym_data_gap_cache.csv"));){
                List gaps = engine.getRouterService().getDataGaps();
                File[] dformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                dformat.setTimeZone(TimeZone.getTimeZone("GMT"));
                fos.write("start_id,end_id,create_time\n".getBytes(Charset.defaultCharset()));
                if (gaps != null) {
                    for (DataGap gap : gaps) {
                        fos.write((gap.getStartId() + "," + gap.getEndId() + ",\"" + dformat.format(gap.getCreateTime()) + "\",\"\"\n").getBytes(Charset.defaultCharset()));
                    }
                }
            }
            catch (Exception e) {
                log.warn("Failed to export data gap information", (Throwable)e);
            }
        }
        log.info("Writing threads info");
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        SnapshotUtil.createThreadsFile(tmpDir.getPath(), false);
        SnapshotUtil.createThreadsFile(tmpDir.getPath(), true);
        SnapshotUtil.createThreadStatsFile(tmpDir.getPath());
        SnapshotUtil.createProcessInfoFile(engine, tmpDir.getPath());
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        try {
            log.info("Writing transactions file");
            List transactions = targetPlatform.getTransactions();
            if (!transactions.isEmpty()) {
                SnapshotUtil.createTransactionsFile(engine, tmpDir.getPath(), transactions);
            }
        }
        catch (Throwable e) {
            log.warn("Failed to create transactions file", e);
        }
        log.info("Writing runtime stats");
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        SnapshotUtil.writeRuntimeStats(engine, tmpDir);
        log.info("Writing job stats");
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        SnapshotUtil.writeJobsStats(engine, tmpDir);
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        if ("true".equals(System.getProperty("symmetric.standalone.web"))) {
            SnapshotUtil.writeDirectoryListing(engine, tmpDir);
        }
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        SnapshotUtil.writeDirectoryStaging(engine, tmpDir);
        File logDir = LogSummaryAppenderUtils.getLogDir();
        if (logDir == null || !logDir.exists()) {
            logDir = new File("logs");
        }
        if (!logDir.exists()) {
            logDir = new File("../logs");
        }
        if (!logDir.exists()) {
            logDir = new File("target");
        }
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        if (logDir.exists()) {
            log.info("Copying log files");
            File[] files = logDir.listFiles();
            if (files != null) {
                for (File file : files) {
                    String name = file.getName().toLowerCase();
                    if (!name.endsWith(".log") && !name.endsWith(".log.1") && !name.endsWith(".log.2") && !name.endsWith(".log.3") || !name.contains("symmetric") && !name.contains("wrapper")) continue;
                    try {
                        FileUtils.copyFileToDirectory((File)file, (File)tmpDir);
                    }
                    catch (Exception e) {
                        log.warn("Failed to copy " + file.getName() + " to the snapshot directory", (Throwable)e);
                    }
                }
            }
        }
        if ((backupConfig = new File("conf/.config")).canRead()) {
            try {
                FileUtils.copyFileToDirectory((File)backupConfig, (File)tmpDir);
            }
            catch (IOException e) {
                log.warn("Failed to copy {}", (Object)backupConfig.getName());
            }
        }
        log.info("Packaging ZIP file");
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        File jarFile = null;
        try {
            String filename = tmpDir.getName() + ".zip";
            if (parameterService.is("snapshot.file.include.hostname")) {
                filename = AppUtils.getHostName() + "_" + filename;
            }
            jarFile = new File(SnapshotUtil.getSnapshotDirectory(engine), filename);
            ZipBuilder builder = new ZipBuilder(tmpDir, jarFile, new File[]{tmpDir});
            builder.build();
            FileUtils.deleteDirectory((File)tmpDir);
        }
        catch (Exception e) {
            throw new IoException("Failed to package snapshot files into archive", (Throwable)e);
        }
        SnapshotUtil.checkpoint(engine, listener, stepNumber++, totalSteps);
        try {
            log.info("Calling afterSnapshot()");
            for (ISnapshotUtilListener snapshotListener : engine.getExtensionService().getExtensionPointList(ISnapshotUtilListener.class)) {
                snapshotListener.afterSnapshot(engine, tmpDir);
            }
        }
        catch (Exception e) {
            log.info("Call to afterSnapshot() threw exception", (Throwable)e);
        }
        SnapshotUtil.checkpoint(engine, listener, stepNumber, totalSteps);
        log.info("Done creating snapshot file in {} steps", (Object)stepNumber);
        return jarFile;
    }

    protected static void checkpoint(ISymmetricEngine engine, IProgressListener listener, int stepNumber, int totalSteps) {
        try {
            if (listener != null) {
                listener.checkpoint(engine.getEngineName(), stepNumber, totalSteps);
            }
        }
        catch (Exception e) {
            log.info("Call to checkpoint threw exception", (Throwable)e);
        }
    }

    protected static void extract(DbExport export, File file, String ... tables) {
        SnapshotUtil.extract(export, Integer.MAX_VALUE, null, file, tables);
    }

    protected static void extract(DbExport export, int maxRows, String whereClause, File file, String ... tables) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            export.setMaxRows(maxRows);
            export.setWhereClause(whereClause);
            export.exportTables((OutputStream)fos, tables);
        }
        catch (Exception e) {
            log.warn("Failed to export table definitions", (Throwable)e);
        }
    }

    protected static void extractQuery(ISqlTemplate sqlTemplate, String fileName, String sql) {
        try (CsvWriter writer = new CsvWriter(fileName);){
            List rows = sqlTemplate.query(sql);
            writer.setEscapeMode(1);
            writer.setForceQualifier(true);
            boolean isFirstRow = true;
            for (Row row : rows) {
                if (isFirstRow) {
                    for (String key : row.keySet()) {
                        writer.write(key);
                    }
                    writer.endRecord();
                    isFirstRow = false;
                }
                for (String key : row.keySet()) {
                    writer.write(row.getString(key));
                }
                writer.endRecord();
            }
        }
        catch (Exception e) {
            log.warn("Failed to run extract query " + sql, (Throwable)e);
        }
    }

    protected static void writeDirectoryListing(ISymmetricEngine engine, File tmpDir) {
        try {
            File home = new File(System.getProperty("user.dir"));
            if (home.getName().equalsIgnoreCase("bin")) {
                home = home.getParentFile();
            }
            log.info("Writing directory listing of {}", (Object)home);
            StringBuilder output = new StringBuilder();
            int maxFiles = engine.getParameterService().getInt("snapshot.max.files");
            SnapshotUtil.printDirectoryContents(home, output, new PrintDirConfig(maxFiles, engine.getStagingManager().getStagingDirectory().getParentFile()));
            FileUtils.write((File)new File(tmpDir, "directory-listing.txt"), (CharSequence)output, (Charset)Charset.defaultCharset(), (boolean)false);
        }
        catch (Exception ex) {
            log.warn("Failed to output the directory listing", (Throwable)ex);
        }
    }

    protected static void writeDirectoryStaging(ISymmetricEngine engine, File tmpDir) {
        try {
            log.info("Writing staging listing of {}", (Object)engine.getStagingManager().getStagingDirectory());
            StringBuilder output = new StringBuilder();
            int maxFiles = engine.getParameterService().getInt("snapshot.max.files");
            SnapshotUtil.printDirectoryContents(engine.getStagingManager().getStagingDirectory(), output, new PrintDirConfig(maxFiles));
            FileUtils.write((File)new File(tmpDir, "directory-staging.txt"), (CharSequence)output, (Charset)Charset.defaultCharset(), (boolean)false);
        }
        catch (Exception ex) {
            log.warn("Failed to output the directory staging", (Throwable)ex);
        }
    }

    protected static void printDirectoryContents(File dir, StringBuilder output, PrintDirConfig config) throws IOException {
        if (config.getFileCount() >= config.getMaxCount()) {
            return;
        }
        output.append("\n");
        output.append(dir.getCanonicalPath());
        output.append("\n");
        File[] files = dir.listFiles();
        if (files != null) {
            Arrays.parallelSort(files, config.getFileComparator());
            for (File file : files) {
                output.append("  ");
                output.append(file.isDirectory() ? "d" : "-");
                output.append(file.canRead() ? "r" : "-");
                output.append(file.canWrite() ? "w" : "-");
                output.append(file.canExecute() ? "x" : "-");
                output.append(StringUtils.leftPad((String)("" + file.length()), (int)11));
                output.append(" ");
                output.append(config.getDateFormat().format(new Date(file.lastModified())));
                output.append(" ");
                output.append(file.getName());
                output.append("\n");
                if (config.incrementFileCount() < config.getMaxCount()) continue;
                output.append("\n*** MAX LIMIT OF " + config.getMaxCount() + " FILES ***\n");
                return;
            }
            for (File file : files) {
                if (!file.isDirectory() || config.getExcludeDir() != null && (config.getExcludeDir().equals(dir) || file.getName().equalsIgnoreCase("tmp"))) continue;
                SnapshotUtil.printDirectoryContents(file, output, config);
            }
        }
    }

    protected static void writeRuntimeStats(ISymmetricEngine engine, File tmpDir) {
        try {
            Properties runtimeProperties = new Properties();
            DataSource dataSource = (DataSource)engine.getDatabasePlatform().getDataSource();
            if (dataSource instanceof BasicDataSource) {
                BasicDataSource dbcp = (BasicDataSource)dataSource;
                runtimeProperties.setProperty("connections.idle", String.valueOf(dbcp.getNumIdle()));
                runtimeProperties.setProperty("connections.used", String.valueOf(dbcp.getNumActive()));
                runtimeProperties.setProperty("connections.max", String.valueOf(dbcp.getMaxTotal()));
            }
            Runtime rt = Runtime.getRuntime();
            DecimalFormat df = new DecimalFormat("#,###");
            runtimeProperties.setProperty("memory.jvm.free", df.format(rt.freeMemory()));
            runtimeProperties.setProperty("memory.jvm.used", df.format(rt.totalMemory() - rt.freeMemory()));
            runtimeProperties.setProperty("memory.jvm.max", df.format(rt.maxMemory()));
            ArrayList<MemoryPoolMXBean> memoryPools = new ArrayList<MemoryPoolMXBean>(ManagementFactory.getMemoryPoolMXBeans());
            long usedHeapMemory = 0L;
            for (MemoryPoolMXBean memoryPool : memoryPools) {
                if (memoryPool.getType() != MemoryType.HEAP) continue;
                MemoryUsage memoryUsage = memoryPool.getCollectionUsage();
                runtimeProperties.setProperty("memory.heap." + memoryPool.getName().toLowerCase().replaceAll(" ", "."), df.format(memoryUsage.getUsed()));
                usedHeapMemory += memoryUsage.getUsed();
            }
            runtimeProperties.setProperty("memory.heap.total", df.format(usedHeapMemory));
            try {
                Method method = ManagementFactory.getOperatingSystemMXBean().getClass().getMethod("getTotalPhysicalMemorySize", new Class[0]);
                method.setAccessible(true);
                runtimeProperties.setProperty("memory.system.total", df.format(method.invoke((Object)ManagementFactory.getOperatingSystemMXBean(), new Object[0])));
            }
            catch (Exception method) {
                // empty catch block
            }
            OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            runtimeProperties.setProperty("os.name", System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ")");
            runtimeProperties.setProperty("os.processors", String.valueOf(osBean.getAvailableProcessors()));
            runtimeProperties.setProperty("os.load.average", String.valueOf(osBean.getSystemLoadAverage()));
            runtimeProperties.setProperty("engine.is.started", Boolean.toString(engine.isStarted()));
            runtimeProperties.setProperty("engine.last.restart", engine.getLastRestartTime() != null ? engine.getLastRestartTime().toString() : "");
            runtimeProperties.setProperty("time.server", new Date().toString());
            runtimeProperties.setProperty("time.database", new Date(engine.getTargetDialect().getDatabaseTime()).toString());
            runtimeProperties.setProperty("batch.unrouted.data.count", df.format(engine.getRouterService().getUnroutedDataCount()));
            runtimeProperties.setProperty("batch.outgoing.errors.count", df.format(engine.getOutgoingBatchService().countOutgoingBatchesInError()));
            runtimeProperties.setProperty("batch.outgoing.tosend.count", df.format(engine.getOutgoingBatchService().countOutgoingBatchesUnsent()));
            runtimeProperties.setProperty("batch.incoming.errors.count", df.format(engine.getIncomingBatchService().countIncomingBatchesInError()));
            List gaps = engine.getDataService().findDataGapsUnchecked();
            runtimeProperties.setProperty("data.gap.count", df.format(gaps.size()));
            if (gaps.size() > 0) {
                runtimeProperties.setProperty("data.gap.start.id", df.format(((DataGap)gaps.get(0)).getStartId()));
                runtimeProperties.setProperty("data.gap.end.id", df.format(((DataGap)gaps.get(gaps.size() - 1)).getEndId()));
            }
            runtimeProperties.setProperty("data.id.min", df.format(engine.getDataService().findMinDataId()));
            runtimeProperties.setProperty("data.id.max", df.format(engine.getDataService().findMaxDataId()));
            String jvmTitle = Runtime.class.getPackage().getImplementationTitle();
            runtimeProperties.put("jvm.title", jvmTitle != null ? jvmTitle : "Unknown");
            String jvmVendor = Runtime.class.getPackage().getImplementationVendor();
            runtimeProperties.put("jvm.vendor", jvmVendor != null ? jvmVendor : "Unknown");
            String jvmVersion = Runtime.class.getPackage().getImplementationVersion();
            runtimeProperties.put("jvm.version", jvmVersion != null ? jvmVersion : "Unknown");
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            List<String> arguments = runtimeMxBean.getInputArguments();
            runtimeProperties.setProperty("jvm.arguments", arguments.toString());
            runtimeProperties.setProperty("jvm.bits", System.getProperty("sun.arch.data.model", System.getProperty("com.ibm.vm.bitmode")));
            runtimeProperties.setProperty("hostname", AppUtils.getHostName());
            runtimeProperties.setProperty("instance.id", engine.getClusterService().getInstanceId());
            runtimeProperties.setProperty("server.id", engine.getClusterService().getServerId());
            try {
                runtimeProperties.setProperty("charset.server", System.getProperty("file.encoding"));
                runtimeProperties.setProperty("charset.database", engine.getTargetDialect().getTargetPlatform().getCharSetName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                ObjectName oName = new ObjectName("java.lang:type=OperatingSystem");
                runtimeProperties.setProperty("file.descriptor.open.count", mbeanServer.getAttribute(oName, "OpenFileDescriptorCount").toString());
                runtimeProperties.setProperty("file.descriptor.max.count", mbeanServer.getAttribute(oName, "MaxFileDescriptorCount").toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            SnapshotUtil.writeProperties(runtimeProperties, tmpDir, "runtime-stats.properties");
        }
        catch (Exception e) {
            log.warn("Failed to export runtime-stats information", (Throwable)e);
        }
    }

    protected static void writeProperties(Properties properties, File tmpDir, String fileName) {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(new File(tmpDir, fileName)));){
            ArrayList<String> keys = new ArrayList<String>();
            for (Object object : properties.keySet()) {
                keys.add(object.toString());
            }
            Collections.sort(keys);
            for (String string : keys) {
                bw.write(string + "=" + properties.getProperty(string).replace("\n", "\\n").replace("\r", "\\r"));
                bw.newLine();
            }
        }
        catch (Exception e) {
            log.warn("Failed to write " + fileName, (Throwable)e);
        }
    }

    protected static void writeJobsStats(ISymmetricEngine engine, File tmpDir) {
        try (FileWriter writer = new FileWriter(new File(tmpDir, "jobs.txt"));){
            IJobManager jobManager = engine.getJobManager();
            IClusterService clusterService = engine.getClusterService();
            INodeService nodeService = engine.getNodeService();
            writer.write("Clustering is " + (clusterService.isClusteringEnabled() ? "" : "not ") + "enabled and there are " + nodeService.findNodeHosts(nodeService.findIdentityNodeId()).size() + " instances in the cluster\n\n");
            writer.write(StringUtils.rightPad((String)"Job Name", (int)30) + StringUtils.rightPad((String)"Schedule", (int)20) + StringUtils.rightPad((String)"Status", (int)10) + StringUtils.rightPad((String)"Server Id", (int)30) + StringUtils.rightPad((String)"Last Server Id", (int)30) + StringUtils.rightPad((String)"Last Finish Time", (int)30) + StringUtils.rightPad((String)"Next Run Time", (int)30) + StringUtils.rightPad((String)"Last Run Period", (int)20) + StringUtils.rightPad((String)"Avg. Run Period", (int)20) + "\n");
            List jobs = jobManager.getJobs();
            Map locks = clusterService.findLocks();
            for (IJob job : jobs) {
                Lock lock = (Lock)locks.get(job.getName());
                String status = SnapshotUtil.getJobStatus(job, lock);
                String runningServerId = lock != null ? lock.getLockingServerId() : "";
                String lastServerId = clusterService.getServerId();
                if (lock != null) {
                    lastServerId = lock.getLastLockingServerId();
                }
                String schedule = job.getSchedule();
                String lastFinishTime = SnapshotUtil.getLastFinishTime(job, lock);
                String nextRunTime = job.getNextExecutionTime() == null ? "" : DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.format(job.getNextExecutionTime());
                writer.write(StringUtils.rightPad((String)job.getName().replace("_", " "), (int)30) + StringUtils.rightPad((String)schedule, (int)20) + StringUtils.rightPad((String)status, (int)10) + StringUtils.left((String)StringUtils.rightPad((String)(runningServerId == null ? "" : runningServerId), (int)30), (int)30) + StringUtils.left((String)StringUtils.rightPad((String)(lastServerId == null ? "" : lastServerId), (int)30), (int)30) + StringUtils.rightPad((String)(lastFinishTime == null ? "" : lastFinishTime), (int)30) + StringUtils.rightPad((String)nextRunTime, (int)30) + StringUtils.rightPad((String)("" + job.getLastExecutionTimeInMs()), (int)20) + StringUtils.rightPad((String)("" + job.getAverageExecutionTimeInMs()), (int)20) + "\n");
            }
        }
        catch (Exception e) {
            log.warn("Failed to write jobs information", (Throwable)e);
        }
    }

    protected static String getJobStatus(IJob job, Lock lock) {
        String status = "IDLE";
        if (lock != null) {
            if (lock.isStopped()) {
                status = "STOPPED";
            } else if (lock.getLockTime() != null) {
                status = "RUNNING";
            }
        } else {
            status = job.isRunning() ? "RUNNING" : (job.isPaused() ? "PAUSED" : (job.isStarted() ? "IDLE" : "STOPPED"));
        }
        return status;
    }

    protected static String getLastFinishTime(IJob job, Lock lock) {
        if (lock != null && lock.getLastLockTime() != null) {
            return DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.format(lock.getLastLockTime());
        }
        return job.getLastFinishTime() == null ? null : DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.format(job.getLastFinishTime());
    }

    public static File createThreadsFile(String parent, boolean isFiltered) {
        File file = new File(parent, isFiltered ? "threads-filtered.txt" : "threads.txt");
        try (FileWriter fwriter = new FileWriter(file);){
            long[] threadIds;
            ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
            for (long l : threadIds = threadBean.getAllThreadIds()) {
                ThreadInfo info = threadBean.getThreadInfo(l, 100);
                if (info == null) continue;
                String threadName = info.getThreadName();
                boolean skip = isFiltered;
                if (isFiltered) {
                    for (StackTraceElement element : info.getStackTrace()) {
                        String name = element.getClassName();
                        if (name.startsWith("com.jumpmind.") || name.startsWith("org.jumpmind.")) {
                            skip = false;
                        }
                        if (!name.equals(SnapshotUtil.class.getName()) && !name.startsWith(UpdateService.class.getName())) continue;
                        skip = true;
                        break;
                    }
                }
                if (skip) continue;
                fwriter.append(StringUtils.rightPad((String)threadName, (int)50));
                fwriter.append(AppUtils.formatStackTrace((StackTraceElement[])info.getStackTrace(), (int)50, (boolean)false));
                fwriter.append("\n");
            }
        }
        catch (Exception e) {
            log.warn("Failed to export thread information", (Throwable)e);
        }
        return file;
    }

    public static File createThreadStatsFile(String parent) {
        File file = new File(parent, "threads-stats.csv");
        try (FileOutputStream outputStream = new FileOutputStream(file);
             CsvWriter csvWriter = new CsvWriter((OutputStream)outputStream, ',', Charset.forName("ISO-8859-1"));){
            long[] threadIds;
            csvWriter.setEscapeMode(1);
            csvWriter.setForceQualifier(true);
            String[] heading = new String[]{"Thread", "Allocated Memory (Bytes)", "CPU Time (Seconds)"};
            csvWriter.writeRecord(heading);
            ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
            for (long l : threadIds = threadBean.getAllThreadIds()) {
                ThreadInfo info = threadBean.getThreadInfo(l, 100);
                if (info == null) continue;
                String threadName = info.getThreadName();
                long threadId = info.getThreadId();
                long allocatedBytes = 0L;
                try {
                    Method method = threadBean.getClass().getMethod("getThreadAllocatedBytes", new Class[0]);
                    method.setAccessible(true);
                    allocatedBytes = (Long)method.invoke((Object)threadBean, threadId);
                }
                catch (Exception method) {
                    // empty catch block
                }
                String[] row = new String[]{threadName, Long.toString(allocatedBytes), Float.toString((float)threadBean.getThreadCpuTime(threadId) / 1.0E9f)};
                csvWriter.writeRecord(row);
            }
            csvWriter.flush();
        }
        catch (Exception e) {
            log.warn("Failed to export thread information", (Throwable)e);
        }
        return file;
    }

    public static void createProcessInfoFile(ISymmetricEngine engine, String parent) {
        try {
            File file = new File(parent, "process-info.csv");
            File fileActive = new File(parent, "process-info-active.csv");
            List infos = engine.getStatisticManager().getProcessInfos();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try (FileOutputStream outputStream = new FileOutputStream(file);
                 FileOutputStream outputActiveStream = new FileOutputStream(fileActive);
                 CsvWriter csvWriter = new CsvWriter((OutputStream)outputStream, ',', Charset.defaultCharset());
                 CsvWriter csvActiveWriter = new CsvWriter((OutputStream)outputActiveStream, ',', Charset.defaultCharset());){
                csvWriter.setEscapeMode(1);
                String[] heading = new String[]{"Thread Name", "Source Node", "Target Node", "Type", "Queue", "Current Channel ID", "Status", "Current Data Count", "Total Data Count", "Total Batch Count", "Current Batch ID", "Current Batch Count", "Current Table Name", "Batch Start Time", "Load ID", "Start Time", "End Time"};
                csvWriter.writeRecord(heading);
                csvActiveWriter.writeRecord(heading);
                for (ProcessInfo i : infos) {
                    Thread t = i.getThread();
                    String[] row = new String[]{t == null ? null : t.getName(), i.getSourceNodeId(), i.getTargetNodeId(), i.getProcessType().toString(), i.getQueue(), i.getCurrentChannelId(), i.getStatus().toString(), String.valueOf(i.getCurrentDataCount()), String.valueOf(i.getTotalDataCount()), String.valueOf(i.getTotalBatchCount()), String.valueOf(i.getCurrentBatchId()), String.valueOf(i.getCurrentBatchCount()), i.getCurrentTableName(), i.getCurrentBatchStartTime() == null ? null : df.format(i.getCurrentBatchStartTime()), String.valueOf(i.getCurrentLoadId()), i.getStartTime() == null ? null : df.format(i.getStartTime()), i.getEndTime() == null ? null : df.format(i.getEndTime())};
                    csvWriter.writeRecord(row);
                    if (i.getEndTime() != null) continue;
                    csvActiveWriter.writeRecord(row);
                }
                csvWriter.flush();
                csvActiveWriter.flush();
            }
        }
        catch (Exception e) {
            log.warn("Failed to write process info", (Throwable)e);
        }
    }

    private static File createTransactionsFile(ISymmetricEngine engine, String parent, List<Transaction> transactions) {
        HashMap<String, Transaction> transactionMap = new HashMap<String, Transaction>();
        for (Transaction transaction : transactions) {
            transactionMap.put(transaction.getId(), transaction);
        }
        ArrayList filteredTransactions = new ArrayList();
        String dbUser = engine.getParameterService().getString("db.user");
        for (Transaction transaction : transactions) {
            SymmetricUtils.filterTransactions((Transaction)transaction, transactionMap, filteredTransactions, (String)dbUser, (boolean)false, (boolean)false);
        }
        File file = new File(parent, "transactions.csv");
        try (FileOutputStream outputStream = new FileOutputStream(file);
             CsvWriter csvWriter = new CsvWriter((OutputStream)outputStream, ',', Charset.forName("ISO-8859-1"));){
            csvWriter.setEscapeMode(1);
            String[] heading = new String[]{"ID", "Username", "Remote IP", "Remote Host", "Status", "Reads", "Writes", "Blocking ID", "Duration", "Text"};
            csvWriter.writeRecord(heading);
            for (Transaction transaction : filteredTransactions) {
                String[] row = new String[]{transaction.getId(), transaction.getUsername(), transaction.getRemoteIp(), transaction.getRemoteHost(), transaction.getStatus(), transaction.getReads() == -1 ? "" : String.valueOf(transaction.getReads()), transaction.getWrites() == -1 ? "" : String.valueOf(transaction.getWrites()), transaction.getBlockingId(), String.valueOf(transaction.getDuration()) + " ms", transaction.getText()};
                csvWriter.writeRecord(row);
            }
            csvWriter.flush();
        }
        catch (Exception e) {
            log.warn("Failed to create transactions file", (Throwable)e);
        }
        return file;
    }

    public static void outputSymDataForBatchesInError(ISymmetricEngine engine, File tmpDir) {
        String tablePrefix = engine.getTablePrefix();
        DbExport export = new DbExport(engine.getDatabasePlatform());
        export.setFormat(DbExport.Format.CSV_DQUOTE);
        export.setNoCreateInfo(true);
        for (OutgoingBatch batch : engine.getOutgoingBatchService().getOutgoingBatchErrors(10000).getBatches()) {
            if (batch.getFailedDataId() <= 0L) continue;
            Data data = engine.getDataService().findData(batch.getFailedDataId());
            if (data != null) {
                String filenameCaptured = batch.getBatchId() + "_captured.csv";
                String whereClause = "where data_id = " + data.getDataId();
                SnapshotUtil.extract(export, 10000, whereClause, new File(tmpDir, filenameCaptured), TableConstants.getTableName((String)tablePrefix, (String)"data"));
                String filenameParsed = tmpDir + File.separator + batch.getBatchId() + "_parsed.csv";
                try (CsvWriter writer = new CsvWriter(filenameParsed);){
                    writer.setEscapeMode(1);
                    writer.writeRecord(data.getTriggerHistory().getParsedColumnNames());
                    writer.writeRecord(data.toParsedRowData());
                    writer.writeRecord(data.toParsedOldData());
                }
                catch (Exception e) {
                    log.warn("Failed to write parsed row data from sym_data to file " + filenameParsed, (Throwable)e);
                }
                continue;
            }
            log.warn("Could not find data ID: " + batch.getFailedDataId() + " for batch ID: " + batch.getBatchId() + " in error");
        }
    }

    public static HashMap<CatalogSchema, List<Table>> getTablesForCaptureByCatalogSchema(ISymmetricEngine engine) {
        IDatabasePlatform targetPlatform = engine.getSymmetricDialect().getTargetPlatform();
        HashMap<CatalogSchema, List<Table>> catalogSchemas = new HashMap<CatalogSchema, List<Table>>();
        ITriggerRouterService triggerRouterService = engine.getTriggerRouterService();
        List triggerHistories = triggerRouterService.getActiveTriggerHistories();
        String tablePrefix = engine.getTablePrefix().toUpperCase();
        HashSet<String> triggerIds = new HashSet<String>();
        boolean isClonedTables = engine.getParameterService().is("sync.triggers.expand.table.clone", true);
        long timeoutMillis = engine.getParameterService().getLong("snapshot.operation.timeout.ms", 30000L);
        long ts = System.currentTimeMillis();
        for (TriggerHistory triggerHistory : triggerHistories) {
            Trigger trigger;
            if (triggerHistory.getSourceTableName().toUpperCase().startsWith(tablePrefix) || isClonedTables && !triggerIds.add(triggerHistory.getTriggerId()) && (trigger = triggerRouterService.getTriggerById(triggerHistory.getTriggerId(), false)) != null && trigger.getSourceTableName().contains("$(targetExternalId)")) continue;
            Table table = targetPlatform.getTableFromCache(triggerHistory.getSourceCatalogName(), triggerHistory.getSourceSchemaName(), triggerHistory.getSourceTableName(), false);
            if (table != null) {
                SnapshotUtil.addTableToMap(catalogSchemas, new CatalogSchema(table.getCatalog(), table.getSchema()), table);
            }
            if (System.currentTimeMillis() - ts <= timeoutMillis) continue;
            log.info("Reached time limit for capture table definitions");
            break;
        }
        return catalogSchemas;
    }

    public static HashMap<CatalogSchema, List<Table>> getTablesForLoadByCatalogSchema(ISymmetricEngine engine) {
        HashMap<CatalogSchema, List<Table>> tables = new HashMap<CatalogSchema, List<Table>>();
        SnapshotUtil.addTablesForLoadByCatalogSchema(engine, tables);
        return tables;
    }

    protected static void addTablesForLoadByCatalogSchema(ISymmetricEngine engine, HashMap<CatalogSchema, List<Table>> catalogSchemas) {
        ITriggerRouterService triggerRouterService = engine.getTriggerRouterService();
        IParameterService parameterService = engine.getParameterService();
        IDatabasePlatform targetPlatform = engine.getSymmetricDialect().getTargetPlatform();
        Node targetNode = engine.getNodeService().findIdentity();
        List nodes = engine.getNodeService().findAllNodes();
        HashMap<String, Node> sampleNodeForGroup = new HashMap<String, Node>();
        for (Node node : nodes) {
            sampleNodeForGroup.put(node.getNodeGroupId(), node);
        }
        HashMap<NodeGroupLink, Map<String, List<TransformTable>>> extractTransformMap = new HashMap<NodeGroupLink, Map<String, List<TransformTable>>>();
        HashMap<NodeGroupLink, Map<String, List<TransformTable>>> loadTransformMap = new HashMap<NodeGroupLink, Map<String, List<TransformTable>>>();
        List triggerRouters = triggerRouterService.getTriggerRoutersForTargetNode(parameterService.getNodeGroupId());
        long timeoutMillis = engine.getParameterService().getLong("snapshot.operation.timeout.ms", 30000L);
        long ts = System.currentTimeMillis();
        for (TriggerRouter triggerRouter : triggerRouters) {
            String tableKey;
            Trigger trigger = triggerRouter.getTrigger();
            if (trigger.isSourceWildCarded()) continue;
            String catalog = null;
            String schema = null;
            String tableName = trigger.getSourceTableName();
            Router router = triggerRouter.getRouter();
            Node sourceNode = (Node)sampleNodeForGroup.get(router.getNodeGroupLink().getSourceNodeGroupId());
            if (router.isUseSourceCatalogSchema()) {
                catalog = trigger.getSourceCatalogName();
                schema = trigger.getSourceSchemaName();
            }
            if (StringUtils.equals((CharSequence)"$(none)", (CharSequence)router.getTargetCatalogName())) {
                catalog = null;
            } else if (StringUtils.isNotBlank((CharSequence)router.getTargetCatalogName())) {
                catalog = SymmetricUtils.replaceNodeVariables((Node)sourceNode, (Node)targetNode, (String)router.getTargetCatalogName());
            }
            if (StringUtils.equals((CharSequence)"$(none)", (CharSequence)router.getTargetSchemaName())) {
                schema = null;
            } else if (StringUtils.isNotBlank((CharSequence)router.getTargetSchemaName())) {
                schema = SymmetricUtils.replaceNodeVariables((Node)sourceNode, (Node)targetNode, (String)router.getTargetSchemaName());
            }
            if (StringUtils.isNotBlank((CharSequence)router.getTargetTableName())) {
                tableName = router.getTargetTableName();
            }
            ArrayList<Table> tablesToLookup = new ArrayList<Table>();
            Map<String, List<TransformTable>> byTableExtractTransforms = SnapshotUtil.getByTableTransforms(engine.getTransformService(), extractTransformMap, router.getNodeGroupLink(), TransformPoint.EXTRACT);
            List<TransformTable> extractTransforms = byTableExtractTransforms.get(tableKey = Table.getFullyQualifiedTableName((String)catalog, (String)schema, (String)tableName).toLowerCase());
            if (extractTransforms != null && extractTransforms.size() > 0) {
                for (TransformTable transform : extractTransforms) {
                    tablesToLookup.add(new Table(transform.getTargetCatalogName(), transform.getTargetSchemaName(), transform.getTargetTableName()));
                }
            }
            if (tablesToLookup.size() == 0) {
                tablesToLookup.add(new Table(catalog, schema, tableName));
            }
            Map<String, List<TransformTable>> byTableLoadTransforms = SnapshotUtil.getByTableTransforms(engine.getTransformService(), loadTransformMap, router.getNodeGroupLink(), TransformPoint.LOAD);
            ListIterator<Table> iterator = tablesToLookup.listIterator();
            while (iterator.hasNext()) {
                Table table = (Table)iterator.next();
                List<TransformTable> loadTransforms = byTableLoadTransforms.get(table.getFullyQualifiedTableName().toLowerCase());
                if (loadTransforms == null || loadTransforms.size() <= 0) continue;
                iterator.remove();
                for (TransformTable transform : loadTransforms) {
                    iterator.add(new Table(transform.getTargetCatalogName(), transform.getTargetSchemaName(), transform.getTargetTableName()));
                }
            }
            for (Table table : tablesToLookup) {
                if ((table = targetPlatform.getTableFromCache(table.getCatalog(), table.getSchema(), table.getName(), false)) == null) continue;
                SnapshotUtil.addTableToMap(catalogSchemas, new CatalogSchema(table.getCatalog(), table.getSchema()), table);
            }
            if (System.currentTimeMillis() - ts <= timeoutMillis) continue;
            log.info("Reached time limit for load table definitions");
            break;
        }
    }

    private static void addTableToMap(HashMap<CatalogSchema, List<Table>> catalogSchemas, CatalogSchema catalogSchema, Table table) {
        List<Table> tables = catalogSchemas.get(catalogSchema);
        if (tables == null) {
            tables = new ArrayList<Table>();
            catalogSchemas.put(catalogSchema, tables);
        }
        if (!tables.contains(table)) {
            tables.add(table);
        }
    }

    protected static Map<String, List<TransformTable>> getByTableTransforms(ITransformService transformService, Map<NodeGroupLink, Map<String, List<TransformTable>>> transformMap, NodeGroupLink nodeGroupLink, TransformPoint transformPoint) {
        Map<String, List<TransformTable>> byTableTransforms = transformMap.get(nodeGroupLink);
        if (byTableTransforms == null) {
            List transforms = transformService.findTransformsFor(nodeGroupLink, transformPoint);
            byTableTransforms = SnapshotUtil.toMap(transforms);
            transformMap.put(nodeGroupLink, byTableTransforms);
        }
        return byTableTransforms;
    }

    protected static Map<String, List<TransformTable>> toMap(List<TransformService.TransformTableNodeGroupLink> transforms) {
        HashMap<String, List<TransformTable>> transformsByTable = new HashMap<String, List<TransformTable>>();
        if (transforms != null) {
            for (TransformTable transformTable : transforms) {
                String sourceTableName = transformTable.getFullyQualifiedSourceTableName().toLowerCase();
                ArrayList<TransformTable> tables = (ArrayList<TransformTable>)transformsByTable.get(sourceTableName);
                if (tables == null) {
                    tables = new ArrayList<TransformTable>();
                    transformsByTable.put(sourceTableName, tables);
                }
                tables.add(transformTable);
            }
        }
        return transformsByTable;
    }

    static class PrintDirConfig {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Comparator<File> fileComparator = new FileComparator();
        int fileCount;
        int maxCount;
        File excludeDir;

        public PrintDirConfig(int maxCount) {
            this.maxCount = maxCount;
        }

        public PrintDirConfig(int maxCount, File excludeDir) {
            this.maxCount = maxCount;
            this.excludeDir = excludeDir;
        }

        public Comparator<File> getFileComparator() {
            return this.fileComparator;
        }

        public SimpleDateFormat getDateFormat() {
            return this.df;
        }

        public int incrementFileCount() {
            return this.fileCount++;
        }

        public int getFileCount() {
            return this.fileCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        public File getExcludeDir() {
            return this.excludeDir;
        }
    }

    static class FileComparator
    implements Comparator<File> {
        FileComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return o1.getPath().compareToIgnoreCase(o2.getPath());
        }
    }
}

