/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.writer.ProtocolDataWriter;
import org.jumpmind.symmetric.model.BatchAck;
import org.jumpmind.symmetric.transport.http.HttpOutgoingTransport;
import org.jumpmind.symmetric.transport.http.HttpTransportManager;
import org.jumpmind.util.AppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmetricPushClient {
    private static final Logger log = LoggerFactory.getLogger(SymmetricPushClient.class);
    protected String nodeId;
    protected String securityToken;
    protected String syncUrl;
    protected HttpOutgoingTransport transport;
    protected ProtocolDataWriter writer;
    protected Batch batch;

    public SymmetricPushClient(String nodeId, String securityToken, String syncUrl) {
        this.nodeId = nodeId;
        this.securityToken = securityToken;
        this.syncUrl = syncUrl;
        this.batch = new Batch(Batch.BatchType.EXTRACT, -9999L, "default", BinaryEncoding.BASE64, nodeId, null, false);
    }

    public void open() {
        try {
            this.transport = new HttpOutgoingTransport(new HttpTransportManager(), new URL(this.buildUrl()), 30000, 30000, true, 0, -1, null, null, false, -1, false);
            this.writer = new ProtocolDataWriter(this.nodeId, (Writer)this.transport.openWriter(), false, false, false);
            this.writer.start(this.batch);
        }
        catch (Exception ex) {
            throw new IoException(ex);
        }
    }

    public BatchAck close() {
        try {
            this.writer.end(this.batch, false);
            BufferedReader reader = this.transport.readResponse();
            String ackString = reader.readLine();
            String ackExtendedString = reader.readLine();
            log.debug("Reading ack: {}", (Object)ackString);
            log.debug("Reading extend ack: {}", (Object)ackExtendedString);
            List<BatchAck> batchAcks = new HttpTransportManager().readAcknowledgement(ackString, ackExtendedString);
            if (batchAcks.size() > 0) {
                BatchAck batchAck = batchAcks.get(0);
                return batchAck;
            }
            BatchAck batchAck = null;
            return batchAck;
        }
        catch (IOException ex) {
            throw new IoException((Exception)ex);
        }
        finally {
            this.transport.close();
        }
    }

    public void insert(Table table, String[] data) {
        this.writer.start(table);
        this.writer.write(new CsvData(DataEventType.INSERT, data));
        this.writer.end(table);
    }

    public void update(Table table, String[] data, String[] pkData) {
        this.writer.start(table);
        this.writer.write(new CsvData(DataEventType.INSERT, pkData, data));
        this.writer.end(table);
    }

    public void delete(Table table, String[] pkData) {
        this.writer.start(table);
        this.writer.write(new CsvData(DataEventType.DELETE, pkData, null));
        this.writer.end(table);
    }

    protected String buildUrl() {
        StringBuilder sb = new StringBuilder(this.syncUrl);
        sb.append("/push?");
        sb.append("nodeId");
        sb.append("=");
        sb.append(this.nodeId);
        sb.append("&");
        sb.append("securityToken");
        sb.append("=");
        sb.append(this.securityToken);
        sb.append("&");
        sb.append("hostName");
        sb.append("=");
        sb.append(AppUtils.getHostName());
        sb.append("&");
        sb.append("ipAddress");
        sb.append("=");
        sb.append(AppUtils.getIpAddress());
        return sb.toString();
    }
}

