/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.cache;

import java.util.ArrayList;
import java.util.List;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.FileTriggerRouter;
import org.jumpmind.symmetric.service.IFileSyncService;
import org.jumpmind.symmetric.service.IParameterService;

public class FileSyncCache {
    private IParameterService parameterService;
    private IFileSyncService fileSyncService;
    private volatile List<FileTriggerRouter> fileTriggerRoutersCache = new ArrayList<FileTriggerRouter>();
    private volatile long fileTriggerRoutersCacheTime;
    private volatile Object fileSyncCacheLock = new Object();

    public FileSyncCache(ISymmetricEngine engine) {
        this.parameterService = engine.getParameterService();
        this.fileSyncService = engine.getFileSyncService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileTriggerRouter> getFileTriggerRouters(boolean refreshCache) {
        long fileTriggerRouterCacheTimeoutInMs = this.parameterService.getLong("cache.trigger.router.time.ms");
        if (this.fileTriggerRoutersCache == null || refreshCache || System.currentTimeMillis() - this.fileTriggerRoutersCacheTime > fileTriggerRouterCacheTimeoutInMs) {
            Object object = this.fileSyncCacheLock;
            synchronized (object) {
                if (this.fileTriggerRoutersCache == null || refreshCache || System.currentTimeMillis() - this.fileTriggerRoutersCacheTime > fileTriggerRouterCacheTimeoutInMs) {
                    List<FileTriggerRouter> newValues = this.fileSyncService.getFileTriggerRoutersFromDb();
                    this.fileTriggerRoutersCache = newValues;
                    this.fileTriggerRoutersCacheTime = System.currentTimeMillis();
                }
            }
        }
        return this.fileTriggerRoutersCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushFileTriggerRouters() {
        Object object = this.fileSyncCacheLock;
        synchronized (object) {
            this.fileTriggerRoutersCacheTime = 0L;
        }
    }
}

