/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.cache;

import java.util.List;
import java.util.Map;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.data.transform.TransformPoint;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.ITransformService;
import org.jumpmind.symmetric.service.impl.TransformService;

public class TransformCache {
    private IParameterService parameterService;
    private ITransformService transformService;
    private volatile Map<NodeGroupLink, Map<TransformPoint, List<TransformService.TransformTableNodeGroupLink>>> transformsCacheByNodeGroupLinkByTransformPoint;
    private volatile long transformCacheTimeInMs;
    private volatile Object transformCacheLock = new Object();

    public TransformCache(ISymmetricEngine engine) {
        this.parameterService = engine.getParameterService();
        this.transformService = engine.getTransformService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<NodeGroupLink, Map<TransformPoint, List<TransformService.TransformTableNodeGroupLink>>> getTransformsCacheByNodeGroupLinkByTransformPoint() {
        long cacheTimeoutInMs = this.parameterService.getLong("cache.transform.time.ms");
        if (System.currentTimeMillis() - this.transformCacheTimeInMs >= cacheTimeoutInMs || this.transformsCacheByNodeGroupLinkByTransformPoint == null) {
            Object object = this.transformCacheLock;
            synchronized (object) {
                if (System.currentTimeMillis() - this.transformCacheTimeInMs >= cacheTimeoutInMs || this.transformsCacheByNodeGroupLinkByTransformPoint == null) {
                    this.transformsCacheByNodeGroupLinkByTransformPoint = this.transformService.readInCacheIfExpiredFromDb();
                    this.transformCacheTimeInMs = System.currentTimeMillis();
                }
            }
        }
        return this.transformsCacheByNodeGroupLinkByTransformPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushTransformCache() {
        Object object = this.transformCacheLock;
        synchronized (object) {
            this.transformCacheTimeInMs = 0L;
        }
    }
}

