/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.cache.TriggerRouterRoutersCache;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.ITriggerRouterService;

public class TriggerRouterCache {
    private IParameterService parameterService;
    private ITriggerRouterService triggerRouterService;
    private Object triggerRouterCacheLock = new Object();
    private long triggerRoutersCacheTime;
    private List<TriggerRouter> triggerRoutersCache = new ArrayList<TriggerRouter>();
    private long triggerRouterPerChannelCacheTime;
    private Map<String, List<TriggerRouter>> triggerRouterCacheByChannel = new HashMap<String, List<TriggerRouter>>();
    private long triggerRoutersByTriggerHistCacheTime;
    private Map<String, Map<Integer, TriggerRouter>> triggerRoutersByTriggerHist;
    private long triggerRoutersByNodeGroupIdCacheTime;
    private Map<String, TriggerRouterRoutersCache> triggerRoutersByNodeGroupId;
    private Map<String, TriggerRouter> triggerRoutersByIdCache;
    private long triggerRoutersByIdCacheTime;
    private Map<String, Trigger> triggersCache;
    private long triggersCacheTime;
    private Map<String, Router> routersCache;
    private long routersCacheTime;
    private Boolean usingTargetExternalId;
    private long targetExternalIdCacheTime;

    public TriggerRouterCache(ISymmetricEngine engine) {
        this.parameterService = engine.getParameterService();
        this.triggerRouterService = engine.getTriggerRouterService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TriggerRouter> getTriggerRouters(boolean refreshCache) {
        long triggerRouterCacheTimeoutInMs = this.parameterService.getLong("cache.trigger.router.time.ms");
        if (this.triggerRoutersCache == null || refreshCache || System.currentTimeMillis() - this.triggerRoutersCacheTime > triggerRouterCacheTimeoutInMs) {
            Object object = this.triggerRouterCacheLock;
            synchronized (object) {
                if (this.triggerRoutersCache == null || refreshCache || System.currentTimeMillis() - this.triggerRoutersCacheTime > triggerRouterCacheTimeoutInMs) {
                    this.triggerRoutersCache = this.triggerRouterService.getTriggerRoutersFromDatabase();
                    this.triggerRoutersCacheTime = System.currentTimeMillis();
                }
            }
        }
        return this.triggerRoutersCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushTriggerRouters() {
        Object object = this.triggerRouterCacheLock;
        synchronized (object) {
            this.triggerRoutersCacheTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<TriggerRouter>> getTriggerRoutersByChannel(String nodeGroupId, boolean refreshCache) {
        long triggerRouterCacheTimeout = this.parameterService.getLong("cache.trigger.router.time.ms");
        if (this.triggerRouterCacheByChannel == null || refreshCache || System.currentTimeMillis() - this.triggerRouterPerChannelCacheTime > triggerRouterCacheTimeout) {
            Object object = this.triggerRouterCacheLock;
            synchronized (object) {
                if (this.triggerRouterCacheByChannel == null || refreshCache || System.currentTimeMillis() - this.triggerRouterPerChannelCacheTime > triggerRouterCacheTimeout) {
                    this.triggerRouterPerChannelCacheTime = System.currentTimeMillis();
                    this.triggerRouterCacheByChannel = this.triggerRouterService.getTriggerRoutersByChannelFromDatabase(nodeGroupId);
                }
            }
        }
        return this.triggerRouterCacheByChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushTriggerRoutersByChannel() {
        Object object = this.triggerRouterCacheLock;
        synchronized (object) {
            this.triggerRouterPerChannelCacheTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<Integer, TriggerRouter>> getTriggerRoutersByTriggerHist(boolean refreshCache) {
        long cacheTimeoutInMs = this.parameterService.getLong("cache.trigger.router.time.ms");
        if (this.triggerRoutersByTriggerHist == null || refreshCache || System.currentTimeMillis() - this.triggerRoutersByTriggerHistCacheTime > cacheTimeoutInMs) {
            Object object = this.triggerRouterCacheLock;
            synchronized (object) {
                if (this.triggerRoutersByTriggerHist == null || refreshCache || System.currentTimeMillis() - this.triggerRoutersByTriggerHistCacheTime > cacheTimeoutInMs) {
                    this.triggerRoutersByTriggerHistCacheTime = System.currentTimeMillis();
                    HashMap<String, Map<Integer, TriggerRouter>> cache = new HashMap<String, Map<Integer, TriggerRouter>>();
                    Map<String, List<TriggerRouter>> triggerRouters = this.triggerRouterService.getTriggerRoutersForCurrentNode(true);
                    HashMap<String, TriggerHistory> triggerHistoryByTrigger = new HashMap<String, TriggerHistory>();
                    for (TriggerHistory triggerHistory : this.triggerRouterService.getActiveTriggerHistories()) {
                        triggerHistoryByTrigger.put(triggerHistory.getTriggerId(), triggerHistory);
                    }
                    for (List list : triggerRouters.values()) {
                        for (TriggerRouter triggerRouter : list) {
                            TriggerHistory hist;
                            String groupId = triggerRouter.getRouter().getNodeGroupLink().getTargetNodeGroupId();
                            HashMap<Integer, TriggerRouter> map = (HashMap<Integer, TriggerRouter>)cache.get(groupId);
                            if (map == null) {
                                map = new HashMap<Integer, TriggerRouter>();
                                cache.put(groupId, map);
                            }
                            if ((hist = (TriggerHistory)triggerHistoryByTrigger.get(triggerRouter.getTriggerId())) == null) continue;
                            map.put(hist.getTriggerHistoryId(), triggerRouter);
                        }
                    }
                    this.triggerRoutersByTriggerHist = cache;
                }
            }
        }
        return this.triggerRoutersByTriggerHist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushTriggerRoutersByTriggerHist() {
        Object object = this.triggerRouterCacheLock;
        synchronized (object) {
            this.triggerRoutersByTriggerHistCacheTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TriggerRouterRoutersCache> getTriggerRoutersByNodeGroupId(boolean refreshCache) {
        long cacheTimeoutInMs = this.parameterService.getLong("cache.trigger.router.time.ms");
        if (this.triggerRoutersByNodeGroupId == null || refreshCache || System.currentTimeMillis() - this.triggerRoutersByNodeGroupIdCacheTime > cacheTimeoutInMs) {
            Object object = this.triggerRouterCacheLock;
            synchronized (object) {
                if (this.triggerRoutersByNodeGroupId == null || refreshCache || System.currentTimeMillis() - this.triggerRoutersByTriggerHistCacheTime > cacheTimeoutInMs) {
                    this.triggerRoutersByNodeGroupIdCacheTime = System.currentTimeMillis();
                    this.triggerRoutersByNodeGroupId = this.triggerRouterService.getTriggerRoutersCacheByNodeGroupIdFromDatabase();
                }
            }
        }
        return this.triggerRoutersByNodeGroupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushTriggerRoutersByNodeGroupId() {
        Object object = this.triggerRouterCacheLock;
        synchronized (object) {
            this.triggerRoutersByNodeGroupIdCacheTime = 0L;
            this.usingTargetExternalId = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUsingTargetExternalId(boolean refreshCache) {
        long cacheTimeoutInMs = this.parameterService.getLong("cache.trigger.router.time.ms");
        if (this.usingTargetExternalId == null || refreshCache || System.currentTimeMillis() - this.targetExternalIdCacheTime > cacheTimeoutInMs) {
            Object object = this.triggerRouterCacheLock;
            synchronized (object) {
                this.usingTargetExternalId = false;
                TriggerRouterRoutersCache cache = this.getTriggerRoutersByNodeGroupId(false).get(this.parameterService.getNodeGroupId());
                if (cache != null) {
                    block3: for (List<TriggerRouter> list : cache.triggerRoutersByTriggerId.values()) {
                        for (TriggerRouter triggerRouter : list) {
                            if (!triggerRouter.getTrigger().getSourceTableName().contains("$(targetExternalId)")) continue;
                            this.usingTargetExternalId = true;
                            continue block3;
                        }
                    }
                }
                this.targetExternalIdCacheTime = System.currentTimeMillis();
            }
        }
        return this.usingTargetExternalId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TriggerRouter> getTriggerRoutersById(boolean refreshCache) {
        long cacheTimeoutInMs = this.parameterService.getLong("cache.trigger.router.time.ms");
        if (this.triggerRoutersByIdCache == null || refreshCache || System.currentTimeMillis() - this.triggerRoutersByIdCacheTime > cacheTimeoutInMs) {
            Object object = this.triggerRouterCacheLock;
            synchronized (object) {
                if (this.triggerRoutersByIdCache == null || refreshCache || System.currentTimeMillis() - this.triggerRoutersByIdCacheTime > cacheTimeoutInMs) {
                    HashMap<String, TriggerRouter> map = new HashMap<String, TriggerRouter>();
                    for (TriggerRouter triggerRouter : this.triggerRouterService.getTriggerRoutersFromDatabase()) {
                        map.put(triggerRouter.getIdentifier(), triggerRouter);
                    }
                    this.triggerRoutersByIdCache = map;
                    this.triggerRoutersByIdCacheTime = System.currentTimeMillis();
                }
            }
        }
        return this.triggerRoutersByIdCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushTriggerRoutersById() {
        Object object = this.triggerRouterCacheLock;
        synchronized (object) {
            this.triggerRoutersByIdCacheTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Trigger> getTriggers(boolean refreshCache) {
        long triggerCacheTimeoutInMs = this.parameterService.getLong("cache.trigger.router.time.ms");
        if (this.triggersCache == null || refreshCache || System.currentTimeMillis() - this.triggersCacheTime > triggerCacheTimeoutInMs) {
            Object object = this.triggerRouterCacheLock;
            synchronized (object) {
                if (this.triggersCache == null || refreshCache || System.currentTimeMillis() - this.triggersCacheTime > triggerCacheTimeoutInMs) {
                    this.triggersCacheTime = System.currentTimeMillis();
                    ArrayList<Trigger> triggers = new ArrayList<Trigger>(this.triggerRouterService.getTriggers());
                    triggers.addAll(this.triggerRouterService.buildTriggersForSymmetricTables(Version.version(), new String[0]));
                    HashMap<String, Trigger> cache = new HashMap<String, Trigger>(triggers.size());
                    for (Trigger t : triggers) {
                        cache.put(t.getTriggerId(), t);
                    }
                    this.triggersCache = cache;
                }
            }
        }
        return this.triggersCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushTriggers() {
        Object object = this.triggerRouterCacheLock;
        synchronized (object) {
            this.triggersCacheTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Router> getRouters(boolean refreshCache) {
        long routerCacheTimeoutInMs = this.parameterService.getLong("cache.trigger.router.time.ms");
        if (this.routersCache == null || refreshCache || System.currentTimeMillis() - this.routersCacheTime > routerCacheTimeoutInMs) {
            Object object = this.triggerRouterCacheLock;
            synchronized (object) {
                if (this.routersCache == null || refreshCache || System.currentTimeMillis() - this.routersCacheTime > routerCacheTimeoutInMs) {
                    this.routersCacheTime = System.currentTimeMillis();
                    List<Router> routers = this.triggerRouterService.getRouters();
                    HashMap<String, Router> cache = new HashMap<String, Router>(routers.size());
                    for (Router router : routers) {
                        cache.put(router.getRouterId(), router);
                    }
                    this.routersCache = cache;
                }
            }
        }
        return this.routersCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushRouters() {
        Object object = this.triggerRouterCacheLock;
        synchronized (object) {
            this.routersCacheTime = 0L;
        }
    }
}

