/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.common;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.common.MonitorConstants;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.model.Node;

public class ConfigurationVersionHelper {
    protected String tablePrefix;
    protected Set<String> proTables;
    protected Map<String, String> tablesByVersion;
    protected boolean isTargetNodePro;
    protected String targetNodeVersion;
    protected Map<String, String> monitorTypesByVersion;

    public ConfigurationVersionHelper(String tablePrefix) {
        this.tablePrefix = tablePrefix;
        this.proTables = TableConstants.getTablesForConsole(tablePrefix);
        this.tablesByVersion = TableConstants.getConfigTablesByVersion(tablePrefix);
        this.monitorTypesByVersion = MonitorConstants.getMonitorTypesByVersion();
    }

    public ConfigurationVersionHelper(String tablePrefix, Node targetNode) {
        this(tablePrefix);
        this.setTargetNode(targetNode);
    }

    public boolean shouldSendTable(String tableName) {
        if (!this.isTargetNodePro && this.proTables.contains(tableName)) {
            return false;
        }
        String tableVersion = this.tablesByVersion.get(tableName);
        return tableVersion == null || !Version.isOlderThanVersion(this.targetNodeVersion, tableVersion);
    }

    public Set<Node> filterNodes(Set<Node> nodes, String tableName, Map<String, String> columnValues) {
        boolean isProTable = this.proTables.contains(tableName);
        String tableVersion = this.tablesByVersion.get(tableName);
        boolean isMonitor = tableName.equalsIgnoreCase(TableConstants.getTableName(this.tablePrefix, "monitor"));
        if (isProTable || tableVersion != null || isMonitor) {
            HashSet<Node> targetNodes = new HashSet<Node>(nodes.size());
            for (Node node : nodes) {
                this.setTargetNode(node);
                if (isProTable && !this.isTargetNodePro || tableVersion != null && Version.isOlderThanVersion(this.targetNodeVersion, tableVersion) || isMonitor && this.isNodeOlderThanMonitor(columnValues)) continue;
                targetNodes.add(node);
            }
            return targetNodes;
        }
        return nodes;
    }

    protected boolean isNodeOlderThanMonitor(Map<String, String> columnValues) {
        String monitorType = columnValues == null ? null : columnValues.get("TYPE");
        String monitorVersion = this.monitorTypesByVersion.get(monitorType);
        if (monitorVersion == null) {
            return false;
        }
        return Version.isOlderThanVersion(this.targetNodeVersion, monitorVersion);
    }

    public void setTargetNode(Node targetNode) {
        this.targetNodeVersion = targetNode.getSymmetricVersion();
        this.isTargetNodePro = StringUtils.equals((CharSequence)targetNode.getDeploymentType(), (CharSequence)"professional");
    }
}

