/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTriggerTemplate {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final String ORIG_TABLE_ALIAS = "orig";
    static final String INSERT_TRIGGER_TEMPLATE = "insertTriggerTemplate";
    static final String UPDATE_TRIGGER_TEMPLATE = "updateTriggerTemplate";
    static final String INSERT_WITH_RELOAD_TRIGGER_TEMPLATE = "insertReloadTriggerTemplate";
    static final String UPDATE_WITH_RELOAD_TRIGGER_TEMPLATE = "updateReloadTriggerTemplate";
    static final String DELETE_TRIGGER_TEMPLATE = "deleteTriggerTemplate";
    static final String INITIAL_LOAD_SQL_TEMPLATE = "initialLoadSqlTemplate";
    protected Map<String, String> sqlTemplates;
    protected String emptyColumnTemplate = "''";
    protected String stringColumnTemplate;
    protected String xmlColumnTemplate;
    protected String arrayColumnTemplate;
    protected String numberColumnTemplate;
    protected String moneyColumnTemplate;
    protected String datetimeColumnTemplate;
    protected String timeColumnTemplate;
    protected String dateColumnTemplate;
    protected String dateTimeWithTimeZoneColumnTemplate;
    protected String dateTimeWithLocalTimeZoneColumnTemplate;
    protected String geometryColumnTemplate;
    protected String geographyColumnTemplate;
    protected String clobColumnTemplate;
    protected String blobColumnTemplate;
    protected String longColumnTemplate;
    protected String binaryColumnTemplate;
    protected String imageColumnTemplate;
    protected String wrappedBlobColumnTemplate;
    protected String booleanColumnTemplate;
    protected String triggerConcatCharacter;
    protected String newTriggerValue;
    protected String oldTriggerValue;
    protected String oldColumnPrefix = "";
    protected String newColumnPrefix = "";
    protected String otherColumnTemplate;
    protected ISymmetricDialect symmetricDialect;
    protected int hashedValue = 0;

    protected AbstractTriggerTemplate(ISymmetricDialect symmetricDialect) {
        this.symmetricDialect = symmetricDialect;
    }

    public boolean useTriggerTemplateForColumnTemplatesDuringInitialLoad() {
        return this.symmetricDialect.getParameterService().is("initial.load.use.column.templates.enabled");
    }

    protected boolean useTriggerTemplateForColumnTemplatesDuringInitialLoad(Column column) {
        if (!this.useTriggerTemplateForColumnTemplatesDuringInitialLoad() && column != null) {
            int mappedType = column.getMappedTypeCode();
            if (mappedType == -101 || mappedType == -102 || mappedType == -103) {
                return true;
            }
            String typeName = column.getJdbcTypeName();
            if (typeName != null && (typeName.equalsIgnoreCase("unichar") || typeName.equalsIgnoreCase("univarchar") || typeName.equalsIgnoreCase("unitext"))) {
                return true;
            }
            int type = column.getJdbcTypeCode();
            if (type == 1 || type == -15 || type == 12 || type == -9 || type == -1 || type == -16 || type == 2005 || type == -6 || type == 5 || type == 4 || type == -5 || type == 2 || type == -2 || type == -3 || type == 2004 && !this.requiresWrappedBlobTemplateForBlobType() || type == -4 || type == 3 || type == 6 || type == 8 || type == 7 || type == -10 || type == 91 || type == 92 || type == 93 || type == -7 || type == 16) {
                return false;
            }
        }
        return true;
    }

    public String createInitalLoadSql(Node node, TriggerRouter triggerRouter, Table originalTable, TriggerHistory triggerHistory, Channel channel, String overrideSelectSql) {
        String initialLoadSelect;
        IParameterService parameterService = this.symmetricDialect.getParameterService();
        boolean dateTimeAsString = parameterService.is("db.treat.date.time.as.varchar.enabled");
        boolean concatInCsv = parameterService.is("initial.load.concat.csv.in.sql.enabled");
        Table table = originalTable.copyAndFilterColumns(triggerHistory.getParsedColumnNames(), triggerHistory.getParsedPkColumnNames(), true, false);
        Column[] columns = table.getColumns();
        String textColumnExpression = parameterService.getString("dataextractor.text.column.expression");
        String sql = null;
        String tableAlias = this.symmetricDialect.getInitialLoadTableAlias();
        if (concatInCsv) {
            sql = this.sqlTemplates.get(INITIAL_LOAD_SQL_TEMPLATE);
            String columnsText = this.buildColumnsString((String)tableAlias, (String)tableAlias, (String)"", (Table)table, (Column[])columns, (DataEventType)DataEventType.INSERT, (boolean)false, (Channel)channel, (Trigger)triggerRouter.getTrigger()).columnString;
            if (StringUtils.isNotBlank((CharSequence)textColumnExpression)) {
                columnsText = textColumnExpression.replace("$(columnName)", columnsText);
            }
            sql = FormatUtils.replace((String)"columns", (String)columnsText, (String)sql);
        } else {
            sql = "select $(columns) from $(schemaName)$(tableName) t where $(whereClause)";
            StringBuilder columnList = new StringBuilder();
            for (int i = 0; i < columns.length; ++i) {
                Column column = columns[i];
                if (column == null) continue;
                if (i > 0) {
                    columnList.append(",");
                }
                String columnExpression = null;
                if (this.useTriggerTemplateForColumnTemplatesDuringInitialLoad(column) && !this.isUniTextColumn(column)) {
                    ColumnString columnString = this.fillOutColumnTemplate(tableAlias, tableAlias, "", table, column, DataEventType.INSERT, false, channel, triggerRouter.getTrigger(), true);
                    columnExpression = columnString.columnString;
                    if (StringUtils.isNotBlank((CharSequence)textColumnExpression) && TypeMap.isTextType((int)column.getMappedTypeCode())) {
                        columnExpression = textColumnExpression.replace("$(columnName)", columnExpression);
                    }
                } else {
                    columnExpression = SymmetricUtils.quote(this.symmetricDialect, column.getName());
                    if (dateTimeAsString && TypeMap.isDateTimeType((int)column.getMappedTypeCode())) {
                        columnExpression = this.castDatetimeColumnToString(column.getName());
                    } else if (StringUtils.isNotBlank((CharSequence)textColumnExpression) && TypeMap.isTextType((int)column.getMappedTypeCode())) {
                        columnExpression = textColumnExpression.replace("$(columnName)", columnExpression);
                    }
                }
                columnList.append(columnExpression).append(" as ").append("x__").append(i);
            }
            sql = FormatUtils.replace((String)"columns", (String)columnList.toString(), (String)sql);
        }
        String string = initialLoadSelect = StringUtils.isBlank((CharSequence)triggerRouter.getInitialLoadSelect()) ? "1=1" : triggerRouter.getInitialLoadSelect();
        if (StringUtils.isNotBlank((CharSequence)overrideSelectSql)) {
            initialLoadSelect = overrideSelectSql;
        }
        sql = FormatUtils.replace((String)"whereClause", (String)initialLoadSelect, (String)sql);
        sql = FormatUtils.replace((String)"tableName", (String)SymmetricUtils.quote(this.symmetricDialect, table.getName()), (String)sql);
        sql = FormatUtils.replace((String)"schemaName", (String)this.getSourceTablePrefix(triggerHistory), (String)sql);
        sql = FormatUtils.replace((String)"schemaNameOnly", (String)this.getSchemaNameOnly(triggerHistory), (String)sql);
        sql = FormatUtils.replace((String)"primaryKeyWhereString", (String)this.getPrimaryKeyWhereString(this.symmetricDialect.getInitialLoadTableAlias(), table.hasPrimaryKey() ? table.getPrimaryKeyColumns() : table.getColumns()), (String)sql);
        sql = FormatUtils.replace((String)"groupId", (String)node.getNodeGroupId(), (String)sql);
        sql = FormatUtils.replace((String)"externalId", (String)node.getExternalId(), (String)sql);
        sql = FormatUtils.replace((String)"nodeId", (String)node.getNodeId(), (String)sql);
        sql = this.replaceDefaultSchemaAndCatalog(sql);
        sql = FormatUtils.replace((String)"prefixName", (String)this.symmetricDialect.getTablePrefix(), (String)sql);
        sql = FormatUtils.replace((String)"oracleToClob", (String)(triggerRouter.getTrigger().isUseCaptureLobs() ? this.toClobExpression(table) : ""), (String)sql);
        sql = this.replaceOracleQueryHint(sql);
        return sql;
    }

    public boolean isUniTextColumn(Column column) {
        return column.getJdbcTypeName() == null ? false : column.getJdbcTypeName().equalsIgnoreCase("unitext");
    }

    public boolean[] getColumnPositionUsingTemplate(Table originalTable, TriggerHistory triggerHistory) {
        IParameterService parameterService = this.symmetricDialect.getParameterService();
        boolean concatInCsv = parameterService.is("initial.load.concat.csv.in.sql.enabled");
        Table table = originalTable.copyAndFilterColumns(triggerHistory.getParsedColumnNames(), triggerHistory.getParsedPkColumnNames(), true, false);
        Column[] columns = table.getColumns();
        boolean[] isColumnPositionUsingTemplate = new boolean[columns.length];
        if (!concatInCsv) {
            for (int i = 0; i < columns.length; ++i) {
                isColumnPositionUsingTemplate[i] = this.useTriggerTemplateForColumnTemplatesDuringInitialLoad(columns[i]);
            }
        }
        return isColumnPositionUsingTemplate;
    }

    protected String castDatetimeColumnToString(String columnName) {
        return SymmetricUtils.quote(this.symmetricDialect, columnName);
    }

    protected String getSourceTablePrefix(Table table) {
        Object prefix = StringUtils.isNotBlank((CharSequence)table.getSchema()) ? table.getSchema() + this.symmetricDialect.getPlatform().getDatabaseInfo().getSchemaSeparator() : "";
        prefix = (String)(StringUtils.isNotBlank((CharSequence)table.getCatalog()) ? table.getCatalog() + this.symmetricDialect.getPlatform().getDatabaseInfo().getCatalogSeparator() : "") + (String)prefix;
        if (StringUtils.isBlank((CharSequence)prefix)) {
            prefix = StringUtils.isNotBlank((CharSequence)this.symmetricDialect.getPlatform().getDefaultSchema()) ? SymmetricUtils.quote(this.symmetricDialect, this.symmetricDialect.getPlatform().getDefaultSchema()) + "." : "";
            prefix = (String)(StringUtils.isNotBlank((CharSequence)this.symmetricDialect.getPlatform().getDefaultCatalog()) ? SymmetricUtils.quote(this.symmetricDialect, this.symmetricDialect.getPlatform().getDefaultCatalog()) + "." : "") + (String)prefix;
        }
        return prefix;
    }

    protected String getSourceTableSchema(Table table) {
        String prefix;
        String string = prefix = StringUtils.isNotBlank((CharSequence)table.getSchema()) ? table.getSchema() : "";
        if (StringUtils.isBlank((CharSequence)prefix)) {
            prefix = StringUtils.isNotBlank((CharSequence)this.symmetricDialect.getPlatform().getDefaultSchema()) ? this.symmetricDialect.getPlatform().getDefaultSchema() : "";
        }
        return prefix;
    }

    protected String getSourceTablePrefix(TriggerHistory triggerHistory) {
        Object prefix = StringUtils.isNotBlank((CharSequence)triggerHistory.getSourceSchemaName()) ? SymmetricUtils.quote(this.symmetricDialect, triggerHistory.getSourceSchemaName()) + this.symmetricDialect.getPlatform().getDatabaseInfo().getSchemaSeparator() : "";
        prefix = (String)(StringUtils.isNotBlank((CharSequence)triggerHistory.getSourceCatalogName()) ? SymmetricUtils.quote(this.symmetricDialect, triggerHistory.getSourceCatalogName()) + this.symmetricDialect.getPlatform().getDatabaseInfo().getCatalogSeparator() : "") + (String)prefix;
        if (StringUtils.isBlank((CharSequence)prefix)) {
            prefix = StringUtils.isNotBlank((CharSequence)this.symmetricDialect.getPlatform().getDefaultSchema()) ? SymmetricUtils.quote(this.symmetricDialect, this.symmetricDialect.getPlatform().getDefaultSchema()) + "." : "";
            prefix = (String)(StringUtils.isNotBlank((CharSequence)this.symmetricDialect.getPlatform().getDefaultCatalog()) ? SymmetricUtils.quote(this.symmetricDialect, this.symmetricDialect.getPlatform().getDefaultCatalog()) + "." : "") + (String)prefix;
        }
        return prefix;
    }

    protected String getSourceTableSchema(TriggerHistory triggerHistory) {
        String prefix;
        String string = prefix = StringUtils.isNotBlank((CharSequence)triggerHistory.getSourceSchemaName()) ? triggerHistory.getSourceSchemaName() : "";
        if (StringUtils.isBlank((CharSequence)prefix)) {
            prefix = StringUtils.isNotBlank((CharSequence)this.symmetricDialect.getPlatform().getDefaultSchema()) ? this.symmetricDialect.getPlatform().getDefaultSchema() : "";
        }
        return prefix;
    }

    protected String getSchemaNameOnly(TriggerHistory triggerHistory) {
        String prefix;
        String string = prefix = StringUtils.isNotBlank((CharSequence)triggerHistory.getSourceSchemaName()) ? SymmetricUtils.quote(this.symmetricDialect, triggerHistory.getSourceSchemaName()) + this.symmetricDialect.getPlatform().getDatabaseInfo().getSchemaSeparator() : "";
        if (StringUtils.isBlank((CharSequence)prefix)) {
            prefix = StringUtils.isNotBlank((CharSequence)this.symmetricDialect.getPlatform().getDefaultSchema()) ? SymmetricUtils.quote(this.symmetricDialect, this.symmetricDialect.getPlatform().getDefaultSchema()) + "." : "";
        }
        return prefix;
    }

    protected String replaceDefaultSchemaAndCatalog(String sql) {
        return this.replaceDefaultSchemaAndCatalog(sql, null, null);
    }

    protected String replaceDefaultSchemaAndCatalog(String sql, String catalog, String schema) {
        String defaultCatalog = catalog != null ? catalog : this.symmetricDialect.getPlatform().getDefaultCatalog();
        String defaultSchema = schema != null ? schema : this.symmetricDialect.getPlatform().getDefaultSchema();
        sql = this.replaceDefaultSchema(sql, defaultSchema);
        sql = this.replaceDefaultCatalog(sql, defaultCatalog);
        return sql;
    }

    public String createCsvDataSql(Trigger trigger, TriggerHistory triggerHistory, Table originalTable, Channel channel, String whereClause) {
        Table table = originalTable.copyAndFilterColumns(triggerHistory.getParsedColumnNames(), triggerHistory.getParsedPkColumnNames(), true, false);
        String sql = this.sqlTemplates.get(INITIAL_LOAD_SQL_TEMPLATE);
        Column[] columns = table.getColumns();
        String columnsText = this.buildColumnsString((String)this.symmetricDialect.getInitialLoadTableAlias(), (String)this.symmetricDialect.getInitialLoadTableAlias(), (String)"", (Table)table, (Column[])columns, (DataEventType)DataEventType.INSERT, (boolean)false, (Channel)channel, (Trigger)trigger).columnString;
        sql = FormatUtils.replace((String)"columns", (String)columnsText, (String)sql);
        sql = FormatUtils.replace((String)"oracleToClob", (String)(trigger.isUseCaptureLobs() ? this.toClobExpression(table) : ""), (String)sql);
        sql = this.replaceOracleQueryHint(sql);
        sql = FormatUtils.replace((String)"tableName", (String)SymmetricUtils.quote(this.symmetricDialect, table.getName()), (String)sql);
        sql = FormatUtils.replace((String)"schemaName", (String)this.getSourceTablePrefix(triggerHistory), (String)sql);
        sql = FormatUtils.replace((String)"schemaNameOnly", (String)this.getSchemaNameOnly(triggerHistory), (String)sql);
        sql = FormatUtils.replace((String)"whereClause", (String)whereClause, (String)sql);
        sql = FormatUtils.replace((String)"primaryKeyWhereString", (String)this.getPrimaryKeyWhereString(this.symmetricDialect.getInitialLoadTableAlias(), table.hasPrimaryKey() ? table.getPrimaryKeyColumns() : table.getColumns()), (String)sql);
        sql = this.replaceOracleQueryHint(sql);
        sql = this.replaceDefaultSchemaAndCatalog(sql);
        return sql;
    }

    public String createCsvPrimaryKeySql(Trigger trigger, TriggerHistory triggerHistory, Table table, Channel channel, String whereClause) {
        String sql = this.sqlTemplates.get(INITIAL_LOAD_SQL_TEMPLATE);
        Column[] columns = table.getPrimaryKeyColumns();
        String columnsText = this.buildColumnsString(this.symmetricDialect.getInitialLoadTableAlias(), this.symmetricDialect.getInitialLoadTableAlias(), "", table, columns, DataEventType.INSERT, false, channel, trigger).toString();
        sql = FormatUtils.replace((String)"columns", (String)columnsText, (String)sql);
        sql = FormatUtils.replace((String)"oracleToClob", (String)(trigger.isUseCaptureLobs() ? this.toClobExpression(table) : ""), (String)sql);
        sql = this.replaceOracleQueryHint(sql);
        sql = FormatUtils.replace((String)"tableName", (String)SymmetricUtils.quote(this.symmetricDialect, table.getName()), (String)sql);
        sql = FormatUtils.replace((String)"schemaName", (String)(triggerHistory == null ? this.getSourceTablePrefix(table) : this.getSourceTablePrefix(triggerHistory)), (String)sql);
        sql = FormatUtils.replace((String)"schemaNameOnly", (String)this.getSchemaNameOnly(triggerHistory), (String)sql);
        sql = FormatUtils.replace((String)"whereClause", (String)whereClause, (String)sql);
        sql = FormatUtils.replace((String)"primaryKeyWhereString", (String)this.getPrimaryKeyWhereString(this.symmetricDialect.getInitialLoadTableAlias(), table.hasPrimaryKey() ? table.getPrimaryKeyColumns() : table.getColumns()), (String)sql);
        return sql;
    }

    public String createTriggerDDL(DataEventType dml, Trigger trigger, TriggerHistory history, Channel channel, String tablePrefix, Table originalTable, String defaultCatalog, String defaultSchema) {
        String reloadDdl;
        Table table = originalTable.copyAndFilterColumns(history.getParsedColumnNames(), history.getParsedPkColumnNames(), true, false);
        String ddl = this.sqlTemplates.get(dml.name().toLowerCase(Locale.US) + "TriggerTemplate");
        if (trigger.isStreamRow() && (reloadDdl = this.sqlTemplates.get(dml.name().toLowerCase(Locale.US) + "ReloadTriggerTemplate")) != null && reloadDdl.length() > 0) {
            ddl = reloadDdl;
        }
        if (ddl == null) {
            throw new NotImplementedException(dml.name() + " trigger is not implemented for " + this.symmetricDialect.getPlatform().getName());
        }
        return this.replaceTemplateVariables(dml, trigger, history, channel, tablePrefix, originalTable, table, defaultCatalog, defaultSchema, ddl);
    }

    public String createPostTriggerDDL(DataEventType dml, Trigger trigger, TriggerHistory history, Channel channel, String tablePrefix, Table originalTable, String defaultCatalog, String defaultSchema) {
        Table table = originalTable.copyAndFilterColumns(history.getParsedColumnNames(), history.getParsedPkColumnNames(), true, false);
        String ddl = this.sqlTemplates.get(dml.name().toLowerCase(Locale.US) + "PostTriggerTemplate");
        return this.replaceTemplateVariables(dml, trigger, history, channel, tablePrefix, originalTable, table, defaultCatalog, defaultSchema, ddl);
    }

    public String createDdlTrigger(String tablePrefix, String defaultCatalog, String defaultSchema, String triggerName) {
        String ddl = this.symmetricDialect.getParameterService().is("trigger.capture.ddl.check.trigger.hist", true) ? this.sqlTemplates.get("filteredDdlTriggerTemplate") : this.sqlTemplates.get("allDdlTriggerTemplate");
        if (ddl == null) {
            return null;
        }
        ddl = FormatUtils.replace((String)"triggerName", (String)triggerName, (String)ddl);
        ddl = FormatUtils.replace((String)"prefixName", (String)tablePrefix, (String)ddl);
        ddl = this.replaceDefaultSchemaAndCatalog(ddl, defaultCatalog, defaultSchema);
        return ddl;
    }

    public String createPostDdlTriggerDDL(String tablePrefix, String triggerName) {
        String ddl = this.sqlTemplates.get("postDdlTriggerTemplate");
        if (ddl == null) {
            return null;
        }
        ddl = FormatUtils.replace((String)"triggerName", (String)triggerName, (String)ddl);
        ddl = FormatUtils.replace((String)"prefixName", (String)tablePrefix, (String)ddl);
        ddl = this.replaceDefaultSchemaAndCatalog(ddl);
        return ddl;
    }

    protected String getDefaultTargetTableName(Trigger trigger, TriggerHistory history) {
        String targetTableName = null;
        targetTableName = history != null ? history.getSourceTableName() : trigger.getSourceTableNameUnescaped();
        return targetTableName;
    }

    protected String replaceTemplateVariables(DataEventType dml, Trigger trigger, TriggerHistory history, Channel channel, String tablePrefix, Table originalTable, Table table, String defaultCatalog, String defaultSchema, String ddl) {
        ddl = trigger.getChannelId().equals("dynamic") && dml.getDmlType() == DmlStatement.DmlType.UPDATE && TableConstants.getTableName(tablePrefix, "file_snapshot").equals(table.getName()) ? FormatUtils.replace((String)"specialSqlServerSybaseChannelExpression", (String)("$(oldTriggerValue).$(oldColumnPrefix)" + this.symmetricDialect.getPlatform().alterCaseToMatchDatabaseDefaultCase("channel_id")), (String)ddl) : FormatUtils.replace((String)"specialSqlServerSybaseChannelExpression", (String)"$(channelExpression)", (String)ddl);
        ddl = FormatUtils.replace((String)"specialSqlServerSybaseChannelExpression", (String)this.getChannelExpression(), (String)ddl);
        ddl = FormatUtils.replace((String)"targetTableName", (String)this.getDefaultTargetTableName(trigger, history), (String)ddl);
        ddl = FormatUtils.replace((String)"triggerName", (String)history.getTriggerNameForDmlType(dml), (String)ddl);
        ddl = FormatUtils.replace((String)"channelName", (String)trigger.getChannelId(), (String)ddl);
        ddl = FormatUtils.replace((String)"triggerHistoryId", (String)Integer.toString(history.getTriggerHistoryId()), (String)ddl);
        String triggerExpression = this.symmetricDialect.getTransactionTriggerExpression(defaultCatalog, defaultSchema, trigger);
        if (this.symmetricDialect.isTransactionIdOverrideSupported() && !StringUtils.isBlank((CharSequence)trigger.getTxIdExpression())) {
            triggerExpression = trigger.getTxIdExpression();
        }
        ddl = FormatUtils.replace((String)"txIdExpression", (String)this.symmetricDialect.preProcessTriggerSqlClause(triggerExpression), (String)ddl);
        ddl = FormatUtils.replace((String)"channelExpression", (String)this.symmetricDialect.preProcessTriggerSqlClause(this.getChannelExpression(trigger, history, originalTable)), (String)ddl);
        ddl = FormatUtils.replace((String)"externalSelectForDelete", (String)(StringUtils.isBlank((CharSequence)trigger.getExternalSelect()) ? "null" : "(" + this.convertExternalSelectToDelete(this.symmetricDialect.preProcessTriggerSqlClause(trigger.getExternalSelect())) + ")"), (String)ddl);
        ddl = FormatUtils.replace((String)"externalSelectForInsert", (String)(StringUtils.isBlank((CharSequence)trigger.getExternalSelect()) ? "null" : "(" + this.convertExternalSelectToInsert(this.symmetricDialect.preProcessTriggerSqlClause(trigger.getExternalSelect())) + ")"), (String)ddl);
        ddl = FormatUtils.replace((String)"externalSelect", (String)(StringUtils.isBlank((CharSequence)trigger.getExternalSelect()) ? "null" : "(" + this.symmetricDialect.preProcessTriggerSqlClause(trigger.getExternalSelect()) + ")"), (String)ddl);
        ddl = FormatUtils.replace((String)"syncOnInsertCondition", (String)this.symmetricDialect.preProcessTriggerSqlClause(trigger.getSyncOnInsertCondition()), (String)ddl);
        ddl = FormatUtils.replace((String)"syncOnUpdateCondition", (String)this.symmetricDialect.preProcessTriggerSqlClause(trigger.getSyncOnUpdateCondition()), (String)ddl);
        ddl = FormatUtils.replace((String)"syncOnDeleteCondition", (String)this.symmetricDialect.preProcessTriggerSqlClause(trigger.getSyncOnDeleteCondition()), (String)ddl);
        ddl = FormatUtils.replace((String)"custom_before_insert_text", (String)(StringUtils.isBlank((CharSequence)trigger.getCustomBeforeInsertText()) ? "" : trigger.getCustomBeforeInsertText()), (String)ddl);
        ddl = FormatUtils.replace((String)"custom_before_update_text", (String)(StringUtils.isBlank((CharSequence)trigger.getCustomBeforeUpdateText()) ? "" : trigger.getCustomBeforeUpdateText()), (String)ddl);
        ddl = FormatUtils.replace((String)"custom_before_delete_text", (String)(StringUtils.isBlank((CharSequence)trigger.getCustomBeforeDeleteText()) ? "" : trigger.getCustomBeforeDeleteText()), (String)ddl);
        ddl = FormatUtils.replace((String)"custom_on_insert_text", (String)(StringUtils.isBlank((CharSequence)trigger.getCustomOnInsertText()) ? "" : trigger.getCustomOnInsertText()), (String)ddl);
        ddl = FormatUtils.replace((String)"custom_on_update_text", (String)(StringUtils.isBlank((CharSequence)trigger.getCustomOnUpdateText()) ? "" : trigger.getCustomOnUpdateText()), (String)ddl);
        ddl = FormatUtils.replace((String)"custom_on_delete_text", (String)(StringUtils.isBlank((CharSequence)trigger.getCustomOnDeleteText()) ? "" : trigger.getCustomOnDeleteText()), (String)ddl);
        ddl = FormatUtils.replace((String)"dataHasChangedCondition", (String)this.symmetricDialect.preProcessTriggerSqlClause(this.symmetricDialect.getDataHasChangedCondition(trigger)), (String)ddl);
        Trigger clonedTrigger = new Trigger();
        clonedTrigger.setUseCaptureLobs(true);
        ddl = FormatUtils.replace((String)"dataHasChangedConditionClobAlways", (String)this.symmetricDialect.preProcessTriggerSqlClause(this.symmetricDialect.getDataHasChangedCondition(clonedTrigger)), (String)ddl);
        ddl = FormatUtils.replace((String)"sourceNodeExpression", (String)this.symmetricDialect.getSourceNodeExpression(), (String)ddl);
        ddl = FormatUtils.replace((String)"oracleLobType", (String)(trigger.isUseCaptureLobs() ? this.getClobType(table) : (this.symmetricDialect.getParameterService().is("oracle.use.ntypes.for.sync") ? "NVARCHAR2(4000)" : "VARCHAR2(4000)")), (String)ddl);
        ddl = FormatUtils.replace((String)"oracleLobTypeClobAlways", (String)this.getClobType(table), (String)ddl);
        String syncTriggersExpression = this.symmetricDialect.getSyncTriggersExpression();
        ddl = FormatUtils.replace((String)"syncOnIncomingBatchCondition", (String)(trigger.isSyncOnIncomingBatch() ? this.symmetricDialect.getSyncTriggersOnIncomingExpression() : syncTriggersExpression), (String)ddl);
        ddl = FormatUtils.replace((String)"origTableAlias", (String)ORIG_TABLE_ALIAS, (String)ddl);
        Column[] orderedColumns = table.getColumns();
        ColumnString columnString = this.buildColumnsString(ORIG_TABLE_ALIAS, this.newTriggerValue, this.newColumnPrefix, table, orderedColumns, dml, false, channel, trigger);
        ddl = FormatUtils.replace((String)"columns", (String)columnString.toString(), (String)ddl);
        Channel clonedChannel = new Channel();
        clonedChannel.setContainsBigLob(true);
        ColumnString columnClobAlways = this.buildColumnsString(ORIG_TABLE_ALIAS, this.newTriggerValue, this.newColumnPrefix, table, orderedColumns, dml, false, clonedChannel, trigger);
        String columnClobAlwaysString = FormatUtils.replace((String)"oracleToClob", (String)this.toClobExpression(table), (String)columnClobAlways.toString());
        ddl = FormatUtils.replace((String)"columnsClobAlways", (String)columnClobAlwaysString, (String)ddl);
        ColumnString oldColumnsClobAlways = this.buildColumnsString(ORIG_TABLE_ALIAS, this.oldTriggerValue, this.oldColumnPrefix, table, orderedColumns, dml, true, clonedChannel, trigger);
        String oldColumnsClobAlwaysString = FormatUtils.replace((String)"oracleToClob", (String)this.toClobExpression(table), (String)oldColumnsClobAlways.toString());
        ddl = FormatUtils.replace((String)"oldColumnsClobAlways", (String)(trigger.isUseCaptureOldData() ? oldColumnsClobAlwaysString : "null"), (String)ddl);
        ddl = this.replaceDefaultSchemaAndCatalog(ddl);
        ddl = FormatUtils.replace((String)"virtualOldNewTable", (String)this.buildVirtualTableSql(this.oldColumnPrefix, this.newColumnPrefix, originalTable.getColumns()), (String)ddl);
        ddl = FormatUtils.replace((String)"oldColumns", (String)(trigger.isUseCaptureOldData() ? this.buildColumnsString(ORIG_TABLE_ALIAS, this.oldTriggerValue, this.oldColumnPrefix, table, orderedColumns, dml, true, channel, trigger).toString() : "null"), (String)ddl);
        String oldddl = null;
        oldddl = null;
        while (ddl != null && !ddl.equals(oldddl)) {
            oldddl = ddl;
            ddl = this.eval(columnString.isBlobClob && !trigger.isUseStreamLobs(), "containsBlobClobColumns", ddl);
        }
        oldddl = null;
        ddl = FormatUtils.replace((String)"tableName", (String)SymmetricUtils.quote(this.symmetricDialect, table.getName()), (String)ddl);
        ddl = FormatUtils.replace((String)"schemaName", (String)this.getSourceTablePrefix(history), (String)ddl);
        ddl = FormatUtils.replace((String)"schemaNameOnly", (String)this.getSchemaNameOnly(history), (String)ddl);
        Column[] primaryKeyColumns = table.getPrimaryKeyColumns();
        ddl = FormatUtils.replace((String)"oldKeys", (String)this.buildColumnsString(ORIG_TABLE_ALIAS, this.oldTriggerValue, this.oldColumnPrefix, table, primaryKeyColumns, dml, true, channel, trigger).toString(), (String)ddl);
        ddl = FormatUtils.replace((String)"newKeys", (String)this.buildColumnsString(ORIG_TABLE_ALIAS, this.newTriggerValue, this.newColumnPrefix, table, primaryKeyColumns, dml, true, channel, trigger).toString(), (String)ddl);
        ddl = FormatUtils.replace((String)"oldNewPrimaryKeyJoin", (String)this.aliasedPrimaryKeyJoin(this.oldTriggerValue, this.newTriggerValue, primaryKeyColumns.length == 0 ? orderedColumns : primaryKeyColumns), (String)ddl);
        ddl = FormatUtils.replace((String)"tableNewPrimaryKeyJoin", (String)this.aliasedPrimaryKeyJoin(ORIG_TABLE_ALIAS, this.newTriggerValue, primaryKeyColumns.length == 0 ? orderedColumns : primaryKeyColumns), (String)ddl);
        ddl = FormatUtils.replace((String)"tableNewPrimaryKeyJoinByTableName", (String)this.aliasedPrimaryKeyJoin(SymmetricUtils.quote(this.symmetricDialect, table.getName()), this.newTriggerValue, primaryKeyColumns.length == 0 ? orderedColumns : primaryKeyColumns), (String)ddl);
        ddl = FormatUtils.replace((String)"primaryKeyWhereString", (String)this.getPrimaryKeyWhereString(dml == DataEventType.DELETE ? this.oldTriggerValue : this.newTriggerValue, table.hasPrimaryKey() ? table.getPrimaryKeyColumns() : table.getColumns()), (String)ddl);
        String builtString = this.buildColumnNameString(this.oldTriggerValue, true, trigger, primaryKeyColumns);
        ddl = FormatUtils.replace((String)"oldKeyNames", (String)(StringUtils.isNotBlank((CharSequence)builtString) ? "," + builtString : ""), (String)ddl);
        builtString = this.buildColumnNameString(this.newTriggerValue, true, trigger, primaryKeyColumns);
        ddl = FormatUtils.replace((String)"newKeyNames", (String)(StringUtils.isNotBlank((CharSequence)builtString) ? "," + builtString : ""), (String)ddl);
        ddl = FormatUtils.replace((String)"columnNames", (String)this.buildColumnNameString(null, false, trigger, orderedColumns), (String)ddl);
        ddl = FormatUtils.replace((String)"pkColumnNames", (String)this.buildColumnNameString(null, false, trigger, primaryKeyColumns), (String)ddl);
        builtString = this.buildKeyVariablesString(primaryKeyColumns, "old");
        ddl = FormatUtils.replace((String)"oldKeyVariables", (String)(StringUtils.isNotBlank((CharSequence)builtString) ? "," + builtString : ""), (String)ddl);
        builtString = this.buildKeyVariablesString(primaryKeyColumns, "new");
        ddl = FormatUtils.replace((String)"newKeyVariables", (String)(StringUtils.isNotBlank((CharSequence)builtString) ? "," + builtString : ""), (String)ddl);
        ddl = FormatUtils.replace((String)"varNewPrimaryKeyJoin", (String)this.aliasedPrimaryKeyJoinVar(this.newTriggerValue, "new", primaryKeyColumns), (String)ddl);
        ddl = FormatUtils.replace((String)"varOldPrimaryKeyJoin", (String)this.aliasedPrimaryKeyJoinVar(this.oldTriggerValue, "old", primaryKeyColumns), (String)ddl);
        ddl = FormatUtils.replace((String)"newTriggerValue", (String)this.newTriggerValue, (String)ddl);
        ddl = FormatUtils.replace((String)"oldTriggerValue", (String)this.oldTriggerValue, (String)ddl);
        ddl = FormatUtils.replace((String)"newColumnPrefix", (String)this.newColumnPrefix, (String)ddl);
        ddl = FormatUtils.replace((String)"oldColumnPrefix", (String)this.oldColumnPrefix, (String)ddl);
        ddl = FormatUtils.replace((String)"prefixName", (String)tablePrefix, (String)ddl);
        ddl = this.replaceDefaultSchemaAndCatalog(ddl);
        ddl = FormatUtils.replace((String)"hasPrimaryKeysDefined", (String)this.getHasPrimaryKeysDefinedString(table), (String)ddl);
        ddl = FormatUtils.replace((String)"primaryKeysUpdated", (String)this.getPrimaryKeysUpdatedString(table), (String)ddl);
        ddl = FormatUtils.replace((String)"oracleToClob", (String)(trigger.isUseCaptureLobs() ? this.toClobExpression(table) : ""), (String)ddl);
        ddl = FormatUtils.replace((String)"oracleToClobAlways", (String)this.toClobExpression(table), (String)ddl);
        switch (dml) {
            case DELETE: {
                ddl = FormatUtils.replace((String)"curTriggerValue", (String)this.oldTriggerValue, (String)ddl);
                ddl = FormatUtils.replace((String)"curColumnPrefix", (String)this.oldColumnPrefix, (String)ddl);
                break;
            }
            default: {
                ddl = FormatUtils.replace((String)"curTriggerValue", (String)this.newTriggerValue, (String)ddl);
                ddl = FormatUtils.replace((String)"curColumnPrefix", (String)this.newColumnPrefix, (String)ddl);
            }
        }
        return ddl;
    }

    private String convertExternalSelectToDelete(String externalSelect) {
        externalSelect = FormatUtils.replace((String)"curTriggerValue", (String)this.oldTriggerValue, (String)externalSelect);
        externalSelect = FormatUtils.replace((String)"curColumnPrefix", (String)this.oldColumnPrefix, (String)externalSelect);
        return externalSelect;
    }

    private String convertExternalSelectToInsert(String externalSelect) {
        externalSelect = FormatUtils.replace((String)"curTriggerValue", (String)this.newTriggerValue, (String)externalSelect);
        externalSelect = FormatUtils.replace((String)"curColumnPrefix", (String)this.newColumnPrefix, (String)externalSelect);
        return externalSelect;
    }

    private String getChannelExpression() {
        return null;
    }

    protected String toClobExpression(Table table) {
        if (this.symmetricDialect.getParameterService().is("oracle.use.ntypes.for.sync")) {
            return "to_nclob('')||";
        }
        return "to_clob('')||";
    }

    protected String getClobType(Table table) {
        return this.symmetricDialect.getParameterService().is("oracle.use.ntypes.for.sync") ? "nclob" : "clob";
    }

    protected String getChannelExpression(Trigger trigger, TriggerHistory history, Table originalTable) {
        if (trigger.getChannelId().equals("dynamic")) {
            if (StringUtils.isNotBlank((CharSequence)trigger.getChannelExpression())) {
                String expr = trigger.getChannelExpression();
                expr = FormatUtils.replace((String)"schemaName", (String)(history == null ? this.getSourceTableSchema(originalTable) : this.getSourceTableSchema(history)), (String)expr);
                return expr;
            }
            throw new IllegalStateException("When the channel is set to 'dynamic', a channel expression must be provided.");
        }
        return "'" + trigger.getChannelId() + "'";
    }

    protected String buildVirtualTableSql(String oldTriggerValue, String newTriggerValue, Column[] columns) {
        String column;
        if (oldTriggerValue.indexOf(".") >= 0) {
            oldTriggerValue = oldTriggerValue.substring(oldTriggerValue.indexOf(".") + 1);
        }
        if (newTriggerValue.indexOf(".") >= 0) {
            newTriggerValue = newTriggerValue.substring(newTriggerValue.indexOf(".") + 1);
        }
        StringBuilder b = new StringBuilder("(SELECT ");
        for (Column columnType : columns) {
            column = columnType.getName();
            b.append("? as ");
            b.append("\"").append(newTriggerValue).append(column).append("\",");
        }
        for (Column columnType : columns) {
            column = columnType.getName();
            b.append("? AS ");
            b.append("\"").append(oldTriggerValue).append(column).append("\",");
        }
        b.deleteCharAt(b.length() - 1);
        b.append(" FROM DUAL) T ");
        return b.toString();
    }

    protected String eval(boolean condition, String prop, String ddl) {
        if (ddl != null) {
            String ifStmt = "$(if:" + prop + ")";
            String elseStmt = "$(else:" + prop + ")";
            String endStmt = "$(end:" + prop + ")";
            int ifIndex = ((String)ddl).indexOf(ifStmt);
            if (ifIndex >= 0) {
                int endIndex = ((String)ddl).indexOf(endStmt);
                if (endIndex >= 0) {
                    String onTrue = ((String)ddl).substring(ifIndex + ifStmt.length(), endIndex);
                    String onFalse = "";
                    int elseIndex = onTrue.indexOf(elseStmt);
                    if (elseIndex >= 0) {
                        onFalse = onTrue.substring(elseIndex + elseStmt.length());
                        onTrue = onTrue.substring(0, elseIndex);
                    }
                    ddl = condition ? ((String)ddl).substring(0, ifIndex) + onTrue + ((String)ddl).substring(endIndex + endStmt.length()) : ((String)ddl).substring(0, ifIndex) + onFalse + ((String)ddl).substring(endIndex + endStmt.length());
                } else {
                    throw new IllegalStateException(ifStmt + " has to have a " + endStmt);
                }
            }
        }
        return ddl;
    }

    protected String aliasedPrimaryKeyJoin(String aliasOne, String aliasTwo, Column[] columns) {
        StringBuilder b = new StringBuilder();
        for (int columnNo = 0; columnNo < columns.length; ++columnNo) {
            Column column = columns[columnNo];
            String quotedColumnName = SymmetricUtils.quote(this.symmetricDialect, column.getName());
            if (columnNo > 0) {
                b.append(" and ");
            }
            if (!column.isRequired()) {
                b.append("(");
            }
            b.append(aliasOne).append(".").append(quotedColumnName);
            b.append("=").append(aliasTwo).append(".").append(quotedColumnName);
            if (column.isRequired()) continue;
            b.append(" or (");
            b.append(aliasOne).append(".").append(quotedColumnName).append(" is null");
            b.append(" and ");
            b.append(aliasTwo).append(".").append(quotedColumnName).append(" is null))");
        }
        return b.toString();
    }

    protected String aliasedPrimaryKeyJoinVar(String alias, String prefix, Column[] columns) {
        StringBuilder b = new StringBuilder();
        for (int columnNo = 0; columnNo < columns.length; ++columnNo) {
            Column column = columns[columnNo];
            String quotedColumnName = SymmetricUtils.quote(this.symmetricDialect, column.getName());
            String paramName = String.format("@%spk%d", prefix, columnNo);
            if (columnNo > 0) {
                b.append(" and ");
            }
            if (!column.isRequired()) {
                b.append("(");
            }
            b.append(alias).append(".").append(quotedColumnName);
            b.append("=").append(paramName);
            if (column.isRequired()) continue;
            b.append(" or (");
            b.append(alias).append(".").append(quotedColumnName).append(" is null");
            b.append(" and ");
            b.append(paramName).append(" is null))");
        }
        return b.toString();
    }

    @Deprecated
    protected String getPrimaryKeyWhereString(String alias, Column[] columns) {
        return null;
    }

    protected boolean requiresWrappedBlobTemplateForBlobType() {
        return false;
    }

    protected boolean requiresEmptyLobTemplateForDeletes() {
        return false;
    }

    protected boolean isLob(Column column) {
        return this.symmetricDialect.getPlatform().isLob(column);
    }

    protected String buildColumnNameString(String tableAlias, boolean quote, Trigger trigger, Column[] columns) {
        StringBuilder columnsText = new StringBuilder();
        for (Column column : columns) {
            boolean isLob = this.isLob(column);
            String columnName = column.getName();
            if (quote) {
                columnName = SymmetricUtils.quote(this.symmetricDialect, columnName);
            }
            if (!isLob || !trigger.isUseStreamLobs()) {
                if (StringUtils.isNotBlank((CharSequence)tableAlias)) {
                    columnsText.append(tableAlias);
                    columnsText.append(".");
                }
                columnsText.append(columnName);
            } else {
                columnsText.append("null");
            }
            columnsText.append(",");
        }
        return columnsText.length() > 0 ? columnsText.substring(0, columnsText.length() - 1) : columnsText.toString();
    }

    protected ColumnString buildColumnsString(String origTableAlias, String tableAlias, String columnPrefix, Table table, Column[] columns, DataEventType dml, boolean isOld, Channel channel, Trigger trigger) {
        Object columnsText = "";
        boolean containsLob = false;
        String lastCommandToken = this.symmetricDialect.escapesTemplatesForDatabaseInserts() ? this.triggerConcatCharacter + "'',''" + this.triggerConcatCharacter : this.triggerConcatCharacter + "','" + this.triggerConcatCharacter;
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (column == null) continue;
            ColumnString columnString = this.fillOutColumnTemplate(origTableAlias, tableAlias, columnPrefix, table, column, dml, isOld, channel, trigger, false);
            columnsText = (String)columnsText + "\n          " + columnString.columnString + lastCommandToken;
            containsLob |= columnString.isBlobClob;
        }
        if (((String)columnsText).endsWith(lastCommandToken)) {
            columnsText = ((String)columnsText).substring(0, ((String)columnsText).length() - lastCommandToken.length());
        }
        return new ColumnString((String)columnsText, containsLob);
    }

    protected ColumnString fillOutColumnTemplate(String origTableAlias, String tableAlias, String columnPrefix, Table table, Column column, DataEventType dml, boolean isOld, Channel channel, Trigger trigger, boolean ignoreStreamLobs) {
        boolean isLob = this.isLob(column);
        String templateToUse = null;
        if (column.getJdbcTypeName() != null && column.getJdbcTypeName().toUpperCase().contains("GEOMETRY") && StringUtils.isNotBlank((CharSequence)this.geometryColumnTemplate)) {
            templateToUse = this.geometryColumnTemplate;
        } else if (column.getJdbcTypeName() != null && column.getJdbcTypeName().toUpperCase().contains("GEOGRAPHY") && StringUtils.isNotBlank((CharSequence)this.geographyColumnTemplate)) {
            templateToUse = this.geographyColumnTemplate;
        } else {
            switch (column.getMappedTypeCode()) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    templateToUse = this.numberColumnTemplate;
                    if (this.moneyColumnTemplate == null || column.getJdbcTypeName() == null || !column.getJdbcTypeName().toUpperCase().contains("MONEY")) break;
                    templateToUse = this.moneyColumnTemplate;
                    break;
                }
                case -15: 
                case -9: 
                case 1: 
                case 12: {
                    templateToUse = this.stringColumnTemplate;
                    break;
                }
                case 2009: {
                    templateToUse = this.xmlColumnTemplate;
                    break;
                }
                case 2003: {
                    templateToUse = this.arrayColumnTemplate;
                    break;
                }
                case -16: 
                case -1: {
                    if (column.getJdbcTypeName().equalsIgnoreCase("LONG") && StringUtils.isNotBlank((CharSequence)this.longColumnTemplate)) {
                        templateToUse = this.longColumnTemplate;
                        isLob = false;
                        break;
                    }
                    if (!isLob) {
                        templateToUse = this.stringColumnTemplate;
                        templateToUse = FormatUtils.replace((String)"columnSizeOrMax", (String)"max", (String)templateToUse);
                        break;
                    }
                }
                case 2005: 
                case 2011: {
                    if (isOld && this.symmetricDialect.needsToSelectLobData()) {
                        templateToUse = this.emptyColumnTemplate;
                        break;
                    }
                    templateToUse = this.clobColumnTemplate;
                    break;
                }
                case -3: 
                case -2: {
                    if (StringUtils.isNotBlank((CharSequence)this.binaryColumnTemplate)) {
                        templateToUse = this.binaryColumnTemplate;
                        break;
                    }
                }
                case 2004: {
                    if (this.requiresWrappedBlobTemplateForBlobType()) {
                        templateToUse = this.wrappedBlobColumnTemplate;
                        break;
                    }
                }
                case -10: 
                case -4: {
                    if (column.getJdbcTypeName() != null && column.getJdbcTypeName().toUpperCase().contains("IMAGE") && StringUtils.isNotBlank((CharSequence)this.imageColumnTemplate)) {
                        if (isOld) {
                            templateToUse = this.emptyColumnTemplate;
                            break;
                        }
                        templateToUse = this.imageColumnTemplate;
                        break;
                    }
                    if (isOld && this.symmetricDialect.needsToSelectLobData()) {
                        templateToUse = this.emptyColumnTemplate;
                        break;
                    }
                    templateToUse = this.blobColumnTemplate;
                    break;
                }
                case 91: {
                    if (this.noDateColumnTemplate()) {
                        templateToUse = this.datetimeColumnTemplate;
                        break;
                    }
                    templateToUse = this.dateColumnTemplate;
                    break;
                }
                case 92: {
                    if (this.noTimeColumnTemplate()) {
                        templateToUse = this.datetimeColumnTemplate;
                        break;
                    }
                    templateToUse = this.timeColumnTemplate;
                    break;
                }
                case 93: {
                    templateToUse = this.datetimeColumnTemplate;
                    break;
                }
                case -7: 
                case 16: {
                    templateToUse = this.booleanColumnTemplate;
                    break;
                }
                case -8: {
                    templateToUse = this.stringColumnTemplate;
                    break;
                }
                default: {
                    if (column.getJdbcTypeName() != null) {
                        if (column.getJdbcTypeName().toUpperCase().equals("INTERVAL")) {
                            templateToUse = this.numberColumnTemplate;
                            break;
                        }
                        if (column.getMappedType().equals("TIMESTAMPTZ") && StringUtils.isNotBlank((CharSequence)this.dateTimeWithTimeZoneColumnTemplate)) {
                            templateToUse = this.dateTimeWithTimeZoneColumnTemplate;
                            break;
                        }
                        if (column.getMappedType().equals("TIMESTAMPLTZ") && StringUtils.isNotBlank((CharSequence)this.dateTimeWithLocalTimeZoneColumnTemplate)) {
                            templateToUse = this.dateTimeWithLocalTimeZoneColumnTemplate;
                            break;
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)templateToUse) && StringUtils.isNotBlank((CharSequence)this.otherColumnTemplate)) {
                        templateToUse = this.otherColumnTemplate;
                        break;
                    }
                    throw new NotImplementedException(column.getName() + " is of type " + column.getMappedType() + " with JDBC type of " + column.getJdbcTypeName());
                }
            }
        }
        if (dml == DataEventType.DELETE && isLob && this.requiresEmptyLobTemplateForDeletes()) {
            templateToUse = this.emptyColumnTemplate;
        } else if (isLob && trigger.isUseStreamLobs() && !ignoreStreamLobs) {
            templateToUse = this.emptyColumnTemplate;
        }
        if (templateToUse == null) {
            throw new NotImplementedException(table.toString() + " " + column.toString());
        }
        templateToUse = this.adjustColumnTemplate(templateToUse, column.getMappedTypeCode());
        templateToUse = templateToUse.trim();
        String formattedColumnText = FormatUtils.replace((String)"columnSizeOrMax", (String)(trigger.isUseCaptureLobs() ? "max" : "$(columnSize)"), (String)templateToUse);
        formattedColumnText = FormatUtils.replace((String)"columnName", (String)String.format("%s%s", columnPrefix, column.getName()), (String)formattedColumnText);
        formattedColumnText = FormatUtils.replace((String)"columnSize", (String)this.getColumnSize(table, column), (String)formattedColumnText);
        formattedColumnText = FormatUtils.replace((String)"masterCollation", (String)this.symmetricDialect.getMasterCollation(), (String)formattedColumnText);
        if (isLob) {
            formattedColumnText = this.symmetricDialect.massageForLob(formattedColumnText, channel != null ? channel.isContainsBigLob() : true);
        }
        formattedColumnText = FormatUtils.replace((String)"origTableAlias", (String)origTableAlias, (String)formattedColumnText);
        formattedColumnText = FormatUtils.replace((String)"tableAlias", (String)tableAlias, (String)formattedColumnText);
        formattedColumnText = FormatUtils.replace((String)"prefixName", (String)this.symmetricDialect.getTablePrefix(), (String)formattedColumnText);
        return new ColumnString(formattedColumnText, isLob);
    }

    protected String getColumnSize(Table table, Column column) {
        return column.getSize();
    }

    public String getOtherColumnTemplate() {
        return this.otherColumnTemplate;
    }

    protected boolean noTimeColumnTemplate() {
        return this.timeColumnTemplate == null || this.timeColumnTemplate.equals("null") || this.timeColumnTemplate.trim().equals("");
    }

    protected boolean noDateColumnTemplate() {
        return this.dateColumnTemplate == null || this.dateColumnTemplate.equals("null") || this.dateColumnTemplate.trim().equals("");
    }

    protected String adjustColumnTemplate(String template, int typeCode) {
        return template;
    }

    protected String buildKeyVariablesDeclare(Column[] columns, String prefix) {
        Object text = "";
        block13: for (int i = 0; i < columns.length; ++i) {
            text = (String)text + "declare @" + prefix + "pk" + i + " ";
            switch (columns[i].getMappedTypeCode()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    text = (String)text + "bigint\n";
                    continue block13;
                }
                case 2: 
                case 3: {
                    text = (String)text + "decimal\n";
                    continue block13;
                }
                case 6: 
                case 7: 
                case 8: {
                    text = (String)text + "float\n";
                    continue block13;
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    text = (String)text + "varchar(1000)\n";
                    continue block13;
                }
                case 91: {
                    text = (String)text + "date\n";
                    continue block13;
                }
                case 92: {
                    text = (String)text + "time\n";
                    continue block13;
                }
                case 93: {
                    text = (String)text + "datetime\n";
                    continue block13;
                }
                case -7: 
                case 16: {
                    text = (String)text + "bit\n";
                    continue block13;
                }
                case 2005: {
                    text = (String)text + "varchar(max)\n";
                    continue block13;
                }
                case -10: 
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    text = (String)text + "varbinary(max)\n";
                    continue block13;
                }
                case 1111: {
                    text = (String)text + "varbinary(max)\n";
                    continue block13;
                }
                default: {
                    if (columns[i].getJdbcTypeName() != null && columns[i].getJdbcTypeName().equalsIgnoreCase("interval")) {
                        text = (String)text + "interval";
                        continue block13;
                    }
                    throw new NotImplementedException(columns[i] + " is of type " + columns[i].getMappedType());
                }
            }
        }
        return text;
    }

    protected String buildKeyVariablesString(Column[] columns, String prefix) {
        Object text = "";
        for (int i = 0; i < columns.length; ++i) {
            text = (String)text + "@" + prefix + "pk" + i;
            if (i + 1 >= columns.length) continue;
            text = (String)text + ", ";
        }
        return text;
    }

    public String getClobColumnTemplate() {
        return this.clobColumnTemplate;
    }

    public void setBooleanColumnTemplate(String booleanColumnTemplate) {
        this.booleanColumnTemplate = booleanColumnTemplate;
    }

    public String getNewTriggerValue() {
        return this.newTriggerValue;
    }

    public String getOldTriggerValue() {
        return this.oldTriggerValue;
    }

    public String getBlobColumnTemplate() {
        return this.blobColumnTemplate;
    }

    public String getWrappedBlobColumnTemplate() {
        return this.wrappedBlobColumnTemplate;
    }

    protected String replaceDefaultSchema(String ddl, String defaultSchema) {
        ddl = StringUtils.isNotBlank((CharSequence)defaultSchema) ? FormatUtils.replace((String)"defaultSchema", (String)(SymmetricUtils.quote(this.symmetricDialect, defaultSchema) + "."), (String)ddl) : FormatUtils.replace((String)"defaultSchema", (String)"", (String)ddl);
        return ddl;
    }

    protected String replaceDefaultCatalog(String ddl, String defaultCatalog) {
        ddl = StringUtils.isNotBlank((CharSequence)defaultCatalog) ? FormatUtils.replace((String)"defaultCatalog", (String)(SymmetricUtils.quote(this.symmetricDialect, defaultCatalog) + "."), (String)ddl) : FormatUtils.replace((String)"defaultCatalog", (String)"", (String)ddl);
        return ddl;
    }

    public String getTimeColumnTemplate() {
        return this.timeColumnTemplate;
    }

    public void setTimeColumnTemplate(String timeColumnTemplate) {
        this.timeColumnTemplate = timeColumnTemplate;
    }

    public String getDateColumnTemplate() {
        return this.dateColumnTemplate;
    }

    public void setDateColumnTemplate(String dateColumnTemplate) {
        this.dateColumnTemplate = dateColumnTemplate;
    }

    public String getImageColumnTemplate() {
        return this.imageColumnTemplate;
    }

    public void setImageColumnTemplate(String imageColumnTemplate) {
        this.imageColumnTemplate = imageColumnTemplate;
    }

    public int toHashedValue() {
        if (this.hashedValue == 0 && this.sqlTemplates != null) {
            Field[] fields;
            for (String key : this.sqlTemplates.keySet()) {
                this.hashedValue += this.sqlTemplates.get(key).hashCode();
            }
            for (Field field : fields = this.getClass().getSuperclass().getDeclaredFields()) {
                field.setAccessible(true);
                if (!field.getType().equals(String.class)) continue;
                try {
                    String value = (String)field.get(this);
                    if (value == null) continue;
                    this.hashedValue += value.hashCode();
                }
                catch (Exception e) {
                    this.log.warn("Failed to get hash code for field " + field.getName());
                }
            }
        }
        return this.hashedValue;
    }

    public String replaceOracleQueryHint(String sql) {
        return FormatUtils.replace((String)"oracleQueryHint", (String)(this.symmetricDialect.getParameterService().getInt("oracle.load.query.hint.parallel.count") > 1 ? "/*+ parallel(" + this.symmetricDialect.getParameterService().getString("oracle.load.query.hint.parallel.count") + ") */" : ""), (String)sql);
    }

    protected String getHasPrimaryKeysDefinedString(Table table) {
        return table.hasPrimaryKey() ? "1=1" : "1=2";
    }

    protected String getPrimaryKeysUpdatedString(Table table) {
        StringBuilder sb = new StringBuilder();
        for (String primaryKey : table.getPrimaryKeyColumnNames()) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            } else {
                sb.append("(");
            }
            sb.append(" UPDATE(").append(SymmetricUtils.quote(this.symmetricDialect, primaryKey)).append(") ");
        }
        if (sb.length() > 0) {
            sb.append(")");
        }
        if (sb.length() > 0) {
            sb.insert(0, " AND ");
        }
        return sb.toString();
    }

    protected String getCreateTriggerString() {
        return "create trigger";
    }

    protected static class ColumnString {
        public String columnString;
        public boolean isBlobClob = false;

        public ColumnString(String columnExpression, boolean isBlobClob) {
            this.columnString = columnExpression;
            this.isBlobClob = isBlobClob;
        }

        public String toString() {
            return StringUtils.isBlank((CharSequence)this.columnString) ? "null" : this.columnString;
        }
    }
}

