/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.file;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jumpmind.symmetric.model.FileSnapshot;
import org.jumpmind.symmetric.model.FileTriggerRouter;

public class DirectorySnapshot
extends ArrayList<FileSnapshot> {
    private static final long serialVersionUID = 1L;
    private FileTriggerRouter fileTriggerRouter;

    public DirectorySnapshot(FileTriggerRouter fileTriggerRouter, List<FileSnapshot> snapshot) {
        this(fileTriggerRouter);
        this.addAll(snapshot);
    }

    public DirectorySnapshot(FileTriggerRouter fileTriggerRouter) {
        this.fileTriggerRouter = fileTriggerRouter;
    }

    protected void merge(DirectorySnapshot snapshot) {
        HashSet<FileSnapshot> toAdd = new HashSet<FileSnapshot>();
        HashSet<FileSnapshot> toRemove = new HashSet<FileSnapshot>();
        for (FileSnapshot fileChange : snapshot) {
            for (FileSnapshot file : this) {
                if (!fileChange.getFileName().equals(file.getFileName())) continue;
                toRemove.add(file);
                if (fileChange.getLastEventType() != FileSnapshot.LastEventType.MODIFY) continue;
                toAdd.add(fileChange);
            }
        }
        for (FileSnapshot fileChange : toRemove) {
            if (fileChange.getLastEventType() != FileSnapshot.LastEventType.CREATE) continue;
            toAdd.add(fileChange);
        }
        this.removeAll(toRemove);
        this.addAll(toAdd);
    }

    public DirectorySnapshot diff(DirectorySnapshot anotherSnapshot) {
        HashMap<String, FileSnapshot> thisDirectoryDeltaMap = new HashMap<String, FileSnapshot>();
        for (FileSnapshot fileSnapshot : this) {
            thisDirectoryDeltaMap.put(fileSnapshot.generateSearchKey(), fileSnapshot);
        }
        HashMap<String, FileSnapshot> anotherDirectoryDeltaMap = new HashMap<String, FileSnapshot>();
        DirectorySnapshot differences = new DirectorySnapshot(anotherSnapshot.getFileTriggerRouter());
        for (FileSnapshot fileSnapshot : anotherSnapshot) {
            String key = fileSnapshot.generateSearchKey();
            FileSnapshot knownFile = (FileSnapshot)thisDirectoryDeltaMap.get(key);
            if (knownFile == null) {
                differences.add(fileSnapshot);
                anotherDirectoryDeltaMap.put(key, fileSnapshot);
                continue;
            }
            thisDirectoryDeltaMap.remove(key);
            if ((knownFile.getLastEventType() == FileSnapshot.LastEventType.MODIFY || knownFile.getLastEventType() == FileSnapshot.LastEventType.CREATE) && fileSnapshot.getLastEventType() == FileSnapshot.LastEventType.CREATE) {
                knownFile.setLastEventType(FileSnapshot.LastEventType.MODIFY);
                fileSnapshot.setLastEventType(FileSnapshot.LastEventType.MODIFY);
            }
            if (fileSnapshot.equals(knownFile)) continue;
            differences.add(fileSnapshot);
        }
        for (Map.Entry entry : thisDirectoryDeltaMap.entrySet()) {
            FileSnapshot file = (FileSnapshot)entry.getValue();
            if (file.getLastEventType() == FileSnapshot.LastEventType.DELETE) continue;
            FileSnapshot copy = new FileSnapshot(file);
            copy.setLastEventType(FileSnapshot.LastEventType.DELETE);
            differences.add(copy);
        }
        thisDirectoryDeltaMap.clear();
        anotherDirectoryDeltaMap.clear();
        return differences;
    }

    public FileTriggerRouter getFileTriggerRouter() {
        return this.fileTriggerRouter;
    }
}

